<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/* Member post type */
if( !function_exists( 'pe_create_member_post_type' ) ){
	function pe_create_member_post_type(){
		$labels = array(
			'name'								=> __('Members','pe-services-plugin'),
			'singular_name'						=> __('Member','pe-services-plugin' ),
			'add_new'							=> __('Add New','pe-services-plugin'),
			'add_new_item'						=> __('Add New Member','pe-services-plugin'),
			'edit_item'							=> __('Edit Member','pe-services-plugin'),
			'new_item'							=> __('New Member','pe-services-plugin'),
			'view_item'							=> __('View Member','pe-services-plugin'),
			'search_items'						=> __('Search Member','pe-services-plugin'),
			'not_found'							=> __('No Member found','pe-services-plugin'),
			'not_found_in_trash'				=> __('No Member found in Trash','pe-services-plugin'),
			'parent_item_colon'					=> ''
		);

		$args = array(
			'labels' 							=> $labels,
			'public' 							=> true,
			'exclude_from_search' => true,
			'publicly_queryable' 	=> true,
			'show_ui' 						=> true,
			'query_var' 					=> true,
			'capability_type' 		=> 'post',
			'hierarchical' 				=> false,
			'menu_position' 			=> 5,
			'menu_icon'						=> get_template_directory_uri().'/images/admin/members.png',
			'show_in_nav_menus'		=> true,
			'supports' 						=> array('title','editor','thumbnail','revisions'),
			'rewrite' 						=> array( 'slug' => __('member', 'pe-services-plugin') )
		);

		register_post_type('member',$args);
	}
}
add_action( 'init', 'pe_create_member_post_type' );

/* Edit Default Columns */
if( !function_exists( 'pe_member_edit_columns' ) ){
    function pe_member_edit_columns($columns)
    {

        $columns = array(
            "cb" 			=> "<input type=\"checkbox\" />",
            "title" 		=> __('Member','pe-services-plugin'),
            "position" 		=> __('Member Proffesion','pe-services-plugin'),
            "date" 			=> __('Date','pe-services-plugin')
        );

        return $columns;
    }
}
add_filter('manage_edit-member_columns', 'pe_member_edit_columns');

/* Add Custom Column */
if( !function_exists( 'pe_member_custom_columns' ) ){
	function pe_member_custom_columns($column){  
			global $post;  
			
			$position = get_post_meta($post->ID, 'member_profession',true);
			$custom_position = get_post_meta($post->ID, 'member_custom_profession',true);
			
			$member_professions_check = (is_array($position)) ? true : false;
			$member_custom_profession_check = (!empty($custom_position)) ? true : false;
			
			$commaList = '';
			
			if( $member_professions_check || $member_custom_profession_check ) {
				if($member_professions_check) {
					foreach($position as $post) {
						$title[] = get_the_title($post);
					}
					$commaList = implode(', ', $title);
					if(!empty($custom_position)) {
						$commaList .= ', ';
					}
				}
				if(!empty($custom_position)) {
					$commaList .= $custom_position;
				} 
			} else {
				$commaList = __('No professions provided','pe-services-plugin');
			}
			
			switch ($column) {  
					case 'position':
					if(!empty($commaList)) {
						echo $commaList;
					}
	        break;
	    } 
	}
}
add_action('manage_member_posts_custom_column',  'pe_member_custom_columns');

/* image box */
if( !function_exists( 'pe_member_image_box' ) ){
	function pe_member_image_box() {
		remove_meta_box( 'postimagediv', 'member', 'side' );
		add_meta_box('postimagediv', __('Avatar image', 'pe-services-plugin'), 'post_thumbnail_meta_box', 'member', 'side', 'low');
	}
}
add_action('do_meta_boxes', 'pe_member_image_box');

/* title text */
if( !function_exists( 'pe_member_enter_title' ) ){
	function pe_member_enter_title( $input ) {
			global $post_type;

			if ( is_admin() && 'member' == $post_type )
					return __( 'Enter Member Name here', 'pe-services-plugin' );
			return $input;
	}
}
add_filter( 'enter_title_here', 'pe_member_enter_title' );

?>