/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

// Google Maps

(function($) {

	"use strict";

	/* -------------------------------------------------------- */
	/* FUNCTIONS                                                */
	/* -------------------------------------------------------- */

	$(document).ready(function(){
		if( $('.pe_map_canvas').length ) { //load only if needed
			//console.log('Map needed');
			if (window.google && google.maps) {
				// Map script is already loaded
				initializeMap();
			} else {
				//Lazy loading Google Map API
				lazyLoadGoogleMap();
			}
		}
	});

	function lazyLoadGoogleMap() {
		var script = '//maps.google.com/maps/api/js?sensor=true&callback=initializeMap';
		if( typeof pemaps !== 'undefined' ) {
			script = '//maps.google.com/maps/api/js?key=' + pemaps.key + '&sensor=true&callback=initializeMap';
		} else {
			window.pemaps = {};
		}
		$.getScript(script)
		.done(function (script, textStatus) {
			//console.log("Google map script loaded successfully");
		})
		.fail(function (jqxhr, settings, ex) {
			//console.log("Could not load Google Map script: " + jqxhr);
		});
	}

	function initializeMap() {
		$('.pe_map_canvas').each(function() {
			var mapID = $(this).attr('id');
			var zoom = parseInt( $(this).attr('data-zoom') );
			var latitude = $(this).attr('data-lat');
			var longitude = $(this).attr('data-lng');
			var scroll = $(this).attr('data-scroll');
			var control = $(this).attr('data-control');
			var tooltip = $(this).attr('data-tooltip');

			var options = {
						zoom: zoom,
						center: new google.maps.LatLng(latitude, longitude),
						scrollwheel: scroll,
						disableDefaultUI: control,
						mapTypeId: google.maps.MapTypeId.ROADMAP
					}

			var location = new google.maps.LatLng(latitude, longitude);
			var bounds = new google.maps.LatLngBounds();
			var map = new google.maps.Map(document.getElementById(mapID), options);
			var marker = new google.maps.Marker({
				position: location,
				map: map,
			});

			if( tooltip && tooltip != 'disable' ) {
				// add tootltip
				var infoWindow = new google.maps.InfoWindow({
					content: tooltip,
				});
				infoWindow.open(mapID, marker);
				google.maps.event.addListener(marker, 'click', function () {
					infoWindow.open(mapID, marker);
				});
			}

			//create object
			window.pemaps[mapID] = {
				map: map,
				marker: marker,
				infoWindow: infoWindow,
				tooltip: tooltip,
			}

		});
	}
	window.initializeMap = initializeMap;

})(jQuery);
