<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
/**
 * Plugin Name: PE Services Plugin
 * Plugin URI: http://pixelemu.com
 * Description: Taxonomies and shortcodes for PE Services Theme
 * Version: 1.3
 * Author: pixelemu.com
 * Author URI: http://www.pixelemu.com
 * Text Domain: PixelEmu
 * License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 */

/*-----------------------------------------------------------------------------------*/
/*	LESS compiler
/*-----------------------------------------------------------------------------------*/

if( !class_exists('Less_Autoloader') ) {
	include plugin_dir_path( __FILE__ ) . 'less-compiler/Autoloader.php';
	Less_Autoloader::register();
}

/*-----------------------------------------------------------------------------------*/
/*	Languages
/*-----------------------------------------------------------------------------------*/

add_action('plugins_loaded', 'pe_services_load_textdomain');
function pe_services_load_textdomain() {
	load_plugin_textdomain( 'pe-services-plugin', false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
}

/*-----------------------------------------------------------------------------------*/
/*	Update checker
/*-----------------------------------------------------------------------------------*/

include (plugin_dir_path( __FILE__ ) . 'update.php');

/*-----------------------------------------------------------------------------------*/
/*	Shortcode generator
/*-----------------------------------------------------------------------------------*/

include (plugin_dir_path( __FILE__ ) . 'shortcodes.php');

/*-----------------------------------------------------------------------------------*/
/*	Shortcode Clean Function
/*-----------------------------------------------------------------------------------*/

add_filter('the_content', 'pe_clean_shortcodes');
if (!function_exists('pe_clean_shortcodes')) {
	function pe_clean_shortcodes( $content ){
		// array of custom shortcodes requiring the fix (no affect to 3rd party shortcodes)
		$block = join('|',array('accordion','row','col', 'headline', 'pricing_table', 'tabs', 'tab', 'testimonial' ));
		// opening tag
		$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);

		// closing tag
		$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
		return $rep;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Include Custom Post Types
/*-----------------------------------------------------------------------------------*/

include("custom-posts/member-post-type.php");
include("custom-posts/faq-post-type.php");
include("custom-posts/service-post-type.php");
include("custom-posts/testimonial-post-type.php");

/*-----------------------------------------------------------------------------------*/
/*	Include Shortcodes
/*-----------------------------------------------------------------------------------*/

include 'shortcodes/animation.php';
include 'shortcodes/pricing-table.php';
include 'shortcodes/accordion.php';
include 'shortcodes/tabs.php';
include 'shortcodes/columns.php';
include 'shortcodes/testimonials.php';
include 'shortcodes/video-gallery.php';
include 'shortcodes/image-gallery.php';
include 'shortcodes/pe_map.php';
include 'shortcodes/pe_headline.php';
include 'shortcodes/br.php';

/*-----------------------------------------------------------------------------------*/
//	reCaptcha
/*-----------------------------------------------------------------------------------*/

add_action( 'after_setup_theme', 'pe_services_captcha' );
function pe_services_captcha() {
	if( function_exists('peGetOptions') ) {
		$reCaptcha = ( peGetOptions('google-captcha-api') && peGetOptions('google-captcha-sitekey') && peGetOptions('google-captcha-secretkey') ) ? true : false;
		if( $reCaptcha ) {
			require_once 'captcha/autoload.php';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
//	Scripts
/*-----------------------------------------------------------------------------------*/

add_action( 'admin_enqueue_scripts', 'pe_enqueueWidgetsAdmin' );
function pe_enqueueWidgetsAdmin( $hook ) {
	if( $hook != 'widgets.php' ) return;
	wp_enqueue_script( 'pe-multifields-admin', plugin_dir_url( __FILE__ ) . 'js/multifields-admin.js', array('jquery'), false );
}

add_action( 'wp_enqueue_scripts', 'pe_enqueueScripts' );
function pe_enqueueScripts( ) {
	wp_enqueue_script( 'pe-map', plugin_dir_url( __FILE__ ) . 'js/map.js', array('jquery'), '', true );
}

/*-----------------------------------------------------------------------------------*/
//	Custom HTML
/*-----------------------------------------------------------------------------------*/

add_action( 'wp_head', 'pe_customCodeHead' );
if( !function_exists('pe_customCodeHead') ) {
	function pe_customCodeHead() {
		$head_code = peGetOptions('head-custom-code');
		if ( !empty($head_code) ) {
			echo peGetOptions('head-custom-code');
		}
	}
}

add_action( 'wp_footer', 'pe_customCodeBody', 99 );
if( !function_exists('pe_customCodeBody') ) {
	function pe_customCodeBody() {
		$footer_code = peGetOptions('body-custom-code');
		if( !empty($footer_code) ) {
			echo peGetOptions('body-custom-code');
		}
	}
}

?>
