<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
 ---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*  Video Gallery
/*-----------------------------------------------------------------------------------*/

add_shortcode('pevideo', 'video_shortcode');
add_shortcode('pe_video', 'video_shortcode');

if ( !function_exists('video_shortcode') ) {
	function video_shortcode($atts, $content = null ) {
		$a = shortcode_atts(array(
			'web'   => 'youtube',
			'id'    => '',
			'fs'    => '1',
			'size'  => '',
			'title' => ''
		), $atts);

		$size = ( !empty($a['size']) ) ? sanitize_html_class( $a['size'] ) : '12';
		$video = ( !empty($a['id']) ) ? $a['id'] : false; //id or url
		$videofs = ($a['fs'] == 1) ? 'allowfullscreen' : '';
		$title = ( !empty($a['title']) ) ? 'title="' . esc_html($a['title']) . '"'  : '';

		//output
		$output = '<div class="item col-md-' . $size . '">';
		$output .= '<figure class="pe_video embed-responsive embed-responsive-16by9">';

		if (!filter_var($video, FILTER_VALIDATE_URL) === false || substr( $video, 0, 2 ) == "//") { //video-url
			$output .= '<iframe src="' . esc_url( $video ) . '" ' . $title . ' ' . $videofs . '></iframe>';
		} else { //video-id
			if ($a['web'] == 'vimeo') {
				$output .= '<iframe src="//player.vimeo.com/video/' . esc_attr( $video ) . '" ' . $title . ' ' . $videofs . '></iframe>';
			} else { //default youtube
				$output .= '<iframe src="//www.youtube.com/embed/' . esc_attr( $video ) . '" ' . $title . ' ' . $videofs . '></iframe>';
			}
		}

		$output .= '</figure>';
		$output .= '</div>';

		return $output;

	}
}

?>
