<?php
/*--------------------------------------------------------------
Copyright (C) pixelemu.com
License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
Website: http://www.pixelemu.com
Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$font_sizer_archive = peGetOptions('font-sizer-archive');

$highContrast = peGetOptions('highContrast');

/* Page Head */

$header_title = __('Archives', 'pe-services');
$header_details = '';

//$post = $posts[0]; // Hack. Set $post so that the_date() works.

if (is_category())
{
	$header_title = __('All Posts in Category', 'pe-services');
	$header_details = single_cat_title('',false);
}
elseif( is_tag() )
{
	$header_title = __('All Posts in Tag', 'pe-services');
	$header_details = single_tag_title('',false);
}
elseif (is_day())
{
	$header_title = __('Archives', 'pe-services');
	$header_details = get_the_date();
}
elseif (is_month())
{
	$header_title = __('Archives', 'pe-services');
	$header_details = get_the_date('F Y');
}
elseif (is_year())
{
	$header_title = __('Archives', 'pe-services');
	$header_details = get_the_date('Y');
}
elseif (is_author())
{
	$curauth = $wp_query->get_queried_object();
	$header_title = __('All Posts By', 'pe-services');
	$header_details = $curauth->display_name;
}
elseif (isset($_GET['paged']) && !empty($_GET['paged']))
{
	$header_title = __('Archives', 'pe-services');
	$header_details = '';
}
?>

<div id="pe-content" class="pe-archive">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<div itemscope="" itemtype="http://schema.org/Blog">

						<?php get_template_part( 'loop' ); ?>

					</div>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php get_footer(); ?>