<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/
?>

<?php if (post_password_required()) : ?>

<div id="comments">
	<p class="pe-warning"><?php _e('This post is password protected. Enter the password to view any comments.', 'pe-services'); ?></p>
</div>

<?php
return;/* skip */
endif;
?>


<?php if (have_comments() || comments_open()) : ?>
<?php //die('comment'); ?>
<div class="pe-comments comments-area comments">

	<?php if (have_comments()) : ?>

	<h3 class="comments-title">
		<?php
		printf( _n( 'One comment for &ldquo;%2$s&rdquo;', '%1$s comments on &ldquo;%2$s&rdquo;', get_comments_number(), 'pe-services' ),
					 number_format_i18n( get_comments_number() ), 
					 '<span>' . get_the_title() . '</span>' );
		?>
	</h3>

	<ul class="comment-list">
		<?php wp_list_comments( array( 'type' => 'all', 'callback' => 'pe_comment', 'style' => 'ul', 'avatar_size' => get_option( 'thumbnail_size_w' ), ) ); ?>
	</ul>

	<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
	<nav id="comment-nav-below" class="navigation" role="navigation">
		<h3 class="assistive-text section-heading"><?php _e( 'Comment navigation', 'pe-services' ); ?></h3>
		<div class="nav-previous"><?php previous_comments_link( __( '&larr; Older Comments', 'pe-services' ) ); ?></div>
		<div class="nav-next"><?php next_comments_link( __( 'Newer Comments &rarr;', 'pe-services' ) ); ?></div>
	</nav>
	<?php endif; ?>

	<?php if ( ! comments_open() && get_comments_number() ) : ?>
	<p class="pe-warning"><?php _e( 'Comments are closed.' , 'pe-services' ); ?></p>
	<?php endif; ?>

	<?php endif; // have_comments() ?>

	<?php 
	$commenter = wp_get_current_commenter();
	$req = get_option( 'require_name_email' );
	$aria_req = ( $req ? " aria-required='true'" : '' );

	$pe_comments_args = array(
		/* Title */
		'title_reply' => __('Leave Comment','pe-services'),

		/* After Notes */
		'comment_notes_after'	 => '',

		/* Before Notes */
		'comment_notes_before' => '',

		/* Submit */
		'label_submit' => __( 'Submit Comment' , 'pe-services'),
		'class_submit' => 'button ',

		/* Logged In */
		'logged_in_as' => '<p class="pe-info">'. sprintf(__('You are logged in as %1$s. %2$sLog out %3$s', 'pe-services'), '<a href="'.get_option('siteurl').'/wp-admin/profile.php">'.$user_identity.'</a>', '<a href="'.(function_exists('wp_logout_url') ? wp_logout_url(get_permalink()) : get_option('siteurl').'/wp-login.php?action=logout" title="').'" title="'.__('Log Out', 'pe-services').'">', '</a>') . '</p>',

		/* Comment Field */
		'comment_field' => '<div class="pe-form-group row"><div class="comment-form-content col-sm-12"><label for="comment" class="sr-only">' . __('Comment','pe-services'). '</label><textarea class="required form-control" name="comment" id="comment" rows="4" placeholder="' . __( 'Comment', 'pe-services' ).'"></textarea></div></div>',

		'fields' => apply_filters( 'comment_form_default_fields', array(

			'author' => '<div class="pe-form-group row">' . '<div class="comment-form-author col-sm-6" >' . '<label for="author" class="sr-only">'.__( 'Name', 'pe-services' ).'</label> ' . '<input class="form-control" id="author" name="author" type="text" '. $aria_req .' placeholder="'.__( 'Name', 'pe-services' ).'" value="' . esc_attr( $commenter['comment_author'] ) .'" size="30" /></div>',

			'email' => '<div class="comment-form-email col-sm-6" ><label for="email" class="sr-only">' . __( 'Email', 'pe-services' ).'</label> ' . '<input class="form-control" id="email" name="email" type="text" '. $aria_req .' placeholder="'.__( 'Email', 'pe-services' ).'" value="'. esc_attr(	$commenter['comment_author_email'] ) . '" size="30" /></div></div>',

			'url' => '<div class="pe-form-group row"><div class="comment-form-url col-sm-12"><label for="url" class="sr-only"><strong>' . __( 'Website', 'pe-services' ) . '</strong></label>' . '<input class="form-control" id="url" name="url" type="text" placeholder="'.__( 'Website', 'pe-services' ).'"	value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></div></div>'

		)
														 ),
	);
	comment_form( $pe_comments_args );
	?>

</div>

<?php
endif;
?>
