<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$backtotop = peGetOptions('back-to-top');
$copyrights = peGetOptions('copyright-info');
$copyrights_info = peGetOptions('copyright-info-text');
$pixelemu_copyright = peGetOptions('pixelemu-copyright');

$social_widget = (is_active_sidebar('social')) ? true : false;

$highContrast = peGetOptions('highContrast');

//get span
if($copyrights && $pixelemu_copyright && $social_widget) {
	$footer_class = 'col-md-4';
} elseif(($copyrights && $pixelemu_copyright) ||
				 ($copyrights && $social_widget) ||
				 ($pixelemu_copyright && $social_widget)) {
	$footer_class = 'col-md-6';
} else {
	$footer_class = 'col-md-12';
}

?>

<?php get_template_part( 'tpl/bottom' ); ?>

<?php get_template_part( 'tpl/footer-mod' ); ?>

<footer id="pe-footer" <?php if(peGetOptions('footer-label')) echo 'aria-label="' . peGetOptions('footer-label') . '"'; ?>>

	<!-- Copyright/ powered by / back to top -->
	<?php if ( ( $copyrights ) or ( $pixelemu_copyright ) ) :?>
	<div id="pe-copyright" class="container-fluid">
		<div class="row">
			<?php if( $copyrights ) : ?>
			<div id="pe-copyrights-info" class="pull-left text-left <?php echo $footer_class ?>">
				<?php echo $copyrights_info; ?>
			</div>
			<?php endif; ?>

			<?php if(is_active_sidebar('social')) : ?>
			<div id="pe-social" class="pull-left text-center <?php echo $footer_class ?>">
				<?php dynamic_sidebar( 'social' ); ?>
			</div>
			<?php endif; ?>

			<?php if( $pixelemu_copyright ) : ?>
			<div id="pixelemu-copyrights" class="pull-right text-right <?php echo $footer_class ?>">
				<p>
					<?php _e('Designed by','pe-services'); ?> <a href="<?php _e('https://pixelemu.com','pe-services'); ?>" target="_blank" rel="nofollow"><?php _e('pe-services', 'pe-services'); ?></a>
				</p>
			</div>
			<?php endif; ?>

		</div>
	</div>
	<?php endif; ?>

	<?php if( $backtotop ) : ?>
	<div id="pe-back-top">
		<a id="backtotop" href="#" <?php if($highContrast) echo 'role="button"'; ?>><span class="fa fa-chevron-up" aria-hidden="true"></span><span class="sr-only"><?php _e('Back to top', 'pe-services'); ?></span></a>
	</div>
	<?php endif; ?>

</footer>

</div> <!-- end of pe-main wrapper -->

<?php get_template_part( 'tpl/offcanvas' ); ?>

<?php wp_footer(); ?>

</body> <!-- end of body -->

</html> <!-- end of html -->
