<?php
/*--------------------------------------------------------------
Copyright (C) pixelemu.com
License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
Website: http://www.pixelemu.com
Support: info@pixelemu.com
---------------------------------------------------------------*/

//grid
get_template_part( 'layout-options' );

$favicon = peGetOptions('favicon','url');

$sticky_topbar = (peGetOptions('sticky-topbar')) ? 'sticky-bar' : '';
$offcanvas_side = (peGetOptions('off-canavs-position')) ? 'off-canvas-' . peGetOptions('off-canavs-position') : '';

//wcag
$nightVersion = peGetOptions('nightVersion');
$highContrast = peGetOptions('highContrast');
$wideSite = peGetOptions('wideSite');
$fontSizeSwitcher = peGetOptions('fontSizeSwitcher');

$wcagMode = ( $highContrast ) ? 'wcag-on' : 'wcag-off';

$wcagFocus = peGetOptions('wcagFocus');
$wcagAnimation = peGetOptions('wcagAnimation');

$wcagfocusclass = ( $wcagFocus ) ? 'wcagfocus' : '';
$wcaganimationclass = ( $wcagAnimation ) ? 'wcaganimation' : '';

//top-bar
$topbar_sidebar = ( is_active_sidebar('top-bar-menu') || $nightVersion || $highContrast || $wideSite || $fontSizeSwitcher) ? 'top-bar' : '';

$contrast = PEwcag::getContrast();
$width = PEwcag::getWidth();
$fsize = PEwcag::getFont();

?>
<!DOCTYPE html>

<html <?php language_attributes(); // language attributes ?>>

	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); // address pingback ?>">
		<!--[if lt IE 9]>
		<script src="<?php echo get_template_directory_uri(); ?>/js/html5shiv.js"></script>
		<![endif]-->
		<?php

		if( $favicon ) { ?>
		<link rel="icon" href="<?php echo esc_url( $favicon ); ?>" type="image/x-icon" />
		<link rel="shortcut icon" href="<?php echo esc_url( $favicon ); ?>" type="image/x-icon" />
		<?php } ?>

		<?php wp_head(); ?>
	</head>

	<body <?php body_class( $offcanvas_side . ' ' . $sticky_topbar . ' ' . $topbar_sidebar . ' '. $wcagMode .' ' . $wcagfocusclass . ' ' . $wcaganimationclass . ' ' . $contrast . ' ' . $width . ' ' . $fsize ); ?>>

		<div id="pe-main">

			<?php

			//top bar menu, logo and main menu
			get_template_part( 'tpl/bar' );

			//header section for slider and custom widgets
			get_template_part( 'tpl/header-mod' );

			//services section for custom widgets
			get_template_part( 'tpl/services-mod' );

			//top widget position
			get_template_part( 'tpl/top' );

			// breadcrumb position
			get_template_part( 'tpl/breadcrumbs' );

			?>
