<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	Generator name / Feed links / HTML5 Support
/*-----------------------------------------------------------------------------------*/

//add theme support
if ( ! function_exists( 'pe_theme_setup' ) ) {
	function pe_theme_setup() {
		add_theme_support( 'title-tag' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_theme_support( 'post-thumbnails' );
		//thumbnail size
		set_post_thumbnail_size( get_option( 'medium_size_w' ), get_option( 'medium_size_h' ) ); // default Post Thumbnail dimensions (medium)
		//languages
		load_theme_textdomain( 'pe-services', get_template_directory() . '/languages' );
	}
}
add_action( 'after_setup_theme', 'pe_theme_setup' );

//content width
if ( !function_exists( 'pe_content_width' ) ) {
	function pe_content_width() {
		$GLOBALS['content_width'] = peGetOptions('theme-width','width');
	}
}
add_action( 'after_setup_theme', 'pe_content_width', 0 );

/*-----------------------------------------------------------------------------------*/
/*	Theme Options
/*-----------------------------------------------------------------------------------*/

//check default value
if ( ! function_exists( 'peDefVar' ) ) {
	function peDefVar($var, $def = null) {
		if( !empty($var) ) {
			return $var;
		} else {
			if( !empty($def) ) {
				return $def;
			} else {
				return '';
			}
		}
	}
}

//theme options
if ( !function_exists( 'peGetOptions' ) ) {
	function peGetOptions( $index, $index2 = null, $index3 = null ) {

		if ( !class_exists( 'Redux' ) ) {
			Redux::init('pe_redux');
		}

		//get options
		$pe_redux = get_option( 'pe_redux' ); //query cached by get_option

		if( !empty($index) && !empty($index2) && !empty($index3) ) {
			if( !empty($pe_redux[ $index ][ $index2 ][ $index3 ]) ) {
				return $pe_redux[ $index ][ $index2 ][ $index3 ];
			} else {
				return false;
			}
		} elseif( !empty($index) && !empty($index2) ) {
			if( !empty($pe_redux[ $index ][ $index2 ]) ) {
				return $pe_redux[ $index ][ $index2 ];
			} else {
				return false;
			}
		} elseif( !empty($index) ) {
			if( !empty($pe_redux[ $index ]) ) {
				return $pe_redux[ $index ];
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
}

// WCAG
if(!class_exists('PEwcag')) {
	class PEwcag {
		//contrast
		public static function getContrast() {
			$expire = time()+3600*24*7;
			$path =  COOKIEPATH;

			if ( !empty($_GET['contrast']) ) { //check contrast
				switch( $_GET['contrast'] ) {
					case "normal" : {
						if(isset($_COOKIE['contrast'])) {
							setcookie('contrast', '', time() - 3600, $path); //remove cookie
						}
						break;
					}
					case "night" :{
						setcookie('contrast', 'night', $expire, $path);
						$contrast = 'night';
						break;
					}
					case "highcontrast" :{
						setcookie('contrast', 'highcontrast', $expire, $path);
						$contrast = 'highcontrast';
						break;
					}
					case "highcontrast2" :{
						setcookie('contrast', 'highcontrast2', $expire, $path);
						$contrast = 'highcontrast2';
						break;
					}
					case "highcontrast3" :{
						setcookie('contrast', 'highcontrast3', $expire, $path);
						$contrast = 'highcontrast3';
						break;
					}
					default: {
						$contrast = '';
						break;
					}
				}
			} else {
				if( !empty($_COOKIE['contrast']) ) {
					$contrast = $_COOKIE['contrast'];
				} else {
					$contrast = '';
				}
			}
			return $contrast;
		}
		// width
		public static function getWidth() {
			$expire = time()+3600*24*7;
			$path =  COOKIEPATH;

			if ( !empty($_GET['width']) ) { //check width
				switch( $_GET['width'] ) {
					case "fixed" :{
						if(isset($_COOKIE['pagewidth'])) {
							setcookie('pagewidth', '', time() - 3600, $path); //remove cookie
						}
						break;
					}
					case "wide" :{
						setcookie('pagewidth', 'wide', $expire, $path);
						$width = 'wide-page';
						break;
					}
					default: {
						$width = '';
						break;
					}
				}
			} else {
				if( isset($_COOKIE['pagewidth'])=='wide' ) {
					$width = 'wide-page';
				} else {
					$width = '';
				}
			}
			return $width;
		}
		// font-size
		public static function getFont() {
			$expire = time()+3600*24*7;
			$path =  COOKIEPATH;

			if( !empty($_GET['fontsize']) ) { //check fsize
				switch( $_GET['fontsize'] ) {
					case "70" :{
						setcookie('pe-font-size', '70', $expire, $path);
						$fsize = 'fsize70';
						break;
					}
					case "100" :{
						if(isset($_COOKIE['pe-font-size'])) {
							setcookie('pe-font-size', '', time() - 3600, $path); //remove cookie
						}
						$fsize = 'fsize100';
						break;
					}
					case "130" :{
						setcookie('pe-font-size', '130', $expire, $path);
						$fsize = 'fsize130';
						break;
					}
					default: {
						$fsize = '';
						break;
					}
				}
			} else {
				if( !empty($_COOKIE['pe-font-size']) ) {
					$fsize = 'fsize' . $_COOKIE['pe-font-size'];
				} else {
					$fsize = '';
				}
			}
			return $fsize;
		}
	}
}
add_action( 'after_setup_theme', array('PEwcag','getContrast') );
add_action( 'after_setup_theme', array('PEwcag','getWidth') );
add_action( 'after_setup_theme', array('PEwcag','getFont') );

/*-----------------------------------------------------------------------------------*/
/*	Theme menu
/*-----------------------------------------------------------------------------------*/

if ( !function_exists('pe_register_menu') ) {
	function pe_register_menu() {
		register_nav_menus(
			array(
				'main-menu' => __( 'Main Menu', 'pe-services' ),
				'skip-menu' => __( 'Skip Menu', 'pe-services' )
			)
		);
	}
}
add_action( 'init', 'pe_register_menu' );

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

/**
 * Use Mega Menu Classes for the WPML Language Switcher.
 */
 function wpml_fix_switcher( $nav_menu, $args ) {

	// make sure we're working with a Mega Menu
	if ( ! is_a( $args->walker, 'Mega_Menu_Walker' ) )
			return $nav_menu;

	$find = "menu-item menu-item-language menu-item-language-current menu-item-has-children";
	$replace = "mega-link-disabled mega-menu-item mega-menu-flyout menu-item-language menu-item-language-current mega-menu-item-has-children";
	$nav_menu = str_replace($find, $replace, $nav_menu);

	$find = "menu-item menu-item-language\"><a ";
	$replace = "mega-menu-item menu-item-language\"><a class=\"mega-menu-link\" ";
	$nav_menu = str_replace($find, $replace, $nav_menu);

	$find = "sub-menu submenu-languages";
	$replace = "mega-sub-menu submenu-languages";
	$nav_menu = str_replace($find, $replace, $nav_menu);

	$find = "<a href=\"#\" onclick=\"return false\">";
	$replace = "<a class=\"mega-menu-link\">";
	$nav_menu = str_replace($find, $replace, $nav_menu);

	return $nav_menu;
}
add_filter( 'wp_nav_menu', 'wpml_fix_switcher', 10, 2 );

if( is_plugin_inactive('megamenu/megamenu.php') ) {
	class PE_Main_Menu extends Walker_Nav_Menu {

		function start_lvl( &$output, $depth = 0, $args = Array() ) {
			$indent = str_repeat("\t", $depth);
			$output .= "\n$indent<div class=\"nav-dropdown\"><ul class=\"nav-dropdown-in main-menu\">\n";
		}
		function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
			$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

			$class_names = '';

			$classes = empty( $item->classes ) ? array() : (array) $item->classes;
			$classes[] = 'menu-item-' . $item->ID;

			$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
			$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

			$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
			$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

			$output .= $indent . '<li' . $id . $class_names .'>';

			$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
			$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
			$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
			$attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

			$item_output = $args->before;
			$item_output .= '<a'. $attributes .'>';
			$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;

			$item_output .= '</a>';
			$item_output .= $args->after;

			$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
		}
		function end_lvl( &$output, $depth = 0, $args = Array() ) {
			$indent = str_repeat("\t", $depth);
			$output .= "$indent</ul></div>\n";
		}
	}
}

/*-----------------------------------------------------------------------------------*/
//	Custom class field for widgets
/*-----------------------------------------------------------------------------------*/

if ( !class_exists( 'PE_Custom_CSS' ) ) {
	class PE_Custom_CSS {

		public static function pe_show_widget_new_class( $widget, $return, $instance ) {
			if ( !isset($instance['pe_classes']) ) $instance['pe_classes'] = null;

			$row = "<p>\n";
			$row .= "\t<p><label for='widget-{$widget->id_base}-{$widget->number}-pe_classes'>".apply_filters( 'widget_css_classes', esc_html__( 'Custom Widget Classes', 'pe-services' ) ).":</label>\n";
			$row .= "\t<input type='text' name='widget-{$widget->id_base}[{$widget->number}][pe_classes]' id='widget-{$widget->id_base}-{$widget->number}-pe_classes' value='{$instance['pe_classes']}' class='widefat' /></p>\n";
			$row .= "</p>\n";

			echo $row;
			return $instance;
		}

		public static function pe_widget_update( $instance, $new_instance ) {
			$instance['pe_classes'] = $new_instance['pe_classes'];
			return $instance;
		}

		public static function pe_dynamic_sidebar_params( $params ) {
			global $wp_registered_widgets;
			$widget_id = $params[0]['widget_id'];
			$widget_obj = $wp_registered_widgets[ $widget_id ];
			$widget_opt = get_option($widget_obj['callback'][0]->option_name);
			$widget_num = $widget_obj['params'][0]['number'];

			if ( isset($widget_opt[$widget_num]['pe_classes']) && !empty($widget_opt[ $widget_num ]['pe_classes']) )
				$params[0]['before_widget'] = preg_replace( '/class="/', "class=\"{$widget_opt[$widget_num]['pe_classes']} ", $params[0]['before_widget'], 1 );
			return $params;
		}

	}
}

if ( is_admin() ) {
	add_filter( 'in_widget_form', array('PE_Custom_CSS', 'pe_show_widget_new_class'),	 10, 3 );
	add_filter( 'widget_update_callback', array('PE_Custom_CSS','pe_widget_update'), 10, 2 );
} else {
	add_filter( 'dynamic_sidebar_params', array('PE_Custom_CSS', 'pe_dynamic_sidebar_params') );
}

/*-----------------------------------------------------------------------------------*/
/*	Modify Widget Title
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'pe_widget_title' ) ) {
	function pe_widget_title( $title ) {
		if( isset($title) && $title !='' ) {
			$title_array = preg_split('#\s#', $title);
			$title = '';
			foreach ( $title_array as $title_word ) {
				$title .= '<span>' . $title_word . '</span> ';
			}
			return $title;
		}
	}
}
add_filter('widget_title', 'pe_widget_title');

/*-----------------------------------------------------------------------------------*/
/*	Modify wp readmore
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'pe_read_more_link' ) ) {
	function pe_read_more_link() {
		return '<p class="pe-article-read-more"><a class="readmore" href="' . get_permalink() . '">' . __('Read more', 'pe-services') . '<span class="sr-only"> ' . esc_html( get_the_title() ) . '</span></a></p>';
	}
}
add_filter( 'the_content_more_link', 'pe_read_more_link' );

/*-----------------------------------------------------------------------------------*/
//	Theme Pagination Method
/*-----------------------------------------------------------------------------------*/

if( !function_exists( 'pe_pagination' ) ) {
	function pe_pagination( $pages = '' ) {
		global $paged;

		if(empty($paged)) $paged = 1;

		$prev = $paged - 1;
		$next = $paged + 1;
		$range = 2; // only change it to show more links
		$showitems = ($range * 2) + 1;

		if($pages == '') {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if(!$pages) {
				$pages = 1;
			}
		}

		if( $pages != 1 ) {
			echo '<div class="pe-pagination-block"><ul class="pe-pagination">';
			echo ($paged > 2 && $paged > $range+1 && $showitems < $pages) ? '<li><a href="' . get_pagenum_link(1) . '" data-toggle="tooltip" data-placement="top" title="" aria-label="' . __('Start', 'pe-services') . '" data-original-title="' . __('Start', 'pe-services') . '">&laquo; '.__('Start', 'pe-services') . '</a></li>' : '';
			echo ($paged > 1 && $showitems < $pages) ? '<li><a href="' . get_pagenum_link($prev) . '" data-toggle="tooltip" data-placement="top" title="" aria-label="' . __('Prev', 'pe-services') . '" data-original-title="' . __('Prev', 'pe-services') . '">&laquo; ' .  __('Prev', 'pe-services') . '</a></li>' : '';
			for ($i=1; $i <= $pages; $i++) {
				if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
					echo ($paged == $i) ? '<li class="active"><span>' . $i . '<span class="sr-only">(current)</span></span></li> ' : '<li><a href="' . get_pagenum_link($i) . '">' . $i . '</a></li>';
				}
			}
			echo ($paged < $pages && $showitems < $pages) ? '<li><a href=' . get_pagenum_link($next) . ' data-toggle="tooltip" data-placement="top" title="" aria-label="' . __('Next', 'pe-services') . '" data-original-title="' . __('Next', 'pe-services') . '">' .  __('Next', 'pe-services') . ' &raquo;</a></li>' : '';
			echo ($paged < $pages-1 && $paged+$range-1 < $pages && $showitems < $pages) ? '<li><a href="' . get_pagenum_link($pages) . '" data-toggle="tooltip" data-placement="top" title="" aria-label="' . __('End', 'pe-services') . '" data-original-title="' . __('End', 'pe-services') . '">' . __('End', 'pe-services') . ' &raquo;</a></li>' : '';
			echo '</ul></div>';
		}
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Custom Excerpt Method
/*-----------------------------------------------------------------------------------*/

/* custom excerpt */
if( !function_exists( 'pe_excerpt' ) ) {
	function pe_excerpt($len = 15, $trim = '&hellip;'){
		echo get_pe_excerpt($len, $trim);
	}
}

if( !function_exists( 'get_pe_excerpt' ) ) {
	function get_pe_excerpt($len = 15, $trim = '&hellip;'){
		$limit = $len + 1;
		$excerpt = explode(' ', get_the_content(), $limit);
		$num_words = count($excerpt);
		if($num_words >= $len){
			$last_item = array_pop($excerpt);
		}
		else{
			$trim = '';
		}
		$excerpt = implode(' ', $excerpt) . $trim;
		return $excerpt;
	}
}

/* blog excerpt */
if( !function_exists( 'pe_blog_excerpt' ) ) {
	function pe_blog_excerpt($len = 15, $trim = '&hellip;'){
		echo get_pe_blog_excerpt($len, $trim);
	}
}

if( !function_exists( 'get_pe_blog_excerpt' ) ) {
	function get_pe_blog_excerpt($len = 15, $trim = '&hellip;'){
		$limit = $len + 1;
		$excerpt = explode(' ', get_the_excerpt(), $limit);
		$num_words = count($excerpt);
		if($num_words >= $len){
			$last_item = array_pop($excerpt);
		}
		else{
			$trim='';
		}
		$excerpt = implode(' ', $excerpt) . $trim;
		$excerpt .= '<p class="pe-article-read-more"><a class="readmore" href="' . get_permalink() . '">' . __('Read more', 'pe-services') . '</a></p>';
		return $excerpt;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Comingsoon Tempalte
/*-----------------------------------------------------------------------------------*/

if( !function_exists( 'pe_coming_soon_page' ) ) {
	function pe_coming_soon_page( $template ) {

		$comingsoondate = strtotime(peGetOptions('coming-soon-until-date'));
		$current_time = strtotime(current_time( 'mysql' ));
		$futuredate = ($current_time < $comingsoondate) ? true : false;

		if (!is_user_logged_in() && peGetOptions('coming-soon') && $comingsoondate && $futuredate) {
			$cs_template = locate_template( array( 'tpl/comingsoon.php' ) );
			if ( '' != $cs_template ) {
				return $cs_template ;
			}
		}
		return $template;
	}
}
add_filter( 'template_include', 'pe_coming_soon_page', 99 );

/*-----------------------------------------------------------------------------------*/
/*	Custom Comment
/*-----------------------------------------------------------------------------------*/

if( !function_exists( 'pe_enqueue_comments_reply' ) ) {
	function pe_enqueue_comments_reply() {
		if( get_option( 'thread_comments' ) )  {
			wp_enqueue_script( 'comment-reply' );
		}
	}
}
add_action( 'comment_form_before', 'pe_enqueue_comments_reply' );

function pe_comment($comment, $args, $depth) {
	global $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
?>
<<?php echo $tag ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
		<?php endif; ?>

		<div class="comment-avatar">
			<?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
		</div>

		<div class="comment-details">
			<div class="comment-author vcard">
				<?php printf( __( '<span class="author fn">%s</span> <span class="says">says:</span>', 'pe-services' ), get_comment_author_link() ); ?>
			</div>
			<div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
				<?php
					/* translators: 1: date, 2: time */
					printf( __('%1$s at %2$s', 'pe-services'), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'pe-services' ), '  ', '' );
				?>
			</div>

			<?php if ( $comment->comment_approved == '0' ) : ?>
			<div class="pe-info"><?php _e( 'Your comment is awaiting moderation.', 'pe-services' ); ?></div>
			<?php endif; ?>

			<?php comment_text(); ?>

			<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>

		</div>

		<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
	<?php
}

/*-----------------------------------------------------------------------------------*/
/*	Add IDs for images in Media Library (List View)
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'pe_media_library_column_id' ) ) {
	function pe_media_library_column_id( $columns ) {
		$columns['colID'] = __('ID', 'pe-services');
		return $columns;
	}
}
add_filter( 'manage_media_columns', 'pe_media_library_column_id' );

if ( ! function_exists( 'pe_media_library_column_id_row' ) ) {
	function pe_media_library_column_id_row( $columnName, $columnID ){
		if($columnName == 'colID') {
			echo $columnID;
		}
	}
}
add_filter( 'manage_media_custom_column', 'pe_media_library_column_id_row', 10, 2 );

/*-----------------------------------------------------------------------------------*/
/*	WCAG cookie patch
/*-----------------------------------------------------------------------------------*/

function pe_cookie_path() {
	echo '<script type="text/javascript">window.cookiePath = "' . COOKIEPATH . '";</script>';
}
add_action('wp_head', 'pe_cookie_path');


/**
 * Remove Redux demo
 */

function removeDemoModeLink() {
	if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
	}
	if ( class_exists('ReduxFrameworkPlugin') ) {
		remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );
	}
}
add_action('init', 'removeDemoModeLink');

/*-----------------------------------------------------------------------------------*/
/*	News widget
/*-----------------------------------------------------------------------------------*/

function add_dashboard_widget() {
	// Create the widget
	wp_add_dashboard_widget( 'pixelemu_news', __( 'Pixelemu News', 'pe-services' ), 'display_news_dashboard_widget' );

	// Make sure our widget is on top off all others
	global $wp_meta_boxes;

	// Get the regular dashboard widgets array
	$normal_dashboard = $wp_meta_boxes['dashboard']['normal']['core'];

	// Backup and delete our new dashboard widget from the end of the array
	$pixelemu_widget_backup = array( 'pixelemu_news' => $normal_dashboard['pixelemu_news'] );
	unset( $normal_dashboard['pixelemu_news'] );

	// Merge the two arrays together so our widget is at the beginning
	$sorted_dashboard = array_merge( $pixelemu_widget_backup, $normal_dashboard );

	// Save the sorted array back into the original metaboxes
	$wp_meta_boxes['dashboard']['normal']['core'] = $sorted_dashboard;
}

function display_news_dashboard_widget() {

	$feeds = array(
		'news' => array(
			'link'         => 'https://pixelemu.com/blog/',
			'url'          => 'http://pixelemu.com/blog?format=feed&type=rss',
			'title'        => __( 'Pixelemu News', 'pe-services' ),
			'items'        => 2,
			'show_summary' => 0,
			'show_author'  => 0,
			'show_date'    => 0,
		),
		'basics' => array(
			'link'         => 'https://pixelemu.com/documentation/wordpress-basics/',
			'url'          => 'http://pixelemu.com/documentation/wordpress-basics?format=feed&type=rss',
			'title'        => __( 'Pixelemu WordPress Basics', 'pe-services' ),
			'items'        => 2,
			'show_summary' => 0,
			'show_author'  => 0,
			'show_date'    => 0,
		),
		'tutorials' => array(
			'link'         => 'https://pixelemu.com/documentation/wordpress-tutorials/',
			'url'          => 'http://pixelemu.com/documentation/wordpress-tutorials?format=feed&type=rss',
			'title'        => __( 'Pixelemu Tutorials', 'pe-services' ),
			'items'        => 2,
			'show_summary' => 0,
			'show_author'  => 0,
			'show_date'    => 0,
		),
	);

	wp_dashboard_primary_output( 'pixelemu_news', $feeds );
}
add_action( 'wp_dashboard_setup', 'add_dashboard_widget' );

/*-----------------------------------------------------------------------------------*/
/*	esc_url protocols
/*-----------------------------------------------------------------------------------*/

add_filter( 'kses_allowed_protocols' , 'pe_more_protocols' );
if ( ! function_exists( 'pe_more_protocols' ) ) {
	function pe_more_protocols( $protocols ){
		$protocols[] = 'skype';
		return $protocols;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Sanitize multiple classes
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'pe_sanitize_class' ) ) {
	function pe_sanitize_class( $classes ) {
		$classes = explode(' ', $classes);
		$classes = array_map( 'sanitize_html_class', $classes );
		$classes = implode( ' ', $classes ); //array to string
		return $classes;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Custom CPT Search
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'pe_cpt_search' ) ) {
	/**
	 * This function modifies the main WordPress query to include an array of
	 * post types instead of the default 'post' post type.
	 *
	 * @param object $query  The original query.
	 * @return object $query The amended query.
	 */
	function pe_cpt_search( $query ) {
		if ( is_search() && $query->is_search ) {
			$query->set( 'post_type', array( 'post', 'page', 'faqs', 'member', 'service', 'testimonial' ) );
		}
		return $query;
	}
}
add_filter( 'pre_get_posts', 'pe_cpt_search' );

/*-----------------------------------------------------------------------------------*/
/*	Post Class
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'pe_post_classes' ) ) {
	function pe_post_classes( $classes ) {
		if ( is_page() ) {
			$classes = array_diff( $classes, array( 'hentry' ) );
		}
		if( ! is_admin() ) {
			$classes = array_merge( $classes, array( 'clearfix' ) );
		}
		return $classes;
	}
}
add_filter( 'post_class','pe_post_classes' );

?>
