<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

// ---------------------------------------------------------------
// UTILITIES
// ---------------------------------------------------------------

if ( !class_exists( 'PEutils' ) ) {

	class PEutils {
		static $instance = null;
		public static $wrongdir = null;

		public static $PEfile_suffix;
		public static $PElesspath;
		public static $PEcachepath;
		public static $PEcsspath;
		public static $PEcssurl;
		public static $PEfallback;

		function __construct() {
			add_action( 'after_setup_theme', array( $this, 'backendNotice' ), 5 );

				//less compiles

				//css output file name, default empty (if 'suffix' css file name -> style.suffix.css)
				self::$PEfile_suffix = '';

				//paths without '/'
				self::$PElesspath  = get_template_directory() . DIRECTORY_SEPARATOR . 'less';

				$upload_dir = wp_upload_dir();

				self::$PEcachepath = $upload_dir['basedir'] . DIRECTORY_SEPARATOR . 'pe-services' . DIRECTORY_SEPARATOR . 'cache';
				self::$PEcsspath   = $upload_dir['basedir'] . DIRECTORY_SEPARATOR . 'pe-services' . DIRECTORY_SEPARATOR . 'css';

				//urls with '/'
				self::$PEcssurl    = $upload_dir['baseurl'] . '/pe-services/css/';

				//fallback css directory
				self::$PEfallback  = get_template_directory_uri() . '/css/fallback/';
		}

		/**
		 * Get instance
		 * @return object
		 */
		public static function instance() {
			if (self::$instance === null) {
				self::$instance = new PEutils();
			}
			return self::$instance;
		}

		/**
		 * Method for checking dir permissions
		 * @param  array $dir Path
		 * @return boolean
		 */
		public static function checkPermissions( $dir ) {
			if( !empty($dir) ) {
				if( !is_array($dir) ) {
					$dir = explode(',', $dir);
				}
				$output_dir = array();
				foreach( $dir as $location ) {
					//try to create dir if not available
					if( !is_dir($location) ) {
						wp_mkdir_p($location);
					}
					//check dir permissions
					if( !is_writable($location) ) {
						$writable = ( is_dir($location) ) ? 0 : 1; // 0 not writable ; 1 not exist
						$output_dir[$location] = $writable;
					}
				}

				if( !empty($output_dir) ) {
					//save wrong dir
					self::$wrongdir = $output_dir;
					return false;
				} else {
					return true;
				}

			} else {
				return false;
			}
		}

		/**
		 * Show backend notice
		 */
		public function backendNotice() {
			$check = array(PEutils::$PEcachepath, PEutils::$PEcsspath);
			if(self::checkPermissions($check) === false) {
				$this->show_permission_notice();
			}
		}

		/**
		 * Method for clear cache files
		 * @param string [$index = true] Select what to clean
		 * @param string [$type = false] Select files to clean (suffix / prefix)
		 */
		public static function clearCache( $index = true, $type = false ) {

			$lesscache = PEutils::$PEcachepath;
			$css = PEutils::$PEcsspath;

			$prefix = ( !empty($type) ) ? $type . '_' : '';
			$sufix = ( !empty($type) ) ? '_' . $type : '';

			if( $index === true || $index === 'cache' ) {
				foreach( glob($lesscache . DIRECTORY_SEPARATOR . $prefix . '*.*') as $f ) {
					unlink($f);
				}
			}

			if( $index === 'css' ) {
				foreach( glob($css . DIRECTORY_SEPARATOR . '*' . $sufix . '.css') as $f ) {
					unlink($f);
				}
			}

		}

		/**
		 * Show permission notice in backend
		 */
		private function show_permission_notice() {
			add_action ( 'admin_notices', array( $this, 'permission_notice' ) );
		}

		/**
		 * Permission notice message
		 */
		public function permission_notice() {
			$class = 'notice notice-error is-dismissible';
			$message = '<p>' . __( 'Following directories have permission issues :', 'pe-services' ) . '</p>';
			if( is_array(self::$wrongdir) ) {
				foreach(self::$wrongdir as $dir_name => $writable) {
					$error_message = ( $writable == 0 ) ? __('(not writable)', 'pe-services') : __('(not exist)', 'pe-services');
					$message .= '<p><strong>' . $dir_name . '</strong> - ' . $error_message . '</p>';
				}
			}
			$message .= '<p>' . __( 'Please make sure directories exist and PHP parser have permissions to write files in.', 'pe-services' ) . '</p>';
			printf( '<div class="%1$s">%2$s</div>', $class, $message );
		}

	}
	PEutils::instance();
}

	// LESS VARS and COMPILER
	// ----------------------------------------------------

	if(!class_exists('PEless')) {

		add_action( 'init', array( 'PEless', 'instance' ) );

		class PEless {

			protected static $instance = null;

			public static $compare = false;

			public static $fallback = false;

			public static $parsed_paths = array();
			public static $parsed_urls = array();

			public static $less = array();

			function __construct() {

				// every CSS file URL gets passed through this filter
				add_filter( 'style_loader_src', array( $this, 'parseStylesheets' ), 100000, 2 );

				include('default-vars.php');

				$imgdir = '\'' . strval(get_template_directory_uri() . '/images') . '\'';

				self::$less = array(

				'dir' => $imgdir,

				//theme width
				'PEthemeWidth' => peDefVar(peGetOptions('theme-width','width'), $PEthemeWidth),

				//other
				'PEthumbnailWidth' => get_option( 'thumbnail_size_w' ),
				'PEthumbnailHeight' => get_option( 'thumbnail_size_h' ),

				//body font
				'PEbodyFontColor' => peDefVar(peGetOptions('body-font','color'), $PEbodyFontColor),
				'PEbodyFontWeight' => peDefVar(peGetOptions('body-font','font-weight'), $PEbodyFontWeight),
				'PEbodyFontLetterSpacing' => peDefVar(peGetOptions('body-font','letter-spacing'), $PEbodyFontLetterSpacing),
				'PEbodyFontTextTransform' => peDefVar(peGetOptions('body-font','text-transform'), $PEbodyFontTextTransform),
				'PEbodyFontFamily' => peDefVar(peGetOptions('body-font','font-family'), $PEbodyFontFamily) . ',' . peDefVar(peGetOptions('body-font','font-backup'), $PEbodyFontBackup),
				'PEbodyFontSize' => peDefVar(peGetOptions('body-font','font-size'), $PEbodyFontSize),
				'PEbodyFontStyle' => peDefVar(peGetOptions('body-font','font-style'), $PEbodyFontStyle),

				//post title
				'PEpostFontColor' => peDefVar(peGetOptions('posts-font','color'), $PEpostFontColor),
				'PEpostFontWeight' => peDefVar(peGetOptions('posts-font','font-weight'), $PEpostFontWeight),
				'PEpostFontLetterSpacing' => peDefVar(peGetOptions('posts-font','letter-spacing'), $PEpostFontLetterSpacing),
				'PEpostFontTextTransform' => peDefVar(peGetOptions('posts-font','text-transform'), $PEpostFontTextTransform),
				'PEpostFontFamily' => peDefVar(peGetOptions('posts-font','font-family'), $PEpostFontFamily) . ',' . peDefVar(peGetOptions('posts-font','font-backup'), $PEpostFontBackup),
				'PEpostFontSize' => peDefVar(peGetOptions('posts-font','font-size'), $PEpostFontSize),
				'PEpostFontStyle' => peDefVar(peGetOptions('posts-font','font-style'), $PEpostFontStyle),

				//widget title
				'PEwidgetFontColor' => peDefVar(peGetOptions('widgets-font','color'), $PEwidgetFontColor),
				'PEwidgetFontWeight' => peDefVar(peGetOptions('widgets-font','font-weight'), $PEwidgetFontWeight),
				'PEwidgetFontLetterSpacing' => peDefVar(peGetOptions('widgets-font','letter-spacing'), $PEwidgetFontLetterSpacing),
				'PEwidgetFontTextTransform' => peDefVar(peGetOptions('widgets-font','text-transform'), $PEwidgetFontTextTransform),
				'PEwidgetFontFamily' => peDefVar(peGetOptions('widgets-font','font-family'), $PEwidgetFontFamily) . ',' . peDefVar(peGetOptions('widgets-font','font-backup'), $PEwidgetFontBackup),
				'PEwidgetFontSize' => peDefVar(peGetOptions('widgets-font','font-size'), $PEwidgetFontSize),
				'PEwidgetFontStyle' => peDefVar(peGetOptions('widgets-font','font-style'), $PEwidgetFontStyle),

				//main menu
				'PEresponsiveBreakpoint' => peDefVar(peGetOptions('responsive-breakpoint','width'), $PEresponsiveBreakpoint),
				'PEtopmenuBackground' => peDefVar(peGetOptions('PEtopmenuBackground'), $PEtopmenuBackground),

				'PEtopmenuFontColor' => peDefVar(peGetOptions('topmenu-font','color'), $PEtopmenuFontColor),
				'PEtopmenuFontWeight' => peDefVar(peGetOptions('topmenu-font','font-weight'), $PEtopmenuFontWeight),
				'PEtopmenuFontLetterSpacing' => peDefVar(peGetOptions('topmenu-font','letter-spacing'), $PEtopmenuFontLetterSpacing),
				'PEtopmenuFontTextTransform' => peDefVar(peGetOptions('topmenu-font','text-transform'), $PEtopmenuFontTextTransform),
				'PEtopmenuFontFamily' => peDefVar(peGetOptions('topmenu-font','font-family'), $PEtopmenuFontFamily) . ',' . peDefVar(peGetOptions('topmenu-font','font-backup'), $PEtopmenuFontBackup),
				'PEtopmenuFontSize' => peDefVar(peGetOptions('topmenu-font','font-size'), $PEtopmenuFontSize),
				'PEtopmenuFontStyle' => peDefVar(peGetOptions('topmenu-font','font-style'), $PEtopmenuFontStyle),

				'PEtopmenuSubmenuFontWeight' => peDefVar(peGetOptions('topmenu-submenu-font','font-weight'), $PEtopmenuSubmenuFontWeight),
				'PEtopmenuSubmenuFontSize' => peDefVar(peGetOptions('topmenu-submenu-font','font-size'), $PEtopmenuSubmenuFontSize),

				//main scheme
				'PEmainSchemeColor' => peDefVar(peGetOptions('PEmainSchemeColor'), $PEmainSchemeColor),
				'PEcomplementary' => peDefVar(peGetOptions('PEcomplementary'), $PEcomplementary),

				//general colors
				'PEpageBackground' => peDefVar(peGetOptions('PEpageBackground'), $PEpageBackground),
				'PEbaseBorder' => peDefVar(peGetOptions('PEbaseBorder'), $PEbaseBorder),

				//topbar colors
				'PEtopBarBackground' => peDefVar(peGetOptions('PEtopBarBackground'), $PEtopBarBackground),
				'PEtopBarText' => peDefVar(peGetOptions('PEtopBarText'), $PEtopBarText),

				//menu colors
				'PEmenuBarBackground' => peDefVar(peGetOptions('PEmenuBarBackground'), $PEmenuBarBackground),

				//header colors
				'PEheaderBackground' => peDefVar(peGetOptions('PEheaderBackground'), $PEheaderBackground),
				'PEheaderText' => peDefVar(peGetOptions('PEheaderText'), $PEheaderText),
				'PEheaderWidgetTitle' => peDefVar(peGetOptions('PEheaderWidgetTitle'), $PEheaderWidgetTitle),

				//top1 colors
				'PEtop1Background' => peDefVar(peGetOptions('PEtop1Background'), $PEtop1Background),
				'PEtop1Text' => peDefVar(peGetOptions('PEtop1Text'), $PEtop1Text),
				'PEtop1WidgetTitle' => peDefVar(peGetOptions('PEtop1WidgetTitle'), $PEtop1WidgetTitle),

				//top2 colors
				'PEtop2Background' => peDefVar(peGetOptions('PEtop2Background'), $PEtop2Background),
				'PEtop2Text' => peDefVar(peGetOptions('PEtop2Text'), $PEtop2Text),
				'PEtop2WidgetTitle' => peDefVar(peGetOptions('PEtop2WidgetTitle'), $PEtop2WidgetTitle),

				//bottom2 colors
				'PEbottom2Background' => peDefVar(peGetOptions('PEbottom2Background'), $PEbottom2Background),
				'PEbottom2Text' => peDefVar(peGetOptions('PEbottom2Text'), $PEbottom2Text),
				'PEbottom2WidgetTitle' => peDefVar(peGetOptions('PEbottom2WidgetTitle'), $PEbottom2WidgetTitle),

				//footer colors
				'PEfooterBackground' => peDefVar(peGetOptions('PEfooterBackground'), $PEfooterBackground),
				'PEfooterText' => peDefVar(peGetOptions('PEfooterText'), $PEfooterText),
				'PEfooterWidgetTitle' => peDefVar(peGetOptions('PEfooterWidgetTitle'), $PEfooterWidgetTitle),

				//copyright colors
				'PEcopyrightBackground' => peDefVar(peGetOptions('PEcopyrightBackground'), $PEcopyrightBackground),
				'PEcopyrightText' => peDefVar(peGetOptions('PEcopyrightText'), $PEcopyrightText),

				//offcnavas
				'PEoffcanvasWidth' => peDefVar(peGetOptions('off-canavs-width','width'), $PEoffcanvasWidth),

				'PEoffcanvasIcon' => peDefVar(peGetOptions('PEoffcanvasIcon'), $PEoffcanvasIcon),
				'PEoffcanvasBackground' => peDefVar(peGetOptions('PEoffcanvasBackground'), $PEoffcanvasBackground),
				'PEoffcanvasText' => peDefVar(peGetOptions('PEoffcanvasText'), $PEoffcanvasText),
				'PEoffcanvasWidgetTitle' => peDefVar(peGetOptions('PEoffcanvasWidgetTitle'), $PEoffcanvasWidgetTitle),
				);

			}

			public static function instance() {
				null === self:: $instance AND self:: $instance = new self;
				return self:: $instance;
			}

			/**
			 * Parse HEAD Urls and compile LESS files
			 * @param  string $src URL from wp_enqueue_style() function
			 * @param  string $handle stylesheet ID
			 * @return string LESS Compiled CSS file URL
			 */
			public function parseStylesheets($src, $handle) {

				// we only want to handle .less files
				if ( ! preg_match( '/\.less(\.php)?$/', preg_replace( '/\?.*$/', '', $src ) ) ) {
					return $src;
				}

				// get file path from $src
				if ( ! strstr( $src, '?' ) ) {
					$src .= '?';
				} // prevent non-existent index warning when using list() & explode()

				// Match the URL schemes between WP_CONTENT_URL and $src,
				// so the str_replace further down will work
				$src_scheme = parse_url( $src, PHP_URL_SCHEME );
				$wp_content_url_scheme = parse_url( WP_CONTENT_URL, PHP_URL_SCHEME );
				if ( $src_scheme != $wp_content_url_scheme ) {
					$src = set_url_scheme( $src, $wp_content_url_scheme );
				}

				list( $less_path ) = explode( '?', str_replace( WP_CONTENT_URL, WP_CONTENT_DIR, $src ) );

				//compile less
				$compile = self::compile($less_path);

				$url = strtok($src, '?'); //remove parameters

				self::$parsed_paths[$handle] = $less_path;
				self::$parsed_urls[$handle] = $url;

				//return compiled css URI
				return $compile;

			}

			/**
			 * Compare previous and current settings and clear cache if necessary
			 * @return boolean True if settings are the same and false if not
			 */
			public static function compareSettings() {

				$option_suffix = ( !empty(PEutils::$PEfile_suffix) ) ? '-' . PEutils::$PEfile_suffix : '-default';
				$file_suffix = ( !empty(PEutils::$PEfile_suffix) ) ? PEutils::$PEfile_suffix : '';

				self::$compare = get_option('pe-less' . $option_suffix, false ); //get 'old' settings

				$current_settings = self::$less; //current settings

				if( self::$compare === false ) {
					self::$compare = $current_settings;
					update_option( 'pe-less' . $option_suffix, $current_settings );
					return true;
				} else {
					if( self::$compare == $current_settings ) { //settings are the same
						return true;
					} else { //settings are NOT the same
						PEutils::clearCache(true, $file_suffix); //clear cache
						update_option( 'pe-less' . $option_suffix, $current_settings ); //save current settings
						return false;
					}
				}

			}

			/**
			 * Compile LESS
			 * @param  string $source Full path to file (not url)
			 * @return LESS compiled CSS file URL or fallback CSS URL or false
			 */
			public static function compile( $source ) {

				if( !empty($source) ) {


					$lessfile = basename($source);

					//get registered less vars
					$variables = self::$less;

					$file_suffix = PEutils::$PEfile_suffix;

					//paths
					$cachepath = PEutils::$PEcachepath;
					$csspath = PEutils::$PEcsspath;

					//css url
					$cssurl = PEutils::$PEcssurl;
					$fallback = PEutils::$PEfallback;

					//filenames
					if( !empty($file_suffix) ) {
						$cssfile = str_replace('.less', '_' . $file_suffix . '.css', $lessfile);
						$mapfile = str_replace('.less', '_' . $file_suffix . '.map', $lessfile);
					} else {
						$cssfile = str_replace('.less', '.css', $lessfile);
						$mapfile = str_replace('.less', '.map', $lessfile);
					}

					try {

						//default options
						$options = array(
							'output'      => $csspath . DIRECTORY_SEPARATOR . $cssfile,
							'cache_dir'   => $cachepath,
						);

						//compress css
						$options['compress'] = true;


						//less file to compile
						$file = array( $source => $cssurl );

						$checkDir = ( !empty(PEutils::$wrongdir) ) ? false : true;

						if( class_exists('Less_Cache') && $checkDir ) { // if compilator enabled and directory permissions are ok

							self::compareSettings();

							// prefix for the storing cache
							Less_Cache::$prefix = ( !empty($file_suffix) ) ? $file_suffix . '_' : 'default_';
							Less_Cache::$prefix_vars = ( !empty($file_suffix) ) ? $file_suffix . '_' : 'default_';

							$output_css = $cssurl . Less_Cache::Get( $file, $options, $variables );

						} else { // fallback css
							self::$fallback = true;
							$output_css = $fallback . $cssfile;
						}

						//return css url
						return $output_css;

					} catch(Exception $e) {
						PEutils::clearCache(true, $file_suffix);
						throw new Exception( __('LESS ERROR: ', 'pe-services') . $e->getMessage() );
					}
				} else {
					return false;
				}
			}

		}

	}

?>
