<?php
/*--------------------------------------------------------------
Copyright (C) pixelemu.com
License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
Website: http://www.pixelemu.com
Support: info@pixelemu.com
---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	Theme Mode
/*-----------------------------------------------------------------------------------*/

	add_filter( 'ot_theme_mode', '__return_true' );

/*-----------------------------------------------------------------------------------*/
/*	Child Theme Mode
/*-----------------------------------------------------------------------------------*/

	add_filter( 'ot_child_theme_mode', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Hide Settings Page
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_pages', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Show Theme Options UI Builder
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_options_ui', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Show Settings Import
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_settings_import', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Show Settings Export
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_settings_export', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Hide New Layout
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_new_layout', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Hide Documentation
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_show_docs', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Custom Theme Option page
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_use_theme_options', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Meta Boxes
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_meta_boxes', '__return_true' );

/*-----------------------------------------------------------------------------------*/
/*	Allow Unfiltered HTML in textareas options
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_allow_unfiltered_html', '__return_false' );

/*-----------------------------------------------------------------------------------*/
/*	Loads the meta boxes for post formats
/*-----------------------------------------------------------------------------------*/

    add_filter( 'ot_post_formats', '__return_true' );

/*-----------------------------------------------------------------------------------*/
/*	OptionTree in Theme Mode
/*-----------------------------------------------------------------------------------*/

    get_template_part( '/inc/option-tree/ot-loader' );

/*-----------------------------------------------------------------------------------*/
/*	Add empty Option Type to theme options used for separator
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'ot_type_empty' ) ) {
	function ot_type_empty( $args = array() ) {
		/* turns arguments array into variables */
		extract( $args );
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Add Option for Opening Hours on Theme Option
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'ot_type_opening_hours' ) ) {
	function ot_type_opening_hours( $args = array() ) {
		/* turns arguments array into variables */
		extract( $args );

		/* verify a description */
		$has_desc = $field_desc ? true : false;
		/* format setting outer wrapper */
		echo '<div class="format-setting type-opening_hours ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';
		/* description */
		echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';
		/* format setting inner wrapper */
		echo '<div class="format-setting-inner">';

		/* build fields */
		foreach( $field_std as $key => $value) {

			if ( array_key_exists( $key, $field_std ) ) {
				echo '<div class="option-tree-ui-opening-hours-input-wrap">';
				echo '<label for="' . esc_attr( $field_id ) . '-' . $type . '" class="option-tree-ui-opening-hours-label">' . esc_attr( $value['label'] ) . '</label>';

				/* set color */

				$from_field = $value['id'] . '-from';
				$to_field = $value['id'] . '-to';

				$from_value = isset( $field_value[ $from_field ] ) ? esc_attr( $field_value[ $from_field ] ) : '';
				$to_value = isset( $field_value[ $to_field ] ) ? esc_attr( $field_value[ $to_field ] ) : '';
				echo '<div class="clearfix">';
				echo '<div class="row-from"><p>' . __( 'From:', 'pe-services' ) . '</p><input type="text" name="' . esc_attr( $field_name ) . '[' . $from_field . ']" id="' . esc_attr( $from_field ) . '" value="'.$from_value.'" class="widefat option-tree-ui-input"	/></div>';
				echo '<div class="row-to"><p>' . __( 'To:', 'pe-services' ) . '</p><input type="text" name="' . esc_attr( $field_name ) . '[' . $to_field . ']" id="' . esc_attr( $to_field ) . '" value="'.$to_value.'" class="widefat option-tree-ui-input"	/></div>';
				echo '</div>';
				echo '</div>';
			}
		}
		echo '</div></div>';
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Add Option for Services Categories on Theme Option
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'ot_type_service_checkbox' ) ) {

	function ot_type_service_checkbox( $args = array() ) {

		/* turns arguments array into variables */
		extract( $args );

		/* verify a description */
		$has_desc = $field_desc ? true : false;

		/* format setting outer wrapper */
		echo '<div class="format-setting type-service-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';

		/* description */
		echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';

		/* format setting inner wrapper */
		echo '<div class="format-setting-inner">';

		/* setup the post types */
		$post_type = isset( $field_post_type ) ? explode( ',', $field_post_type ) : array( 'post' );

		/* query taxonomies */
		$taxonomy_args = array(
			'orderby'						=> 'id',
			'order'							=> 'ASC',
			'hide_empty'				=> true
		);

		$terms = get_terms('service-category', $taxonomy_args);

		/* has service-category */
		if ( is_array( $terms ) && !empty( $terms ) ) {

			foreach( $terms as $my_term ) {
				echo'<div class="service_box">';
				echo '<p><b>' . $my_term->name . '</b></p>';

				/* query posts array */
				$my_posts = get_posts( apply_filters( 'ot_type_services_checkbox_query',
																						 array('post_type' => $post_type,
																									 'posts_per_page' => -1,
																									 'orderby' => 'id',
																									 'order' => 'ASC',
																									 'post_status' => 'any',
																									 'tax_query' => array(
																										 array(
																											 'taxonomy' => 'service-category',
																											 'field' => 'term_id',
																											 'terms' => $my_term->term_id,
																										 )
																									 )
																									),
																						 $field_id ) );

				/* has posts */
				if ( is_array( $my_posts ) && ! empty( $my_posts ) ) {
					foreach( $my_posts as $my_post ) {
						$post_title = '' != $my_post->post_title ? $my_post->post_title : 'Untitled';


						echo '<p>';
						echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $my_post->ID ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $my_post->ID ) . '" value="' . esc_attr( $my_post->ID ) . '" ' . ( isset( $field_value[$my_post->ID] ) ? checked( $field_value[$my_post->ID], $my_post->ID, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />';
						echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $my_post->ID ) . '">' . $post_title . '</label>';
						echo '</p>';
					}
				}
				echo '</div>';
			}

		} else {
			echo '<p><strong>'.__('Please add Service first', 'pe-services').'</strong></p>';
		}

		echo '</div>';

		echo '</div>';

	}

}

if ( ! function_exists( 'ot_type_taxonomy_checkbox_pe' ) ) {
  
	function ot_type_taxonomy_checkbox_pe( $args = array() ) {
	  
	  /* turns arguments array into variables */
	  extract( $args );
	  
	  /* verify a description */
	  $has_desc = $field_desc ? true : false;
	  
	  /* format setting outer wrapper */
	  echo '<div class="format-setting type-taxonomy-checkbox type-checkbox ' . ( $has_desc ? 'has-desc' : 'no-desc' ) . '">';
		
		/* description */
		echo $has_desc ? '<div class="description">' . htmlspecialchars_decode( $field_desc ) . '</div>' : '';
		
		/* format setting inner wrapper */
		echo '<div class="format-setting-inner">';
		  
		  /* setup the taxonomy */
		  $taxonomy = isset( $field_taxonomy ) ? explode( ',', $field_taxonomy ) : array( 'category' );
		  
		  /* get taxonomies */
		  $taxonomies = get_categories( apply_filters( 'ot_type_taxonomy_checkbox_query', array( 'hide_empty' => false, 'taxonomy' => $taxonomy ), $field_id ) );
		  
		  /* has tags */
		  if ( $taxonomies ) {
			foreach( $taxonomies as $taxonomy ) {

				if( $taxonomy->category_parent > 0 ) {
					$parent_id = $taxonomy->category_parent;
					$parent_term = get_term( $parent_id );
					$parent_name = '(' . esc_attr( $parent_term->name ) . ') ';
				} else {
					$parent_name = '';
				}

			  echo '<p>';
				echo '<input type="checkbox" name="' . esc_attr( $field_name ) . '[' . esc_attr( $taxonomy->term_id ) . ']" id="' . esc_attr( $field_id ) . '-' . esc_attr( $taxonomy->term_id ) . '" value="' . esc_attr( $taxonomy->term_id ) . '" ' . ( isset( $field_value[$taxonomy->term_id] ) ? checked( $field_value[$taxonomy->term_id], $taxonomy->term_id, false ) : '' ) . ' class="option-tree-ui-checkbox ' . esc_attr( $field_class ) . '" />';
				echo '<label for="' . esc_attr( $field_id ) . '-' . esc_attr( $taxonomy->term_id ) . '">' . $parent_name . esc_attr( $taxonomy->name ) . '</label>';
			  echo '</p>';
			} 
		  } else {
			echo '<p>' . __( 'No Taxonomies Found', 'option-tree' ) . '</p>';
		  }
		  
		echo '</div>';
	  
	  echo '</div>';
	  
	}
	
  }

/*-----------------------------------------------------------------------------------*/
/*	Register the new options
/*-----------------------------------------------------------------------------------*/

function pe_new_option_types( $types ) {
	$types['empty'] = 'Empty';
	$types['opening_hours'] = __('Opening Hour', 'pe-services');
	$types['service_checkbox'] = __('Profession Checkbox', 'pe-services');
	return $types;
}
add_filter( 'ot_option_types_array', 'pe_new_option_types' );

/*-----------------------------------------------------------------------------------*/
/*	Meta Boxes
/*-----------------------------------------------------------------------------------*/

    get_template_part( '/inc/option-tree/custom/meta-boxes' );


?>