<?php

		/**
		 * For full documentation, please visit: http://docs.reduxframework.com/
		 * For a more extensive sample-config file, you may look at:
		 * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
		 */

		if ( ! class_exists( 'Redux' ) ) {
				return;
		}

		// This is your option name where all the Redux data is stored.
		$opt_name = 'pe_redux';

		/**
		 * ---> SET ARGUMENTS
		 * All the possible arguments for Redux.
		 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
		 * */

		$theme = wp_get_theme(); // For use with some settings. Not necessary.

		$args = array(
				'opt_name' => $opt_name,
				'display_name' => $theme->get('Name'),
				'display_version' => $theme->get('Version'),
				'menu_type' => 'menu',
				'allow_sub_menu' => TRUE,
				'menu_title' => __( 'Theme Options', 'PixelEmu' ),
				'page_title' => __( 'Theme Options', 'PixelEmu' ),
				'update_notice' => TRUE,
				'admin_bar' => TRUE,
				'page_slug' => 'pixelemu_options',
				'menu_icon' => get_template_directory_uri() .'/images/admin/pe_icon.png',
				'page_parent_post_type' => 'your_post_type',
				'page_priority' => '25',
				'customizer' => FALSE,
				'default_mark' => '',
				'class' => 'pixelemu-options',
				'output' => TRUE,
				'output_tag' => TRUE,
				'settings_api' => TRUE,
				'cdn_check_time' => '1440',
				'compiler' => TRUE,
				'page_permissions' => 'manage_options',
				'save_defaults' => TRUE,
				'show_import_export' => TRUE,
				'database' => '',
				'transient_time' => '3600',
				'network_sites' => TRUE,
				'dev_mode' => FALSE,
				'hints' => array(
										'icon_position' => 'left',
										'icon_size' => 'normal',
										'tip_style' => array(
											'color' => 'light',
										),
										'tip_position' => array(
											'my' => 'top left',
											'at' => 'bottom right',
										),
										'tip_effect' => array(
											'show' => array(
												'duration' => '500',
												'event' => 'mouseover',
											),
											'hide' => array(
												'duration' => '500',
												'event' => 'mouseleave unfocus',
											),
										),
									),
		);

		// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
		$args['share_icons'][] = array(
				'url'   => 'http://www.facebook.com/PixelEmu',
				'title' => 'Like us on Facebook',
				'icon'  => 'el el-facebook'
		);
		$args['share_icons'][] = array(
				'url'   => 'https://twitter.com/PixelEmu',
				'title' => 'Follow us on Twitter',
				'icon'  => 'el el-twitter'
		);
		$args['share_icons'][] = array(
				'url'   => 'https://plus.google.com/u/0/+Pixelemu/posts',
				'title' => 'Find us on Google Plus',
				'icon'  => 'el el-icon-googleplus'
		);
		$args['share_icons'][] = array(
				'url'   => 'https://www.youtube.com/channel/UC8gwlTKMLRG21SUo0YvgJIA',
				'title' => 'Find us on Youtube',
				'icon'  => 'el el-icon-youtube'
		);
		$args['share_icons'][] = array(
				'url'   => 'https://www.behance.net/PixelEmu',
				'title' => 'Find us on Behance',
				'icon'  => 'el el-icon-behance'
		);

		Redux::setArgs( $opt_name, $args );

		/*
		 * ---> END ARGUMENTS
		 */


		/*
		 *
		 * ---> START SECTIONS
		 *
		 */

// -----------------------------------------------------------------------------
// BASIC SETTINGS
// -----------------------------------------------------------------------------

		//get default variables
		require( get_template_directory() . '/inc/default-vars.php');

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Basic Settings', 'PixelEmu' ),
				'id'         => 'basic-settings',
				'icon'  => 'el el-cogs',
				'fields'     => array(
												array(
														'id'       => 'logo',
														'type'     => 'media',
														'operator' => 'and',
														'title'    => __( 'Logo', 'PixelEmu' ),
														'subtitle' => __( 'Upload a logo image here.', 'PixelEmu' ),
														'default'  => '',
												),
												array (
													'id'       => 'favicon',
													'type'     => 'media',
													'operator' => 'and',
													'title'    => __( 'Favicon', 'PixelEmu' ),
													'subtitle' => __( 'Upload a favicon file here.', 'PixelEmu' ),
													'default'  => '',
												),
												array(
														'id'       => 'back-to-top',
														'type'     => 'switch',
														'title'    => __('Back to Top', 'PixelEmu'),
														'subtitle' => __('Enable / disable back to top button.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'sticky-topbar',
														'type'     => 'switch',
														'title'    => __('Sticky Topbar', 'PixelEmu'),
														'subtitle' => __('Enable / disable the sticky top menu.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'search-bar',
														'type'     => 'switch',
														'title'    => __('Search form in Topbar', 'PixelEmu'),
														'subtitle' => __('Enable / disable the Search form in top bar.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'off-canavs-sidebar',
														'type'     => 'switch',
														'title'    => __('Off-canvas sidebar', 'PixelEmu'),
														'subtitle' => __('Enable / disable the Off-canvas sidebar.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'off-canavs-width',
														'type'     => 'dimensions',
														'height'   => false,
														'units'    => array('px'),
														'title'    => __('Off-canvas Width', 'PixelEmu'),
														'subtitle' => __('Enter the Off-canvas panel width.', 'PixelEmu'),
														'default'  => array(
															'width'  => $PEoffcanvasWidth
														),
												),
												array(
														'id'       => 'off-canavs-position',
														'type'     => 'select',
														'title'    => __('Off-Canvas position', 'PixelEmu'),
														'subtitle' => __('Choose the position of Off-Canvas sidebar.', 'PixelEmu'),
														'options'  => array(
																'right' => __('Right', 'PixelEmu'),
																'left'  => __('Left', 'PixelEmu')
														),
														'default'  => 'right',
												),
												array(
														'id'       => 'coming-soon',
														'type'     => 'switch',
														'title'    => __('Coming Soon', 'PixelEmu'),
														'subtitle' => __('Enable / disable the Comming Soon page.', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'          => 'coming-soon-until-date',
														'type'        => 'date',
														'title'       => __('Coming Soon Until Date', 'PixelEmu'),
														'subtitle'    => __('Coming Soon date', 'PixelEmu'),
														'desc'        => __('Format: Month/Day/Year', 'PixelEmu'),
														'placeholder' => __('Click to enter a date', 'PixelEmu'),
														'default'     => '',
												),
												)
		));

// -----------------------------------------------------------------------------
// LAYOUT
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Layout', 'PixelEmu' ),
				'id'         => 'layout',
				'icon'  => 'el el-screen',
				'fields'     => array(
												array(
														'id'       => 'theme-width',
														'type'     => 'dimensions',
														'title'    => __('Page Width', 'PixelEmu'),
														'subtitle' => __('Enter page width.', 'PixelEmu'),
														'units'    => array( 'px', '%' ),
														'height'   => false,
														'default'  => array(
																'width' => $PEthemeWidth,
														),
												),
												array(
														'id'       => 'left-column-width',
														'type'     => 'select',
														'title'    => __('Left Column Width', 'PixelEmu'),
														'subtitle' => __('Left column width in percents.', 'PixelEmu'),
														'options'  => array(
																'1' => '8%',
																'2' => '17%',
																'3' => '25%',
																'4' => '33%',
																'5' => '42%',
																'6' => '50%',
																'7' => '58%',
																'8' => '67%',
																'9' => '75%',
																'10' => '83%'
														),
														'default'  => $PEleftColumnWidth,
												),
												array(
														'id'       => 'right-column-width',
														'type'     => 'select',
														'title'    => __('Right Column Width', 'PixelEmu'),
														'subtitle' => __('Right column width in percents.', 'PixelEmu'),
														'options'  => array(
																'1' => '8%',
																'2' => '17%',
																'3' => '25%',
																'4' => '33%',
																'5' => '42%',
																'6' => '50%',
																'7' => '58%',
																'8' => '67%',
																'9' => '75%',
																'10' => '83%'
														),
														'default'  => $PErightColumnWidth,
												),
												array(
														'id'       => 'frontpage-layout',
														'type'     => 'image_select',
														'title'    => __('Frontpage Layout', 'PixelEmu'),
														'subtitle' => __('Layout for frontpage - number of columns and arrangement of them.', 'PixelEmu'),
														'options'  => array(
																'1'      => array(
																		'alt'   => __('2 Column Left', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
																),
																'2'      => array(
																		'alt'   => __('2 Column Right', 'PixelEmu'),
																		'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
																),
																'3'      => array(
																		'alt'   => __('1 Column', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/1col.png'
																),
																'4'      => array(
																		'alt'   => __('3 Column Middle', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/3cm.png'
																),
																'5'      => array(
																		'alt'   => __('3 Column Left', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/3cl.png'
																),
																'6'      => array(
																		'alt'  => __('3 Column Right', 'PixelEmu'),
																		'img'  => ReduxFramework::$_url.'assets/img/3cr.png'
																)
														),
														'default' => $PEfrontpageLayout,
												),
												array(
														'id'       => 'subpage-layout',
														'type'     => 'image_select',
														'title'    => __('Subpage Layout', 'PixelEmu'),
														'subtitle' => __('Layout for subpage - number of columns and arrangement of them.', 'PixelEmu'),
														'options'  => array(
																'1'      => array(
																		'alt'   => __('2 Column Left', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
																),
																'2'      => array(
																		'alt'   => __('2 Column Right', 'PixelEmu'),
																		'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
																),
																'3'      => array(
																		'alt'   => __('1 Column', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/1col.png'
																),
																'4'      => array(
																		'alt'   => __('3 Column Middle', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/3cm.png'
																),
																'5'      => array(
																		'alt'   => __('3 Column Left', 'PixelEmu'),
																		'img'   => ReduxFramework::$_url.'assets/img/3cl.png'
																),
																'6'      => array(
																		'alt'  => __('3 Column Right', 'PixelEmu'),
																		'img'  => ReduxFramework::$_url.'assets/img/3cr.png'
																)
														),
														'default' => $PEsubpageLayout,
												),
												array(
														'id'       => 'header-width',
														'type'     => 'switch',
														'title'    => __('Header width', 'PixelEmu'),
														'subtitle' => __('Enable / disable the full width in header section.', 'PixelEmu'),
														'on'       => __('Full screen width', 'PixelEmu'),
														'off'      => __('Page width', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'top2-width',
														'type'     => 'switch',
														'title'    => __('Top2 width', 'PixelEmu'),
														'subtitle' => __('Enable / disable the full width in top2 section.', 'PixelEmu'),
														'on'       => __('Full screen width', 'PixelEmu'),
														'off'      => __('Page width', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'bottom2-width',
														'type'     => 'switch',
														'title'    => __('Bottom2 width', 'PixelEmu'),
														'subtitle' => __('Enable / disable the full width in bottom2 section.', 'PixelEmu'),
														'on'       => __('Full screen width', 'PixelEmu'),
														'off'      => __('Page width', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'footer-width',
														'type'     => 'switch',
														'title'    => __('Footer width', 'PixelEmu'),
														'subtitle' => __('Enable / disable the full width in footer section.', 'PixelEmu'),
														'on'       => __('Full screen width', 'PixelEmu'),
														'off'      => __('Page width', 'PixelEmu'),
														'default'  => false,
												),



												)
		));

// -----------------------------------------------------------------------------
// Main Menu
// -----------------------------------------------------------------------------

Redux::setSection( $opt_name, array(
			'title'      => __( 'Main Menu', 'PixelEmu' ),
			'desc' => __('Settings for default Main Menu only. If MaxMegaMenu plugin enabled, please configure plugin settings.', 'PixelEmu'),
			'id'         => 'main-menu',
			'icon'  => 'el el-th-list',
			'fields'     => array(
											array(
													'id'       => 'main-menu-switch',
													'type'     => 'switch',
													'title'    => __('Menu type', 'PixelEmu'),
													'subtitle' => __('Select main menu type.', 'PixelEmu'),
													'on'       => __('Max Mega Menu', 'PixelEmu'),
													'off'      => __('Simple Menu', 'PixelEmu'),
													'default'  => true,
											),
											array(
													'id'     => 'menu-info',
													'type'   => 'info',
													'notice' => false,
													'desc'   => __( 'Max Mega Menu plugin must be <strong>enabled</strong>. Please check plugins page.', 'PixelEmu' ),
													'required' => array( 'main-menu-switch', '=', true ),
											),
											array(
													'id'     => 'menu-info2',
													'type'   => 'info',
													'notice' => false,
													'desc'   => __( 'Max Mega Menu plugin must be <strong>disabled</strong>. Please check plugins page.', 'PixelEmu' ),
													'required' => array( 'main-menu-switch', '=', false ),
											),
											array(
													'id'       => 'responsive-breakpoint',
													'type'     => 'dimensions',
													'height'   => false,
													'units'    => 'px',
													'title'    => __('Responsive Breakpoint', 'PixelEmu'),
													'subtitle' => __('Set the width at which the menu turns into a mobile menu.', 'PixelEmu'),
													'default'  => array(
															'width'   => $PEresponsiveBreakpoint
													),
													'required' => array( 'main-menu-switch', '=', false ),
											),
											array(
													'id'       => 'PEtopmenuBackground',
													'type'     => 'color',
													'title'    => __('Main Menu Background', 'PixelEmu'),
													'subtitle' => __('Choose color for buttons, pagination, testimonials.', 'PixelEmu'),
													'default'  => $PEtopmenuBackground,
													'validate' => 'color',
													'transparent' => false,
													'required' => array( 'main-menu-switch', '=', false ),
											),
											array(
													'id'          => 'topmenu-font',
													'type'        => 'typography',
													'title'       => __('Main Menu', 'PixelEmu'),
													'google'      => true,
													'font-backup' => true,
													'text-transform' => true,
													'line-height' => false,
													'font-style'  => true,
													'letter-spacing' => true,
													'text-align' => false,
													'units'       =>'px',
													'subtitle'    => __('Typography for post titles.', 'PixelEmu'),
													'default'     => array(
															'color'       => $PEtopmenuFontColor,
															'font-weight'  => $PEtopmenuFontWeight,
															'text-transform' => $PEtopmenuFontTextTransform,
															'font-family' => $PEtopmenuFontFamily,
															'font-backup' => $PEtopmenuFontBackup,
															'google'      => true,
															'font-size'   => $PEtopmenuFontSize,
															'letter-spacing' => '', //$PEtopmenuFontLetterSpacing
															'font-style'	=> '', //$PEtopmenuFontStyle
													),
													'required' => array( 'main-menu-switch', '=', false ),
											),
											array(
													'id'          => 'topmenu-submenu-font',
													'type'        => 'typography',
													'title'       => __('Main Menu Submenu', 'PixelEmu'),
													'google'      => false,
													'color' => false,
													'font-size' => true,
													'font-family' => false,
													'font-backup' => false,
													'text-transform' => false,
													'line-height' => false,
													'font-style'  => false,
													'font-weight'  => true,
													'letter-spacing' => false,
													'text-align' => false,
													'units'       =>'px',
													'subtitle'    => __('Main Menu Submenu.', 'PixelEmu'),
													'default'     => array(
															'font-weight'  => $PEtopmenuSubmenuFontWeight,
															'font-size'   => $PEtopmenuSubmenuFontSize,
													),
													'required' => array( 'main-menu-switch', '=', false ),
											),
											)
		));

// -----------------------------------------------------------------------------
// POSTS AND PAGES
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Posts and Pages', 'PixelEmu' ),
				'id'         => 'posts-and-pages',
				'icon'  => 'el el-pencil',
				'fields'     => array(
												// FRONT PAGE
												array(
														'id'       => 'front-page-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('FRONT PAGE', 'PixelEmu'),
														'desc'     => __('Options for Front Page Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'front-page-content',
														'type'     => 'switch',
														'title'    => __('Front Page Content', 'PixelEmu'),
														'subtitle' => __('Enable / disable content section (Static page type only).', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'front-page-title',
														'type'     => 'switch',
														'title'    => __('Front Page Title', 'PixelEmu'),
														'subtitle' => __('Turn on or turn off page title (Static page type only).', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'breadcrumb-front',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => false,
												),

												// BLOG
												array(
														'id'       => 'blog-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('BLOG', 'PixelEmu'),
														'desc'     => __('Options for Blog Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'default-blog-layout',
														'type'     => 'select',
														'title'    => __('Default Blog Layout', 'PixelEmu'),
														'subtitle' => __('Choose the layout.', 'PixelEmu'),
														'desc'     => __('1 column: 1 post in a row<br />2 columns: 2 posts in a row', 'PixelEmu'),
														'options'  => array(
																'1' => '1 column',
																'2' => '2 columns',
														),
														'default'  => '1',
												),
												array(
														'id'       => 'breadcrumb-blog',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-info-blog',
														'type'     => 'switch',
														'title'    => __('Post Info', 'PixelEmu'),
														'subtitle' => __('Enable / disable post info (blog category, created date).', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-thumbnail-blog',
														'type'     => 'switch',
														'title'    => __('Post intro image', 'PixelEmu'),
														'subtitle' => __('Enable / disable post intro image.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'intro-effect-blog',
														'type'     => 'switch',
														'title'    => __('Intro Image Effect', 'PixelEmu'),
														'subtitle' => __('Enable / disable effect on intro image.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'readmore-blog',
														'type'     => 'switch',
														'title'    => __('Readmore', 'PixelEmu'),
														'subtitle' => __('Enable / disable readmore button.', 'PixelEmu'),
														'default'  => true,
												),
												//ARCHIVE
												array(
														'id'       => 'archive-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('ARCHIVE', 'PixelEmu'),
														'desc'     => __('Options for Archive Layout (Category, Tag, Author, Day, Moth, Year View).', 'PixelEmu'),
												),
												array(
														'id'       => 'subpage-blog-layout',
														'type'     => 'select',
														'title'    => __('Subpage Blog Layout', 'PixelEmu'),
														'subtitle' => __('Choose the layout.', 'PixelEmu'),
														'desc'     => __('1 column: 1 post in a row<br />2 columns: 2 posts in a row', 'PixelEmu'),
														'options'  => array(
																'1' => '1 column',
																'2' => '2 columns',
														),
														'default'  => '1',
												),
												array(
														'id'       => 'breadcrumb-archive',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-info-archive',
														'type'     => 'switch',
														'title'    => __('Post Info', 'PixelEmu'),
														'subtitle' => __('Enable / disable post info (category, created date).', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-thumbnail-archive',
														'type'     => 'switch',
														'title'    => __('Post intro image', 'PixelEmu'),
														'subtitle' => __('Enable / disable post intro image.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'intro-effect-archive',
														'type'     => 'switch',
														'title'    => __('Intro Image Effect', 'PixelEmu'),
														'subtitle' => __('Enable / disable effect on intro image.', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'readmore-archive',
														'type'     => 'switch',
														'title'    => __('Readmore', 'PixelEmu'),
														'subtitle' => __('Enable / disable readmore button.', 'PixelEmu'),
														'default'  => true,
												),
												//SINGLE POST
												array(
														'id'       => 'single-post-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('SINGLE POST', 'PixelEmu'),
														'desc'     => __('Options for Single Post Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'breadcrumb-post',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-info-post',
														'type'     => 'switch',
														'title'    => __('Post Info', 'PixelEmu'),
														'subtitle' => __('Enable / disable post info (category, created date).', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'post-tags-post',
														'type'     => 'switch',
														'title'    => __('Tags', 'PixelEmu'),
														'subtitle' => __('Enable / disable tags.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'author-info-post',
														'type'     => 'switch',
														'title'    => __('Author info', 'PixelEmu'),
														'subtitle' => __('Enable / disable Author info (ex: avatar, bio, website) under content.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'comments-post',
														'type'     => 'switch',
														'title'    => __('Comments', 'PixelEmu'),
														'subtitle' => __('Enable / disable comments.', 'PixelEmu'),
														'default'  => true,
												),
												//SINGLE PAGE
												array(
														'id'       => 'single-page-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('SINGLE PAGE', 'PixelEmu'),
														'desc'     => __('Options for Single Page Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'breadcrumb-page',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'comments-page',
														'type'     => 'switch',
														'title'    => __('Comments', 'PixelEmu'),
														'subtitle' => __('Enable / disable comments.', 'PixelEmu'),
														'default'  => true,
												),
												//SERVICE PAGE
												array(
														'id'       => 'service-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('SERVICE PAGE', 'PixelEmu'),
														'desc'     => __('Options for Single Service Page Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'breadcrumb-service',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												//SINGLE MEMBER PAGE
												array(
														'id'       => 'single-member-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('SINGLE MEMBER PAGE', 'PixelEmu'),
														'desc'     => __('Options for Single Member Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'breadcrumb-member',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'image-size-member',
														'type'     => 'select',
														'title'    => __('Avatar Size', 'PixelEmu'),
														'subtitle' => __('Please choose member image size.', 'PixelEmu'),
														'options'  => array(
																'thumbnail' => __('Thumbnail', 'PixelEmu'),
																'medium'    => __('Medium', 'PixelEmu'),
																'large'     => __('Large', 'PixelEmu'),
														),
														'default'  => 'medium',
												),
												array(
														'id'       => 'opening-hours-member',
														'type'     => 'switch',
														'title'    => __('Opening Hours', 'PixelEmu'),
														'subtitle' => __('Enable / disable openig hours.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'contact-info-member',
														'type'     => 'switch',
														'title'    => __('Contact Info', 'PixelEmu'),
														'subtitle' => __('Enable / disable contact info.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'social-links-member',
														'type'     => 'switch',
														'title'    => __('Social links', 'PixelEmu'),
														'subtitle' => __('Enable / disable social links.', 'PixelEmu'),
														'default'  => true,
												),
												//SINGLE TESTIMONIAL PAGE
												array(
														'id'       => 'single-testimonial-raw',
														'type'     => 'info',
														'style'    => 'info',
														'title'    => __('SINGLE TESTIMONIAL PAGE', 'PixelEmu'),
														'desc'     => __('Options for Single Testimonial Layout.', 'PixelEmu'),
												),
												array(
														'id'       => 'breadcrumb-testimonial',
														'type'     => 'switch',
														'title'    => __('Breadcrumbs', 'PixelEmu'),
														'subtitle' => __('Enable / disable breadcrumb navigation.', 'PixelEmu'),
														'default'  => true,
												),
												)
		));

// -----------------------------------------------------------------------------
// FONTS
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Fonts', 'PixelEmu' ),
				'id'         => 'fonts',
				'icon'  => 'el el-font',
				'fields'     => array(
												array(
														'id'          => 'body-font',
														'type'        => 'typography',
														'title'       => __('Body', 'PixelEmu'),
														'google'      => true,
														'font-backup' => true,
														'text-transform' => true,
														'line-height' => false,
														'font-style'  => true,
														'letter-spacing' => true,
														'text-align' => false,
														'units'       =>'px',
														'subtitle'    => __('Typography for BODY.', 'PixelEmu'),
														'default'     => array(
																'color'       => $PEbodyFontColor,
																'font-weight'  => $PEbodyFontWeight,
																'text-transform' => $PEbodyFontTextTransform,
																'font-family' => $PEbodyFontFamily,
																'font-backup' => $PEbodyFontBackup,
																'google'      => true,
																'font-size'   => $PEbodyFontSize,
																'letter-spacing' => '', //$PEbodyFontLetterSpacing
																'font-style'	=> '', //$PEbodyFontStyle
														),
												),
												array(
														'id'          => 'posts-font',
														'type'        => 'typography',
														'title'       => __('Posts Titles', 'PixelEmu'),
														'google'      => true,
														'font-backup' => true,
														'text-transform' => true,
														'line-height' => false,
														'font-style'  => true,
														'letter-spacing' => true,
														'text-align' => false,
														'units'       =>'px',
														'subtitle'    => __('Typography for post titles.', 'PixelEmu'),
														'default'     => array(
																'color'       => $PEpostFontColor,
																'font-weight'  => $PEpostFontWeight,
																'text-transform' => $PEpostFontTextTransform,
																'font-family' => $PEpostFontFamily,
																'font-backup' => $PEpostFontBackup,
																'google'      => true,
																'font-size'   => $PEpostFontSize,
																'letter-spacing' => '', //$PEbodyFontLetterSpacing
																'font-style'	=> '', //$PEbodyFontStyle
														),
												),
												array(
														'id'          => 'widgets-font',
														'type'        => 'typography',
														'title'       => __('Widgets Titles', 'PixelEmu'),
														'google'      => true,
														'font-backup' => true,
														'text-transform' => true,
														'line-height' => false,
														'font-style'  => true,
														'letter-spacing' => true,
														'text-align' => false,
														'units'       =>'px',
														'subtitle'    => __('Typography for widget titles.', 'PixelEmu'),
														'default'     => array(
																'color'          => $PEwidgetFontColor,
																'font-weight'    => $PEwidgetFontWeight,
																'text-transform' => $PEwidgetFontTextTransform,
																'font-family'    => $PEwidgetFontFamily,
																'font-backup'    => $PEwidgetFontBackup,
																'google'         => true,
																'font-size'      => $PEwidgetFontSize,
																'letter-spacing' => '', //$PEbodyFontLetterSpacing
																'font-style'     => '', //$PEbodyFontStyle
														),
												),
												)
		));


// -----------------------------------------------------------------------------
// COLORS
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Colors', 'PixelEmu' ),
				'id'         => 'colors',
				'icon'  => 'el el-brush',
				'fields'     => array(
												array(
														'id'          => 'PEmainSchemeColor',
														'type'        => 'color',
														'title'       => __('Main scheme color', 'PixelEmu'),
														'subtitle'    => __('Modify theme color.', 'PixelEmu'),
														'default'     => $PEmainSchemeColor,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEcomplementary',
														'type'        => 'color',
														'title'       => __('Complementary color', 'PixelEmu'),
														'subtitle'    => __('Choose color for buttons, pagination, testimonials.', 'PixelEmu'),
														'default'     => $PEcomplementary,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEpageBackground',
														'type'        => 'color',
														'title'       => __('Page background', 'PixelEmu'),
														'subtitle'    => __('Choose the Page background color.', 'PixelEmu'),
														'default'     => $PEpageBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEbaseBorder',
														'type'        => 'color',
														'title'       => __('Base border color', 'PixelEmu'),
														'subtitle'    => __('Choose Base border color.', 'PixelEmu'),
														'default'     => $PEbaseBorder,
														'validate'    => 'color',
														'transparent' => false,
												),
												//topbar
												array(
														'id'          => 'PEtopBarBackground',
														'type'        => 'color',
														'title'       => __('Top Bar background', 'PixelEmu'),
														'subtitle'    => __('Choose the Top Bar background color.', 'PixelEmu'),
														'default'     => $PEtopBarBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEtopBarText',
														'type'        => 'color',
														'title'       => __('Top Bar Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Top Bar text color.', 'PixelEmu'),
														'default'     => $PEtopBarText,
														'validate'    => 'color',
														'transparent' => false,
												),
												//menubar
												array(
														'id'          => 'PEmenuBarBackground',
														'type'        => 'color',
														'title'       => __('Bar background', 'PixelEmu'),
														'subtitle'    => __('Choose the Menu and Logo bar background.', 'PixelEmu'),
														'default'     => $PEmenuBarBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												//header
												array(
														'id'          => 'PEheaderBackground',
														'type'        => 'color',
														'title'       => __('Header background', 'PixelEmu'),
														'subtitle'    => __('Choose the Header background color.', 'PixelEmu'),
														'default'     => $PEheaderBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEheaderText',
														'type'        => 'color',
														'title'       => __('Header Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Header text color.', 'PixelEmu'),
														'default'     => $PEheaderText,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEheaderWidgetTitle',
														'type'        => 'color',
														'title'       => __('Header Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the Header widget title color.', 'PixelEmu'),
														'default'     => $PEheaderWidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												//top1
												array(
														'id'          => 'PEtop1Background',
														'type'        => 'color',
														'title'       => __('Top1 background', 'PixelEmu'),
														'subtitle'    => __('Choose the Top1 background color.', 'PixelEmu'),
														'default'     => $PEtop1Background,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEtop1Text',
														'type'        => 'color',
														'title'       => __('Top1 Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Top1 text color.', 'PixelEmu'),
														'default'     => $PEtop1Text,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEtop1WidgetTitle',
														'type'        => 'color',
														'title'       => __('Top1 Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the top1 widget title color.', 'PixelEmu'),
														'default'     => $PEtop1WidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												//top2
												array(
														'id'          => 'PEtop2Background',
														'type'        => 'color',
														'title'       => __('Top2 background', 'PixelEmu'),
														'subtitle'    => __('Choose the Top2 background color.', 'PixelEmu'),
														'default'     => $PEtop2Background,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEtop2Text',
														'type'        => 'color',
														'title'       => __('Top2 Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Top2 text color.', 'PixelEmu'),
														'default'     => $PEtop2Text,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEtop2WidgetTitle',
														'type'        => 'color',
														'title'       => __('Top2 Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the top2 widget title color.', 'PixelEmu'),
														'default'     => $PEtop2WidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												//bottom2
												array(
														'id'          => 'PEbottom2Background',
														'type'        => 'color',
														'title'       => __('Bottom2 background', 'PixelEmu'),
														'subtitle'    => __('Choose the Bottom2 background color.', 'PixelEmu'),
														'default'     => $PEbottom2Background,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEbottom2Text',
														'type'        => 'color',
														'title'       => __('Bottom2 Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Bottom2 text color.', 'PixelEmu'),
														'default'     => $PEbottom2Text,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEbottom2WidgetTitle',
														'type'        => 'color',
														'title'       => __('Bottom2 Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the bottom2 widget title color.', 'PixelEmu'),
														'default'     => $PEbottom2WidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												//footer
												array(
														'id'          => 'PEfooterBackground',
														'type'        => 'color',
														'title'       => __('Footer background', 'PixelEmu'),
														'subtitle'    => __('Choose the Footer background color.', 'PixelEmu'),
														'default'     => $PEfooterBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEfooterText',
														'type'        => 'color',
														'title'       => __('Footer Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Footer text color.', 'PixelEmu'),
														'default'     => $PEfooterText,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEfooterWidgetTitle',
														'type'        => 'color',
														'title'       => __('Footer Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the Footer widget title color.', 'PixelEmu'),
														'default'     => $PEfooterWidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												//copyright
												array(
														'id'          => 'PEcopyrightBackground',
														'type'        => 'color',
														'title'       => __('Copyright background', 'PixelEmu'),
														'subtitle'    => __('Choose the Copyright background color.', 'PixelEmu'),
														'default'     => $PEcopyrightBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEcopyrightText',
														'type'        => 'color',
														'title'       => __('Copyright Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Copyright text color.', 'PixelEmu'),
														'default'     => $PEcopyrightText,
														'validate'    => 'color',
														'transparent' => false,
												),
												// OFFCANVAS
												// ---------------------
												array(
														'id'          => 'PEoffcanvasIcon',
														'type'        => 'color',
														'title'       => __('Offcanvas Icon', 'PixelEmu'),
														'subtitle'    => __('Choose the Offcanvas icon color.', 'PixelEmu'),
														'default'     => $PEoffcanvasIcon,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEoffcanvasBackground',
														'type'        => 'color',
														'title'       => __('Offcanvas Background', 'PixelEmu'),
														'subtitle'    => __('Choose the Offcanvas background color.', 'PixelEmu'),
														'default'     => $PEoffcanvasBackground,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEoffcanvasText',
														'type'        => 'color',
														'title'       => __('Offcanvas Text', 'PixelEmu'),
														'subtitle'    => __('Choose the Offcanvas text color.', 'PixelEmu'),
														'default'     => $PEoffcanvasText,
														'validate'    => 'color',
														'transparent' => false,
												),
												array(
														'id'          => 'PEoffcanvasWidgetTitle',
														'type'        => 'color',
														'title'       => __('Offcanvas Widget Title', 'PixelEmu'),
														'subtitle'    => __('Choose the Offcanvas widget title color.', 'PixelEmu'),
														'default'     => $PEoffcanvasWidgetTitle,
														'validate'    => 'color',
														'transparent' => false,
												),
												)
		));

// -----------------------------------------------------------------------------
// FOOTER
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Footer', 'PixelEmu' ),
				'id'         => 'footer',
				'icon'  => 'el el-barcode',
				'fields'     => array(
												array(
														'id'       =>'copyright-info-text',
														'type'     => 'textarea',
														'title'    => __('Copyright Info', 'PixelEmu'),
														'subtitle' => __('Add text for copyright info at the bottom of the page.', 'PixelEmu'),
														'validate' => 'html_custom',
														'default'  => '',
														'allowed_html' => array(
																'a' => array(
																		'href' => array(),
																		'title' => array()
																),
																'br' => array(),
																'em' => array(),
																'strong' => array()
														)
												),
												array(
														'id'       => 'copyright-info',
														'type'     => 'switch',
														'title'    => '',
														'subtitle' => __('Enable / disable copyright info.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'pixelemu-copyright',
														'type'     => 'switch',
														'title'    => '',
														'subtitle' => __('Enable / disable PixelEmu copyright.', 'PixelEmu'),
														'default'  => true,
												),
												)
		));

// -----------------------------------------------------------------------------
// CONTACT
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Contact', 'PixelEmu' ),
				'id'         => 'contact',
				'icon'  => 'el el-comment',
				'fields'     => array(
												array(
														'id'       => 'contact-map',
														'type'     => 'switch',
														'title'    => 'Google Map',
														'subtitle' => __('Enable / disable Google map.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'contact-map-latitiude',
														'type'     => 'text',
														'title'    => 'Latitude',
														'subtitle' => __('Provide Google Map Latitude.', 'PixelEmu'),
														'default'  => '',
												),
												array(
														'id'       => 'contact-map-longitude',
														'type'     => 'text',
														'title'    => 'Longitude',
														'subtitle' => __('Provide Google Map Longitude.', 'PixelEmu'),
														'default'  => '',
												),
												array(
														'id'            => 'contact-map-zoom',
														'type'          => 'slider',
														'title'         => 'Zoom',
														'subtitle'      => __('Provice Google Map zoom level.', 'PixelEmu'),
														'default'       => 16,
														'min'           => 1,
														'step'          => 1,
														'max'           => 21,
														'display_value' => 'label',
												),
												array(
														'id'       => 'contact-details',
														'type'     => 'switch',
														'title'    => 'Contact Details',
														'subtitle' => __('Enable / disable Contact Details on Contact Page.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'contact-form',
														'type'     => 'switch',
														'title'    => 'Contact Form',
														'subtitle' => __('Enable / disable Contact Form on Contact Page.', 'PixelEmu'),
														'default'  => true,
												),
												array(
														'id'       => 'email-address',
														'type'     => 'text',
														'title'    => 'Email Address',
														'subtitle' => __('Provide email address that will be displayed on Contact Page.', 'PixelEmu'),
														'default'  => '',
												),
												array(
														'id'       => 'contact-address',
														'type'     => 'editor',
														'title'    => 'Contact Address',
														'subtitle' => __('Provide address that will be displayed on Contact Page.', 'PixelEmu'),
														'default'  => '',
												),
												array(
														'id'       => 'contact-email-recipients',
														'type'     => 'text',
														'title'    => 'Email Recipients',
														'subtitle' => __('Provide email address that will be used to receive emails from contact form.', 'PixelEmu'),
														'default'  => '',
												),
												array(
													'id'       => 'google-captcha',
													'type'     => 'switch',
													'title'    => __('Google reCAPTCHA', 'PixelEmu'),
													'subtitle' => __('Enable / disable Google reCaptcha field.','PixelEmu'),
													'default'  => false,
												),
												)
		));

// -----------------------------------------------------------------------------
// ADVANCED
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'Advanced', 'PixelEmu' ),
				'id'         => 'advanced',
				'icon'  => 'el el-wrench',
				'fields'     => array(
												array(
													'id'       => 'google-map-api',
													'type'     => 'switch',
													'title'    => 'Google Maps API',
													'subtitle' => __('Enable / disable loading Google Maps API (requred for Map shortcode or Contact Page).', 'PixelEmu'),
													'default'  => true,
												),
												array(
													'id'       => 'google-map-api-key',
													'type'     => 'text',
													'title'    => 'Maps API key',
													'subtitle' => __('Provide google maps API key (<a href="http://googlegeodevelopers.blogspot.com.au/2016/06/building-for-scale-updates-to-google.html" target="_blank">more details</a>,
																				<a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">get key</a>).', 'PixelEmu'),
													'default'  => '',
												),
												array(
													'id'       => 'google-captcha-api',
													'type'     => 'switch',
													'title'    => __('Google reCAPTCHA API', 'PixelEmu'),
													'subtitle' => __('Enable / disable loading Google reCaptcha API (requred for spam protection on Contact Page).','PixelEmu') . ' (<a href="' . __('https://www.google.com/recaptcha/', 'PixelEmu') . '" target="_blank">' . __('more details', 'PixelEmu') . '</a>)',
													'default'  => false,
												),
												array(
													'id'       => 'google-captcha-sitekey',
													'type'     => 'text',
													'title'    => __('reCAPTCHA Site key', 'PixelEmu'),
													'subtitle' => __('Provide google reCaptcha site key.', 'PixelEmu'),
													'default'  => '',
													'required' => array( 'google-captcha-api', '=', true ),
												),
											array(
													'id'       => 'google-captcha-secretkey',
													'type'     => 'text',
													'title'    => __('reCAPTCHA Secret key', 'PixelEmu'),
													'subtitle' => __('Provide google reCaptcha secret key.', 'PixelEmu'),
													'default'  => '',
													'required' => array( 'google-captcha-api', '=', true ),
												),
												array(
														'id'=>'head-custom-code',
														'type' => 'ace_editor',
														'mode' => 'html',
														'theme' => 'chrome',
														'title' => __('Head Custom Code', 'PixelEmu'),
														'subtitle' => __('Add custom code into the [HEAD] section if needed. Please put Javascript code inside script tags.', 'PixelEmu'),
														'default' => '',
												),
												array(
														'id'       =>'body-custom-code',
														'type'     => 'ace_editor',
														'mode'     => 'html',
														'theme'    => 'chrome',
														'title'    => __('Body Custom Code', 'PixelEmu'),
														'subtitle' => __('This code will be inserted right before closing the [/BODY] tag. Please put Javascript code inside script tags. Paste here Google Analytics Scripts, Google Re-marketing Tag, Google Webmaster Tools, etc.', 'PixelEmu'),
														'default'  => '',
												),
												array(
														'id'       => 'dynamic-css',
														'type'     => 'ace_editor',
														'mode'     => 'css',
														'theme'    => 'chrome',
														'title'    => __('Custom CSS', 'PixelEmu'),
														'subtitle' => __('In this field you can add custom CSS to your theme.', 'PixelEmu'),
														'default'  => '',
														'validate' => 'css',
												),
												array(
													'id'       => 'check-updates',
													'type'     => 'switch',
													'title'    => 'Check for updates',
													'on'       => 'Enable',
													'off'      => 'Disable',
													'subtitle' => __('Check for theme updates', 'PixelEmu'),
													'default'  => true,
												),


								)
		));

// -----------------------------------------------------------------------------
// Accessibility
// -----------------------------------------------------------------------------

Redux::setSection( $opt_name, array(
			'title'      => __( 'Accessibility', 'PixelEmu' ),
			'desc' => __('Accessibility (WCAG2.0) settings.', 'PixelEmu'),
			'id'         => 'wcag',
			'icon'  => 'el el-wheelchair',
			'fields'     => array(
											//WCAG
											array(
													'id'       => 'nightVersion',
													'type'     => 'switch',
													'title'    => __('Night mode', 'PixelEmu'),
													'subtitle' => __('Enable / disable night mode.', 'PixelEmu'),
													'default'  => false,
											),
											array(
													'id'       => 'highContrast',
													'type'     => 'switch',
													'title'    => __('High Contrast mode', 'PixelEmu'),
													'subtitle' => __('Enable / disable high contrast mode.', 'PixelEmu'),
													'default'  => false,
											),
											array(
												'id'       => 'wcagAnimation',
												'type'     => 'switch',
												'title'    => __('Disable animations', 'PixelEmu'),
												'subtitle' => __('Enable / disable CSS animations and transitions.', 'PixelEmu'),
												'default'  => true,
												'required' => array( 'highContrast', '=', true ),
											),
											array(
												'id'       => 'wcagFocus',
												'type'     => 'switch',
												'title'    => __('Focus border', 'PixelEmu'),
												'subtitle' => __('Enable / disable border on focused links.', 'PixelEmu'),
												'default'  => true,
												'required' => array( 'highContrast', '=', true ),
											),
											array(
													'id'       => 'wideSite',
													'type'     => 'switch',
													'title'    => __('Wide layout', 'PixelEmu'),
													'subtitle' => __('Enable / disable wide layout.', 'PixelEmu'),
													'default'  => false,
											),
											array(
													'id'       => 'fontSizeSwitcher',
													'type'     => 'switch',
													'title'    => __('Font Sizer', 'PixelEmu'),
													'subtitle' => __('Enable / disable font sizer.', 'PixelEmu'),
													'default'  => false,
											),
											//aria labels
											array(
													'id'       => 'skip-menu-label',
													'type'     => 'text',
													'title'    => __('Skip Menu Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Skip Content menu', 'PixelEmu'),
											),
											array(
												'id'       => 'menu-label',
												'type'     => 'text',
												'title'    => __('Main Menu Label', 'PixelEmu'),
												'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
												'default'  => __('Primary menu', 'PixelEmu'),
											),

											array(
													'id'       => 'header-mod-label',
													'type'     => 'text',
													'title'    => __('Header Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Header Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'services-mod-label',
													'type'     => 'text',
													'title'    => __('Header-Bottom Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Header-Bottom Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'top1-label',
													'type'     => 'text',
													'title'    => __('Top1 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Top1 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'top2-label',
													'type'     => 'text',
													'title'    => __('Top2 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Top2 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'top3-label',
													'type'     => 'text',
													'title'    => __('Top3 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Top3 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'top4-label',
													'type'     => 'text',
													'title'    => __('Top4 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Top4 Widgets', 'PixelEmu'),
											),
											array(
												'id'       => 'content-top-label',
												'type'     => 'text',
												'title'    => __('Content-Top Label', 'PixelEmu'),
												'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
												'default'  => __('Content Top Widgets', 'PixelEmu'),
											),
											array(
												'id'       => 'content-bottom-label',
												'type'     => 'text',
												'title'    => __('Content-Bottom Label', 'PixelEmu'),
												'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
												'default'  => __('Content Bottom Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'left-label',
													'type'     => 'text',
													'title'    => __('Left-Sidebar Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Left-Sidebar', 'PixelEmu'),
											),
											array(
													'id'       => 'right-label',
													'type'     => 'text',
													'title'    => __('Right-Sidebar Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Right-Sidebar', 'PixelEmu'),
											),
											array(
													'id'       => 'bottom1-label',
													'type'     => 'text',
													'title'    => __('Bottom1 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Bottom1 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'bottom2-label',
													'type'     => 'text',
													'title'    => __('Bottom2 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Bottom2 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'bottom3-label',
													'type'     => 'text',
													'title'    => __('Bottom3 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Bottom3 Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'bottom4-label',
													'type'     => 'text',
													'title'    => __('Bottom4 Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Bottom4 Widgets', 'PixelEmu'),
											),
											array(
												'id'       => 'footer-mod-label',
												'type'     => 'text',
												'title'    => __('Footer Label', 'PixelEmu'),
												'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
												'default'  => __('Footer Widgets', 'PixelEmu'),
											),
											array(
													'id'       => 'footer-label',
													'type'     => 'text',
													'title'    => __('Copyrights Label', 'PixelEmu'),
													'subtitle' => __('Section aria-label attribute.', 'PixelEmu'),
													'default'  => __('Copyrights', 'PixelEmu'),
											),

											)
		));

// -----------------------------------------------------------------------------
// HIGH RESOLUTION DISPLAY
// -----------------------------------------------------------------------------

		Redux::setSection( $opt_name, array(
				'title'      => __( 'High Resolution', 'PixelEmu' ),
				'id'         => 'retina',
				'icon'  => 'el el-idea',
				'desc'			=> __('', 'PixelEmu'),
				'fields'     => array(
												array(
														'id'     => 'retina-info',
														'type'   => 'info',
														'notice' => false,
														'desc'   => __( 'If you want to use High Resolution option remember to prepare duplicate of your images with higher resolutions and special name @2x.<br />Example: image.png - image@2x.png. Upload images in Media Library or via FTP client.', 'PixelEmu' )
												),
												array(
														'id'       => 'retina-display-support',
														'type'     => 'switch',
														'title'    => 'Retina JS',
														'subtitle' => __('Enable / disable high resolution support for images.', 'PixelEmu'),
														'default'  => false,
												),
												array(
														'id'       => 'retina-logo',
														'type'     => 'media',
														'operator' => 'and',
														'title'    => __( 'Logo', 'PixelEmu' ),
														'subtitle' => __( 'Upload a High Resolution logo image.', 'PixelEmu' ),
														'default'  => '',
												),


												)
		));


		/*
		 * <--- END SECTIONS
		 */
