<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	Load Required CSS Styles
/*-----------------------------------------------------------------------------------*/

	if( !function_exists('pe_theme_styles') ) {
		function pe_theme_styles() {
			if (  !is_admin() ) {

				//get theme variables
				$theme = wp_get_theme();

				// register styles
				// ----------------------------

				//CSS
				if ( ! (wp_style_is('normalize.min.css') ) ) {
					wp_enqueue_style( 'normalize',  get_template_directory_uri() . '/css/normalize.min.css', array(), '4.1.1' );
				}
				if ( ! (wp_style_is('animate.css') ) ) {
					wp_enqueue_style( 'animate',  get_template_directory_uri() . '/css/animate.min.css', array('normalize'), '3.5.1' );
				}
				wp_deregister_style( 'font-awesome' );
				if ( ! (wp_style_is('all.css') ) ) {
					wp_enqueue_style( 'font-awesome-all',  get_template_directory_uri() . '/css/font-awesome/all.css', '', '5.3.1' );
				}
				if ( ! (wp_style_is('v4-shims.css') ) ) {
					wp_enqueue_style( 'font-awesome-v4-shims',  get_template_directory_uri() . '/css/font-awesome/v4-shims.css', '', '5.3.1' );
				}

				//LESS

				wp_enqueue_style( 'theme',  get_template_directory_uri() . '/less/theme.less', array('normalize'), $theme->get( 'Version' ));

				//rtl
				if ( is_rtl() ) {
					wp_enqueue_style( 'rtl', get_template_directory_uri() . '/less/rtl.less', array('theme'), $theme->get( 'Version' ));
				}

				//custom css
				$customless = get_template_directory() . '/less/custom.less';
				if( is_file($customless) ) {
					wp_enqueue_style( 'custom',  get_template_directory_uri() . '/less/custom.less', array('theme'), $theme->get( 'Version' ));
				}

				//offcanvas
				$offcanvas_sidebar = peGetOptions('off-canavs-sidebar');
				if( $offcanvas_sidebar ) {
					wp_enqueue_style( 'offcanvas',  get_template_directory_uri() . '/less/offcanvas.less', array('theme'), $theme->get( 'Version' ));
				}

				//coming soon
				$comingsoondate = strtotime(peGetOptions('coming-soon-until-date'));
				$current_time = strtotime(current_time( 'mysql' ));
				$futuredate = ($current_time < $comingsoondate) ? true : false;
				if ( !is_user_logged_in() && peGetOptions('coming-soon') && $comingsoondate && $futuredate ) {
					wp_enqueue_style( 'comingsoon',  get_template_directory_uri() . '/less/comingsoon.less', array('theme'), $theme->get( 'Version' ));
				}

				//wcag
				$nightVersion = peGetOptions('nightVersion');
				$highContrast = peGetOptions('highContrast');
				if( $highContrast ) {
					wp_enqueue_style( 'highcontrast', get_template_directory_uri() . '/less/high-contrast.less', array( 'theme' ), $theme->get( 'Version' ));
				}
				if( $nightVersion ) {
					wp_enqueue_style( 'nightversion', get_template_directory_uri() . '/less/night-version.less', array( 'theme' ), $theme->get( 'Version' ));
				}

				//default style.css
				wp_enqueue_style( 'style', get_template_directory_uri() . '/style.css', array( 'theme' ), $theme->get( 'Version' ));

				//dynamic css (css validation in redux framework)
				if ( peGetOptions('dynamic-css') ){
					$custom_css = wp_strip_all_tags( peGetOptions('dynamic-css') );
					wp_add_inline_style( 'style', $custom_css );
				}

			}
		}
	}
	add_action( 'wp_enqueue_scripts', 'pe_theme_styles', 99 );

	//load backend styles
	function pe_admin_styles() {
		//get theme variables
		$theme = wp_get_theme();
		wp_enqueue_style( 'pe_admin', get_template_directory_uri() . '/css/pe-admin.css', array(), $theme->get( 'Version' ), 'all' );
	}
	add_action( 'admin_enqueue_scripts', 'pe_admin_styles' );

/*-----------------------------------------------------------------------------------*/
/*	Load Required JS Scripts
/*-----------------------------------------------------------------------------------*/

	if( !function_exists('pe_theme_scripts') ){
		function pe_theme_scripts(){

			//get theme variables
			$theme = wp_get_theme();

			wp_enqueue_script( 'slick', get_template_directory_uri() . '/js/slick.min.js', array( 'jquery' ), '1.5.9', true);
			wp_enqueue_script( 'jqvalidate', get_template_directory_uri() . '/js/jquery.validate.min.js', array( 'jquery' ), '1.14.0', true);
			wp_enqueue_script( 'waypoints', get_template_directory_uri() . '/js/jquery.waypoints.min.js', array( 'jquery' ), '4.0.0', true);
			wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/js/jquery.magnific-popup.min.js', array( 'jquery' ), '1.0.1', true);
			wp_enqueue_script( 'jqform', get_template_directory_uri() . '/js/jquery.form.js', array( 'jquery' ), '3.51', true);
			wp_enqueue_script( 'jqcookie', get_template_directory_uri() . '/js/js.cookie.js', array( 'jquery' ), '2.1.0', true);

			//retina display
			$retinaDisplay = peGetOptions('retina-display-support');
			if( $retinaDisplay ) {
				wp_enqueue_script( 'retinajs', get_template_directory_uri() . '/js/retina.min.js', array( 'jquery' ), '1.3.0', true);
			}

			//wcag
			$nightVersion = peGetOptions('nightVersion');
			$highContrast = peGetOptions('highContrast');
			$wideSite = peGetOptions('wideSite');
			if( $nightVersion or $highContrast or $wideSite or peGetOptions('fontSizeSwitcher') ) {
				wp_enqueue_script( 'wcag', get_template_directory_uri() . '/js/wcag.js', array( 'jquery' ), $theme->get( 'Version' ), true);
			}

			wp_enqueue_script( 'theme_js', get_template_directory_uri() . '/js/theme.js', array( 'jquery' ), $theme->get( 'Version' ), true);

			$googleMapApi = peGetOptions('google-map-api');
			if( $googleMapApi ) {
				$googleMapKey = ( peGetOptions('google-map-api-key') ) ? peGetOptions('google-map-api-key') : false;

				if( $googleMapKey ) {
					// Localize the script with new data
					$maparr = array(
						'key' => esc_js( $googleMapKey ),
					);
					wp_localize_script( 'jquery-migrate', 'pemaps', $maparr );
				}

				if( is_page_template( 'page-templates/page-contact.php' ) ) {
					$googleMapKey = ( peGetOptions('google-map-api-key') ) ? '?key=' . peGetOptions('google-map-api-key') : '';
					wp_enqueue_script( 'google-maps-api', '//maps.googleapis.com/maps/api/js' . $googleMapKey, array(), '', false);
				}
			}

		}
	}
	add_action( 'wp_enqueue_scripts', 'pe_theme_scripts' );

	function pe_admin_scripts() {
		//get theme variables
		$theme = wp_get_theme();

		wp_enqueue_script( 'admin_js', get_template_directory_uri() . '/js/admin.js', array( 'jquery' ), $theme->get( 'Version' ), false);

		// Localize the script with new data
		$translation_array = array(
			'label' => __( 'Please select a category for this post!', 'pe-services' ),
		);
		wp_localize_script( 'admin_js', 'category_required', $translation_array );

	}
	add_action( 'admin_enqueue_scripts', 'pe_admin_scripts' );

?>
