<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
 ---------------------------------------------------------------*/

add_action('wp_ajax_nopriv_send_email', 'pe_send_email');
add_action('wp_ajax_send_email', 'pe_send_email');

if ( !function_exists('pe_send_email') ) {
	function pe_send_email() {

		if ( isset($_POST['nonce']) ) {

			$nonce = $_POST['nonce'];
			$fromName = sanitize_text_field( $_POST['contactName'] );
			$fromEmail = sanitize_email( $_POST['contactEmail'] );
			$subject = sanitize_text_field( $_POST['contactSubject'] );
			$message = stripslashes( esc_attr($_POST['contactMessage']) );
			$targetEmail = sanitize_email( peGetOptions('contact-email-recipients') );

			if ( ! wp_verify_nonce($nonce, 'send_email_nonce') ) {
				echo json_encode(array('success' => false, 'message' => __('Unverified nonce!', 'pe-services')));
				die();
			}

			/* Validate Target email and From email */
			$targetEmail = is_email( $targetEmail );
			if( !$targetEmail ) {
				echo json_encode(array('success' => false, 'message' => __('Target email address is not properly configured!', 'pe-services')));
				die();
			}

			$fromEmail = is_email( $fromEmail );
			if( !$fromEmail ) {
				echo json_encode(array('success' => false, 'message' => __('Provided email address is invalid!', 'pe-services')));
				die();
			}

			$email_subject = __('New message sent by', 'pe-services') . ' ' . $fromName . ' ' . __('using contact form at', 'pe-services') . ' ' . get_bloginfo('name');
			$email_body = __("You have received a message from: ", 'pe-services') . $fromName . " <br/>";

			if ( !empty($subject) ) {
				$email_body .= __("Subject : ", 'pe-services') . $subject . " <br/>";
			}

			$email_body .= __("Message: ", 'pe-services') . " <br/>";
			$email_body .= wpautop($message) . " <br/>";
			$email_body .= __("You can contact ", 'pe-services') . $fromName . __(" via email, ", 'pe-services') . $fromEmail;

			$header = 'Content-type: text/html; charset=utf-8' . "\r\n";
			$header .= 'From: ' . $fromName . " <" . $fromEmail . "> \r\n";

			//captcha enabled
			$reCaptchaOpt = ( peGetOptions('google-captcha') && peGetOptions('google-captcha-api') && peGetOptions('google-captcha-sitekey') && peGetOptions('google-captcha-secretkey') ) ? true : false;

			if( $reCaptchaOpt && isset($_POST['g-recaptcha-response']) ) {

				$secret = peGetOptions('google-captcha-secretkey');
				$recaptcha = new \ReCaptcha\ReCaptcha($secret);

				$resp = $recaptcha->verify($_POST['g-recaptcha-response'], $_SERVER['REMOTE_ADDR']);

				if ( $resp->isSuccess() ) {
					// Your code here to handle a successful verification

					if( wp_mail($targetEmail, $email_subject, $email_body, $header) ) {
						echo json_encode(array('success' => true, 'message' => __("Message sent successfully!", 'pe-services')));
					} else {
						echo json_encode(array('success' => false, 'message' => __("Server Error: WordPress mail function failed!", 'pe-services')));
					}

				} else {
					// What happens when the CAPTCHA was entered incorrectly
					echo json_encode(array('success' => false, 'message' => __("The reCAPTCHA wasn't entered correctly.", 'pe-services')));
					die();
				}

			} else {
				if( wp_mail($targetEmail, $email_subject, $email_body, $header) ) {
					echo json_encode(array('success' => true, 'message' => __("Message sent successfully!", 'pe-services')));
				} else {
					echo json_encode(array('success' => false, 'message' => __("Server Error: WordPress mail function failed!", 'pe-services')));
				}
			}

		} else {
			echo json_encode(array('success' => false, 'message' => __("Invalid Request !", 'pe-services')));
		}

		die();

	}

}
?>
