<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
 Author: artur.kaczmarek@joomla-monster.com
---------------------------------------------------------------*/

if( !class_exists('PE_Box') ){

    class PE_Box extends WP_Widget {

			function __construct() {
				$widget_ops = array( 'classname' => 'pe_box_widget', 'description' => __('Displays front boxes with icons.','pe-services') );
				parent::__construct( 'PE_Box', __('PE Box','pe-services'), $widget_ops );
			}

			function widget($args, $instance) {

				extract($args);

				$title = apply_filters('widget_title', $instance['title']);
				$title = strip_tags($title);
				
				if ( empty($title) ) $title = false;
		
				$link = esc_url($instance['link']);
				
				$icon = ( $instance['icon'] === 1 ) ? true : false;
				
				$icon_src = esc_url($instance['icon_src']);
				$icon_hover_src = esc_url($instance['icon_hover_src']);
				$icon_height = ( is_numeric($instance['icon_height']) ) ? $instance['icon_height'] : 90;
				$icon_width = ( is_numeric($instance['icon_width']) ) ? $instance['icon_width'] : 90;
				
				echo $before_widget;

		?>
		
		<div class="pe-box">
			<?php if (!empty($link)):?>
				<a href="<?php echo $link; ?>">
			<?php endif; ?>
			<?php if (!empty($icon_src) && $icon):?>
				<span class="pe-icons" style="width: <?php echo $icon_width; ?>px; height: <?php echo $icon_height; ?>px;">
					<span class="pe-icon" style="background-image: url('<?php echo $icon_src; ?>');"></span>
					<?php if (!empty($icon_hover_src)):?>
						<span class="pe-icon-hover" style="background-image: url('<?php echo $icon_hover_src; ?>');"></span>
					<?php endif; ?>
				</span>
			<?php endif; ?>
			<?php if($title):?>
				<span class="pe-icon-title">
					<span data-hover="<?php echo $title ;?>"><?php echo $title ;?></span>
				</span>
			<?php endif; ?>
			<?php if (!empty($link)):?>
				</a>
			<?php endif; ?>
		</div>
		
			<?php echo $after_widget;
		
			}

		// Widget Backend
		// --------------------------------------------------------------
		
        function form($instance)
        {

            $instance = wp_parse_args( (array) $instance, array( 
                'title'             => '', 
								'link'              => '',
                'icon'             	=> 0, 
                'icon_src'          => '',
                'icon_hover_src'    => '',
								'icon_height'       => 90,
								'icon_width'        => 90,
                ) 
            );

			$title = esc_attr($instance['title']);

			$link = esc_url($instance['link']);
			
			$icon = ( $instance['icon'] === 1 ) ? true : false;
			
			$icon_src = esc_url($instance['icon_src']);
			$icon_hover_src = esc_url($instance['icon_hover_src']);
			
			$icon_height = ( is_numeric($instance['icon_height']) ) ? $instance['icon_height'] : 90;
			$icon_width = ( is_numeric($instance['icon_width']) ) ? $instance['icon_width'] : 90;
			
			// Widget admin form
			// --------------------------------------------------------------
			
            ?>

            <p>
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', 'pe-services'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
			
						<p>
                <label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link', 'pe-services'); ?></label>
                <input type="text" name="<?php echo $this->get_field_name('link'); ?>" id="<?php echo $this->get_field_id('link'); ?>" class="widefat" value="<?php echo $instance['link']; ?>" /></p>
            <p>
			
            <p>
                <input class="checkbox" id="<?php echo $this->get_field_id('icon'); ?>" name="<?php echo $this->get_field_name('icon'); ?>" type="checkbox" <?php checked( $icon, 1 ); ?>/>
                <label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e('Show Icon', 'pe-services'); ?></label>
            </p>
						
						<p>
                <label for="<?php echo $this->get_field_id('icon_height'); ?>"><?php _e('Icon height (in pixsels)', 'pe-services'); ?></label>
                <input type="text" name="<?php echo $this->get_field_name('icon_height'); ?>" id="<?php echo $this->get_field_id('icon_height'); ?>" class="widefat" value="<?php echo $instance['icon_height']; ?>" /></p>
            <p>
						<p>
                <label for="<?php echo $this->get_field_id('icon_width'); ?>"><?php _e('Icon width (in pixsels)', 'pe-services'); ?></label>
                <input type="text" name="<?php echo $this->get_field_name('icon_width'); ?>" id="<?php echo $this->get_field_id('icon_width'); ?>" class="widefat" value="<?php echo $instance['icon_width']; ?>" /></p>
            <p>

			<script type="text/javascript">
				jQuery(document).ready(function($) {
					var pe_media = function(selector, button_selector)  {
					var clicked_button = false;
		 
						jQuery(selector).each(function (i, input) {
							var button = jQuery(input).next(button_selector);
							button.click(function (event) {
								event.preventDefault();
								var selected_img;
								clicked_button = jQuery(this);

								if(wp.media.frames.frame) {
									wp.media.frames.frame.open();
									return;
								}
								// configuration of the media manager new instance
								wp.media.frames.frame = wp.media({
									title: 'Select image',
									multiple: false,
									library: {
										type: 'image'
									},
									button: {
										text: 'Use selected image'
									}
								});
					 
								// Function used for the image selection and media manager closing
								var pe_media_set_image = function() {
									var selection = wp.media.frames.frame.state().get('selection');
					 
									// no selection
									if (!selection) {
										return;
									}
					 
									// iterate through selected elements
									selection.each(function(attachment) {
										var url = attachment.attributes.url;
										clicked_button.prev(selector).val(url);
									});
								};
					 
								// closing event for media manger
								wp.media.frames.frame.on('close', pe_media_set_image);
								// image selection event
								wp.media.frames.frame.on('select', pe_media_set_image);
								// showing media manager
								wp.media.frames.frame.open();
							});
					   });
					};
					pe_media('.media-input', '.media-button');
				});
			</script>
			
			<p>
				<label for="<?php echo $this->get_field_id('icon_src'); ?>"><?php _e('Icon image', 'pe-services'); ?></label>
				<input type="text" name="<?php echo $this->get_field_name('icon_src'); ?>" id="<?php echo $this->get_field_id('icon_src'); ?>" value="<?php echo $instance['icon_src']; ?>" class="widefat media-input" /><button class="media-button button"><?php _e('Select Image', 'pe-services'); ?></button>
			</p>
			
			<p>
				<label for="<?php echo $this->get_field_id('icon_hover_src'); ?>"><?php _e('Icon hover image', 'pe-services'); ?></label>
				<input type="text" name="<?php echo $this->get_field_name('icon_hover_src'); ?>" id="<?php echo $this->get_field_id('icon_hover_src'); ?>" value="<?php echo $instance['icon_hover_src']; ?>" class="widefat media-input" /><button class="media-button button"><?php _e('Select Image', 'pe-services'); ?></button>
			</p>
			
        <?php
        }

        function update($new_instance, $old_instance)
        {
					$instance = $old_instance;

					$instance['title'] = strip_tags($new_instance['title']);
					$instance['link'] = esc_url( $new_instance['link'] );
					$instance['icon'] = isset( $new_instance['icon'] ) ? 1 : 0;
			
					$instance['icon_src'] = esc_url( $new_instance['icon_src'] );
					$instance['icon_hover_src'] = esc_url( $new_instance['icon_hover_src'] );
          $instance['icon_height'] = esc_attr($new_instance['icon_height']);
					$instance['icon_width'] = esc_attr($new_instance['icon_width']);
					
					return $instance;

        }

    }
	
	// queue up the necessary js
	function pe_box_wp_media_files() {
	  wp_enqueue_media();
	}
	add_action( 'admin_enqueue_scripts', 'pe_box_wp_media_files' );
	
}
?>