<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

if( !class_exists('PE_Contact') ){

    class PE_Contact extends WP_Widget {

        function __construct() {
            $widget_ops = array( 'classname' => 'pe_contact_widget', 'description' => __('Displays short info information.','pe-services') );
            parent::__construct( 'PE_Contact', __('PE Short Info','pe-services'), $widget_ops );
        }

        function widget($args, $instance) {

            extract($args);

            $title = apply_filters('widget_title', $instance['title']);
						
            if ( empty($title) ) $title = false;

						$link = esc_url($instance['link']);
				
						$icon = $instance['icon'];
						
						$description = esc_attr($instance['description']);
						
						$animation = esc_attr($instance['animation']);
						$animation_delay = (!empty($instance['animation_delay'])) ? esc_attr($instance['animation_delay']) : '0';

						//animation
						if($animation == 'none') {
							$animation_class = '';
							$animation_type = '';
							$animation_delay = '';
						} else {
							$animation_class = 'pe-animation';
							$animation_type = $animation;
						}
						
            echo $before_widget;
						
						$icon_class = (!empty($icon)) ? 'icon' : '';
						
            ?>
            

						<div class="pe-contact-widget <?php echo $icon_class; ?> <?php echo $animation_class; ?>" <?php if(!empty($animation_type)) { echo 'data-animation="' . $animation_type . '" data-animation-delay="' . $animation_delay . 'ms"';  } ?>>
							<?php if (!empty($link)):?>
								<a href="<?php echo $link; ?>">
							<?php endif; ?>
							
							<span class="pe-contact-container">
							
							<?php if (!empty($icon)):?>
								<span class="pe-icon">
									<?php echo $icon; ?>
								</span>
							<?php endif; ?>
							
							<?php if($title || !empty($description)):?>
							<span class="pe-text">
							
								<?php if($title):?>
									<span class="pe-contact-title">
										<?php echo $title ;?>
									</span>
								<?php endif; ?>
								<?php if(!empty($description)):?>
									<span class="pe-description">
										<?php echo $description ;?>
									</span>
								<?php endif; ?>
							
							</span>
							<?php endif; ?>
							
							</span>
							
							<?php if (!empty($link)):?>
								</a>
							<?php endif; ?>
						</div>

            <?php echo $after_widget;

        }


        function form($instance)
        {

            $instance = wp_parse_args( (array) $instance, array( 
                'title'             => '', 
                'link'              => '',
								'icon'              => '',
                'description'       => '',
								'animation'         => 'none',
								'animation_delay'   => '100',
                ) 
            );

            $title= esc_attr($instance['title']);
            $link = esc_url($instance['link']);
			$icon = esc_html($instance['icon']);
            $description = esc_attr($instance['description']);
			$animation =  $instance['animation'];
			$animation_delay =  $instance['animation_delay'];
			
            ?>

            <p>
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Widget Title', 'pe-services'); ?></label>
                <input class="widefat" type="text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo $title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('link'); ?>"><?php _e('Link <small class="description">(Example: http://pixelemu.com)</small>', 'pe-services'); ?></label>
                <input  class="widefat" type="text" name="<?php echo $this->get_field_name('link'); ?>" id="<?php echo $this->get_field_id('link'); ?>" value="<?php echo $instance['link']; ?>" /></p>
						<p>
            <p>
                <label for="<?php echo $this->get_field_id('icon'); ?>"><?php _e('Icon <small class="description">(Example: &lt;span class="fa fa-rss fa-4x"&gt;&lt;/span&gt;)</small>', 'pe-services'); ?></label>
								<textarea class="widefat" rows="8" cols="20"  name="<?php echo $this->get_field_name('icon'); ?>" id="<?php echo $this->get_field_id('icon'); ?>"><?php echo $instance['icon']; ?></textarea>
						<p>
						<p>
                <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description', 'pe-services'); ?></label>
								<textarea class="widefat" rows="8" cols="20"  name="<?php echo $this->get_field_name('description'); ?>" id="<?php echo $this->get_field_id('description'); ?>"><?php echo $instance['description']; ?></textarea>
						<p>
						
						<p>
								<label for="<?php echo $this -> get_field_id('animation'); ?>"><?php _e('Animation type', 'pe-services'); ?></label>
								<select class="widefat" id="<?php echo $this -> get_field_id('animation'); ?>" name="<?php echo $this -> get_field_name('animation'); ?>" style="width:100%;">
									<option value='none' <?php echo($animation == 'none') ? 'selected' : ''; ?>><?php _e('None', 'pe-services'); ?></option>
									
									<optgroup label="<?php _e('Attention Seekers', 'pe-services'); ?>">
										<option value="bounce" <?php echo($animation == 'bounce') ? 'selected' : ''; ?>>bounce</option>
										<option value="flash" <?php echo($animation == 'flash') ? 'selected' : ''; ?>>flash</option>
										<option value="pulse" <?php echo($animation == 'pulse') ? 'selected' : ''; ?>>pulse</option>
										<option value="rubberBand" <?php echo($animation == 'rubberBand') ? 'selected' : ''; ?>>rubberBand</option>
										<option value="shake" <?php echo($animation == 'shake') ? 'selected' : ''; ?>>shake</option>
										<option value="swing" <?php echo($animation == 'swing') ? 'selected' : ''; ?>>swing</option>
										<option value="tada" <?php echo($animation == 'tada') ? 'selected' : ''; ?>>tada</option>
										<option value="wobble" <?php echo($animation == 'wobble') ? 'selected' : ''; ?>>wobble</option>
										<option value="jello" <?php echo($animation == 'jello') ? 'selected' : ''; ?>>jello</option>
									</optgroup>

									<optgroup label="<?php _e('Bouncing Entrances', 'pe-services'); ?>">
										<option value="bounceIn" <?php echo($animation == 'bounceIn') ? 'selected' : ''; ?>>bounceIn</option>
										<option value="bounceInDown" <?php echo($animation == 'bounceInDown') ? 'selected' : ''; ?>>bounceInDown</option>
										<option value="bounceInLeft" <?php echo($animation == 'bounceInLeft') ? 'selected' : ''; ?>>bounceInLeft</option>
										<option value="bounceInRight" <?php echo($animation == 'bounceInRight') ? 'selected' : ''; ?>>bounceInRight</option>
										<option value="bounceInUp" <?php echo($animation == 'bounceInUp') ? 'selected' : ''; ?>>bounceInUp</option>
									</optgroup>

									<optgroup label="<?php _e('Bouncing Exits', 'pe-services'); ?>">
										<option value="bounceOut" <?php echo($animation == 'bounceOut') ? 'selected' : ''; ?>>bounceOut</option>
										<option value="bounceOutDown" <?php echo($animation == 'bounceOutDown') ? 'selected' : ''; ?>>bounceOutDown</option>
										<option value="bounceOutLeft" <?php echo($animation == 'bounceOutLeft') ? 'selected' : ''; ?>>bounceOutLeft</option>
										<option value="bounceOutRight" <?php echo($animation == 'bounceOutRight') ? 'selected' : ''; ?>>bounceOutRight</option>
										<option value="bounceOutUp" <?php echo($animation == 'bounceOutUp') ? 'selected' : ''; ?>>bounceOutUp</option>
									</optgroup>

									<optgroup label="<?php _e('Fading Entrances', 'pe-services'); ?>">
										<option value="fadeIn" <?php echo($animation == 'fadeIn') ? 'selected' : ''; ?>>fadeIn</option>
										<option value="fadeInDown" <?php echo($animation == 'fadeInDown') ? 'selected' : ''; ?>>fadeInDown</option>
										<option value="fadeInDownBig" <?php echo($animation == 'fadeInDownBig') ? 'selected' : ''; ?>>fadeInDownBig</option>
										<option value="fadeInLeft" <?php echo($animation == 'fadeInLeft') ? 'selected' : ''; ?>>fadeInLeft</option>
										<option value="fadeInLeftBig" <?php echo($animation == 'fadeInLeftBig') ? 'selected' : ''; ?>>fadeInLeftBig</option>
										<option value="fadeInRight" <?php echo($animation == 'fadeInRight') ? 'selected' : ''; ?>>fadeInRight</option>
										<option value="fadeInRightBig" <?php echo($animation == 'fadeInRightBig') ? 'selected' : ''; ?>>fadeInRightBig</option>
										<option value="fadeInUp" <?php echo($animation == 'fadeInUp') ? 'selected' : ''; ?>>fadeInUp</option>
										<option value="fadeInUpBig" <?php echo($animation == 'fadeInUpBig') ? 'selected' : ''; ?>>fadeInUpBig</option>
									</optgroup>

									<optgroup label="<?php _e('Fading Exits', 'pe-services'); ?>">
										<option value="fadeOut" <?php echo($animation == 'fadeOut') ? 'selected' : ''; ?>>fadeOut</option>
										<option value="fadeOutDown" <?php echo($animation == 'fadeOutDown') ? 'selected' : ''; ?>>fadeOutDown</option>
										<option value="fadeOutDownBig" <?php echo($animation == 'fadeOutDownBig') ? 'selected' : ''; ?>>fadeOutDownBig</option>
										<option value="fadeOutLeft" <?php echo($animation == 'fadeOutLeft') ? 'selected' : ''; ?>>fadeOutLeft</option>
										<option value="fadeOutLeftBig" <?php echo($animation == 'fadeOutLeftBig') ? 'selected' : ''; ?>>fadeOutLeftBig</option>
										<option value="fadeOutRight" <?php echo($animation == 'fadeOutRight') ? 'selected' : ''; ?>>fadeOutRight</option>
										<option value="fadeOutRightBig" <?php echo($animation == 'fadeOutRightBig') ? 'selected' : ''; ?>>fadeOutRightBig</option>
										<option value="fadeOutUp" <?php echo($animation == 'fadeOutUp') ? 'selected' : ''; ?>>fadeOutUp</option>
										<option value="fadeOutUpBig" <?php echo($animation == 'fadeOutUpBig') ? 'selected' : ''; ?>>fadeOutUpBig</option>
									</optgroup>

									<optgroup label="<?php _e('Flippers', 'pe-services'); ?>">
										<option value="flip" <?php echo($animation == 'flip') ? 'selected' : ''; ?>>flip</option>
										<option value="flipInX" <?php echo($animation == 'flipInX') ? 'selected' : ''; ?>>flipInX</option>
										<option value="flipInY" <?php echo($animation == 'flipInY') ? 'selected' : ''; ?>>flipInY</option>
										<option value="flipOutX" <?php echo($animation == 'flipOutX') ? 'selected' : ''; ?>>flipOutX</option>
										<option value="flipOutY" <?php echo($animation == 'flipOutY') ? 'selected' : ''; ?>>flipOutY</option>
									</optgroup>

									<optgroup label="<?php _e('Lightspeed', 'pe-services'); ?>">
										<option value="lightSpeedIn" <?php echo($animation == 'lightSpeedIn') ? 'selected' : ''; ?>>lightSpeedIn</option>
										<option value="lightSpeedOut" <?php echo($animation == 'lightSpeedOut') ? 'selected' : ''; ?>>lightSpeedOut</option>
									</optgroup>

									<optgroup label="<?php _e('Rotating Entrances', 'pe-services'); ?>">
										<option value="rotateIn" <?php echo($animation == 'rotateIn') ? 'selected' : ''; ?>>rotateIn</option>
										<option value="rotateInDownLeft" <?php echo($animation == 'rotateInDownLeft') ? 'selected' : ''; ?>>rotateInDownLeft</option>
										<option value="rotateInDownRight" <?php echo($animation == 'rotateInDownRight') ? 'selected' : ''; ?>>rotateInDownRight</option>
										<option value="rotateInUpLeft" <?php echo($animation == 'rotateInUpLeft') ? 'selected' : ''; ?>>rotateInUpLeft</option>
										<option value="rotateInUpRight" <?php echo($animation == 'rotateInUpRight') ? 'selected' : ''; ?>>rotateInUpRight</option>
									</optgroup>

									<optgroup label="<?php _e('Rotating Exits', 'pe-services'); ?>">
										<option value="rotateOut" <?php echo($animation == 'rotateOut') ? 'selected' : ''; ?>>rotateOut</option>
										<option value="rotateOutDownLeft" <?php echo($animation == 'rotateOutDownLeft') ? 'selected' : ''; ?>>rotateOutDownLeft</option>
										<option value="rotateOutDownRight" <?php echo($animation == 'rotateOutDownRight') ? 'selected' : ''; ?>>rotateOutDownRight</option>
										<option value="rotateOutUpLeft" <?php echo($animation == 'rotateOutUpLeft') ? 'selected' : ''; ?>>rotateOutUpLeft</option>
										<option value="rotateOutUpRight" <?php echo($animation == 'rotateOutUpRight') ? 'selected' : ''; ?>>rotateOutUpRight</option>
									</optgroup>

									<optgroup label="<?php _e('Sliding Entrances', 'pe-services'); ?>">
										<option value="slideInUp" <?php echo($animation == 'slideInUp') ? 'selected' : ''; ?>>slideInUp</option>
										<option value="slideInDown" <?php echo($animation == 'slideInDown') ? 'selected' : ''; ?>>slideInDown</option>
										<option value="slideInLeft" <?php echo($animation == 'slideInLeft') ? 'selected' : ''; ?>>slideInLeft</option>
										<option value="slideInRight" <?php echo($animation == 'slideInRight') ? 'selected' : ''; ?>>slideInRight</option>

									</optgroup>
									<optgroup label="<?php _e('Sliding Exits', 'pe-services'); ?>">
										<option value="slideOutUp" <?php echo($animation == 'slideOutUp') ? 'selected' : ''; ?>>slideOutUp</option>
										<option value="slideOutDown" <?php echo($animation == 'slideOutDown') ? 'selected' : ''; ?>>slideOutDown</option>
										<option value="slideOutLeft" <?php echo($animation == 'slideOutLeft') ? 'selected' : ''; ?>>slideOutLeft</option>
										<option value="slideOutRight" <?php echo($animation == 'slideOutRight') ? 'selected' : ''; ?>>slideOutRight</option>
										
									</optgroup>
									
									<optgroup label="<?php _e('Zoom Entrances', 'pe-services'); ?>">
										<option value="zoomIn" <?php echo($animation == 'zoomIn') ? 'selected' : ''; ?>>zoomIn</option>
										<option value="zoomInDown" <?php echo($animation == 'zoomInDown') ? 'selected' : ''; ?>>zoomInDown</option>
										<option value="zoomInLeft" <?php echo($animation == 'zoomInLeft') ? 'selected' : ''; ?>>zoomInLeft</option>
										<option value="zoomInRight" <?php echo($animation == 'zoomInRight') ? 'selected' : ''; ?>>zoomInRight</option>
										<option value="zoomInUp" <?php echo($animation == 'zoomInUp') ? 'selected' : ''; ?>>zoomInUp</option>
									</optgroup>
									
									<optgroup label="<?php _e('Zoom Exits', 'pe-services'); ?>">
										<option value="zoomOut" <?php echo($animation == 'zoomOut') ? 'selected' : ''; ?>>zoomOut</option>
										<option value="zoomOutDown" <?php echo($animation == 'zoomOutDown') ? 'selected' : ''; ?>>zoomOutDown</option>
										<option value="zoomOutLeft" <?php echo($animation == 'zoomOutLeft') ? 'selected' : ''; ?>>zoomOutLeft</option>
										<option value="zoomOutRight" <?php echo($animation == 'zoomOutRight') ? 'selected' : ''; ?>>zoomOutRight</option>
										<option value="zoomOutUp" <?php echo($animation == 'zoomOutUp') ? 'selected' : ''; ?>>zoomOutUp</option>
									</optgroup>

									<optgroup label="<?php _e('Specials', 'pe-services'); ?>">
										<option value="hinge" <?php echo($animation == 'hinge') ? 'selected' : ''; ?>>hinge</option>
										<option value="rollIn" <?php echo($animation == 'rollIn') ? 'selected' : ''; ?>>rollIn</option>
										<option value="rollOut" <?php echo($animation == 'rollOut') ? 'selected' : ''; ?>>rollOut</option>
									</optgroup>

								</select>
							</p>
							
							<p>
								<label for="<?php echo $this -> get_field_id('animation_delay'); ?>"><?php _e('Animation Delay', 'pe-services'); ?> <small><?php _e('(miliseconds)', 'pe-services'); ?></small></label>
								<input id="<?php echo $this -> get_field_id('animation_delay'); ?>" name="<?php echo $this -> get_field_name('animation_delay'); ?>" type="text" value="<?php echo $animation_delay; ?>" size="3" />
							</p>
						
        <?php
        }

        function update($new_instance, $old_instance)
        {
            $instance = $old_instance;

            $instance['title'] = strip_tags($new_instance['title']);
			$instance['link'] = esc_url( $new_instance['link'] );
            $instance['icon'] = $new_instance['icon'];
            $instance['description'] = esc_attr($new_instance['description']);
            $instance['animation'] = esc_attr($new_instance['animation']);
			$instance['animation_delay'] = esc_attr($new_instance['animation_delay']);
			
            return $instance;

        }

    }
}
?>