<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: https://www.pixelemu.com/company/license PixelEmu Proprietary Use License
 Website: https://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

if( !class_exists('PE_Team_Carousel') ){

class PE_Team_Carousel extends WP_Widget {

		function __construct() {
			$widget_ops = array( 'classname' => 'pe_team_carousel', 'description' => __('Display Team Members carousel.','pe-services') );
			parent::__construct( 'PE_Team_Carousel', __('PE Team Carousel','pe-services'), $widget_ops );
		}

		function widget($args, $instance) {

			extract($args);

			$title = apply_filters('widget_title', $instance['title']);

			if ( empty($title) ) $title = false;

			$select_view = esc_attr($instance['select_view']);
			$avatar_size = esc_attr($instance['avatar_size']);

			$total_to_show = esc_attr($instance['total_to_show']);

			$members_per_row = esc_attr($instance['members_per_row']);

			$desc_limit =  esc_attr($instance['desc_limit']);
			$member_name = ( $instance['member_name'] === 1 ) ? true : false;
			$linked_name = ( $instance['linked_name'] === 1 ) ? true : false;
			$member_profession = ( $instance['member_profession'] === 1 ) ? true : false;
			$member_avatar = ( $instance['member_avatar'] === 1 ) ? true : false;
			$member_desc = ( $instance['member_desc'] === 1 ) ? true : false;
			$social_icon = ( $instance['social_icon'] === 1 ) ? true : false;
			$order =  esc_attr($instance['order']);

			$animation = esc_attr($instance['animation']);
			$animation_delay = (!empty($instance['animation_delay'])) ? esc_attr($instance['animation_delay']) : '0';
			$animation_interval = (!empty($instance['animation_interval'])) ? esc_attr($instance['animation_interval']) : '0';

			if ($members_per_row > 12 || $members_per_row < 1 ){
				$members_per_row = 12;
			}

			$col_number = floor(12 / $members_per_row);

			$post_count = wp_count_posts('member');
			$number_of_posts = $post_count->publish;

			$desc_float = 'pull-left';
			if ( $member_desc ) {
				$desc_float = '';
			}

			//sort
			if($order == 'alpha') {
				$orderby = 'name';
				$ordering = 'asc';
			} else {
				$orderby = 'id';
				$ordering = $order;
			}

			$services = ( !empty($instance['service_ids']) && is_array($instance['service_ids']) ) ? $instance['service_ids'] : false;

			if( $services ) {
				$meta_query = array('relation' => 'OR');

				foreach ($services as $service => $id) {
						$meta_query[] = array(
								'key' => 'member_profession',
								'value' => $id,
								'compare' => 'LIKE'
						);
				}
			} else {
				$meta_query = array();
			}

			$post_per_page = ( $select_view == 1 ) ? -1 : $total_to_show;

			$member_args = array(
				'post_type'      => 'member',
				'orderby'        => $orderby,
				'order'          => $ordering,
				'posts_per_page' => $post_per_page,
				'meta_query'     => $meta_query
			);

			//animation
			if($animation == 'none') {
				$animation_class = '';
				$animation_type = '';
				$animation_delay = '';
				$animation_interval = '';
			} else {
				$animation_class = 'pe-animation';
				$animation_type = $animation;
			}

			$member_query = new WP_Query($member_args);

			echo $before_widget;

			if($title):
				echo $before_title;
				echo $title;
				echo $after_title;
			endif;

			if($member_query->have_posts()): ?>

			<?php
			// VIEW 1 SLIDER
			// -----------------------------------------------------------------------------

			if ($select_view==1) : ?>
			<?php $show_indicators = ( $number_of_posts > $total_to_show ) ? 'show-indicators' : ''; ?>

			<!-- Team slider -->
			<div id="pe-team-carousel-<?php echo uniqid(); ?>" class="pe-carousel pe-team-carousel <?php echo $show_indicators; ?>">

			<?php if ( $number_of_posts > $total_to_show ) {

			$i = 0;
			$s = 0;

			?>
				<!-- Indicators -->
				<ol class="pe-indicators" role="tablist" aria-label="<?php _e('Indicators', 'pe-services'); ?>">
				<?php
					while ($member_query -> have_posts()) : $member_query -> the_post();

					$active_class = ($i === 0) ? 'active' : '';

					if($i % ($total_to_show) == 0) {

						echo '<li data-slick-goto="' . $s . '" class="pe-indicator ' . $active_class . '" role="tab" aria-label="' . __('Team ', 'pe-services') . $s . '" tabindex="0"></li>';
						$s++;

					}

					$i++;

					endwhile;
				?>
				</ol>
				<?php } ?>

				<!-- Wrapper for slides -->
				<div class="pe-content">

					<!-- row   -->
					<div class="row">

					<?php

						$counter = 0;

						while($member_query->have_posts()): $member_query->the_post();

						$active_class = ($counter === 0) ? 'active' : '';

						$id = uniqid();

					?>

					<?php if($counter !=0 && $counter % ($total_to_show) == 0) { ?>
					</div>
					<!-- end row -->
					<!-- row   -->
					<div class="row">
					<?php } ?>

					<div class="item <?php echo $active_class; ?> <?php echo $animation_class; ?>" <?php if(!empty($animation_type)) { echo 'data-animation="' . $animation_type . '" data-animation-delay="' . $animation_delay . 'ms"';  } ?>>
						<div class="pe-avatar-box">

					<div class="col-md-<?php echo $col_number; ?>">
						<div class="pe-avatar-item clearfix">
							<?php if($member_avatar && has_post_thumbnail()) { ?>

							<div class="image">
								<?php if( $linked_name ) { ?>
									<a href="<?php the_permalink(); ?>">
								<?php } ?>
								<?php
									if ( $avatar_size ) {
										the_post_thumbnail( $avatar_size );
									} else {
										the_post_thumbnail();
									}
								?>
								<?php if( $linked_name ) { ?>
									</a>
								<?php } ?>
							</div>
							<?php } ?>
							<div class="description <?php echo $desc_float ?>">
								<?php if ( $member_name ) : ?>
								<span class="title">
									<?php if( $linked_name ) { ?>
									<a href="<?php the_permalink(); ?>">
									<?php } ?>
										<?php the_title(); ?>
									<?php if( $linked_name ) { ?>
									</a>
									<?php } ?>
								</span>
								<?php endif; ?>
								<?php
								//get professions
								$member_professions = get_post_meta(get_the_ID(), 'member_profession',true);
								$member_custom_profession = get_post_meta(get_the_ID(), 'member_custom_profession',true);

								$member_professions_check = (is_array($member_professions)) ? true : false;
								$member_custom_profession_check = (!empty($member_custom_profession)) ? true : false;

								if ( $member_profession && ($member_professions_check || $member_custom_profession_check) ) : ?>
								<span class="subtitle">
								<?php
								//display
								if($member_professions_check) {
									$profession_array = array();
									foreach($member_professions as $value) {
										$proffesion_title = get_the_title( $value );
										if( !empty($proffesion_title) ) {
											$profession_array[] = $proffesion_title;
										}
									}
									$profession_output = implode (', ', $profession_array);
									echo $profession_output;
								}
								if($member_custom_profession_check) {
									if( $member_professions_check ) {
										echo ', ';
									}
									echo $member_custom_profession;
								}
								?>
								</span>
								<?php endif; ?>
								<?php if ( $member_desc ) : ?>
								<span class="text"><?php pe_excerpt($desc_limit); ?></span>
								<?php endif ?>
								<?php
								$member_fb = get_post_meta(get_the_ID(), 'member_fb',true);
								$member_tw = get_post_meta(get_the_ID(), 'member_tw',true);
								$member_li = get_post_meta(get_the_ID(), 'member_li',true);
								if ( $social_icon && (!empty($member_fb) || ($member_tw) || ($member_li) ) ) { ?>
								<span class="social">
									<?php if (!empty( $member_fb )) { ?>
									<a class="pe-facebook" href="<?php echo $member_fb ?>"><span class="fa fa-facebook"></span><span class="sr-only"><?php _e('Facebook', 'pe-services'); ?></span></a>
									<?php } ?>
									<?php if (!empty( $member_tw )) { ?>
									<a class="pe-twitter" href="<?php echo $member_tw ?>"><span class="fa fa-twitter"></span><span class="sr-only"><?php _e('Twitter', 'pe-services'); ?></span></a>
									<?php } ?>
									<?php if (!empty( $member_li )) { ?>
									<a class="pe-linkedin" href="<?php echo $member_li ?>"><span class="fa fa-linkedin"></span><span class="sr-only"><?php _e('Linkedin', 'pe-services'); ?></span></a>
									<?php } ?>
								</span>
								<?php } ?>
							</div>
						</div>
					</div>

					</div>
					</div>

					<?php
					$counter++;
					?>

					<?php
						//animation delay
						if(!empty($animation_type) && $counter > 0) {
							$animation_delay = ($animation_delay + $animation_interval);
						}
					?>

					<?php endwhile; ?>

					</div>
					<!-- end row -->


				</div>
			</div>
			<?php endif; ?>

					<?php
					// VIEW 2 GALLERY
					// -----------------------------------------------------------------------------

					if ($select_view==2) : ?>
					<div class="pe-meet-our-team">
					<?php
						$counter = 0;
						while($member_query->have_posts()): $member_query->the_post();
						$counter++;
					?>
					<?php if ($members_per_row == 1) {
						if ($counter % $members_per_row == 0){ ?>
							<div class="row">
						<?php } ?>
					<?php } else {
						 if (($counter % $members_per_row == 1)) { ?>
							<div class="row">
						<?php }
					} ?>
						<div class="col-md-<?php echo $col_number; ?>">
							<div class="pe-meet-box <?php echo $animation_class;?>" <?php if(!empty($animation_type)) { echo 'data-animation="' . $animation_type . '" data-animation-delay="' . $animation_delay . 'ms"';  } ?>>
								<?php if($member_avatar && has_post_thumbnail()) { ?>
									<span class="image">
									<?php
										if ( $avatar_size ) {
											the_post_thumbnail( $avatar_size );
										} else {
											the_post_thumbnail();
										}
									?>
									<?php
										$member_fb = get_post_meta(get_the_ID(), 'member_fb',true);
										$member_tw = get_post_meta(get_the_ID(), 'member_tw',true);
										$member_li = get_post_meta(get_the_ID(), 'member_li',true);
										if ( $social_icon && (!empty($member_fb) || ($member_tw) || ($member_li) ) ) {
									?>
											<span class="social">
											<?php if (!empty( $member_fb )) {?>
												<a class="pe-facebook" href="<?php echo $member_fb ?>"><span class="fa fa-facebook"></span><span class="sr-only"><?php _e('Facebook', 'pe-services'); ?></span></a>
											<?php } ?>
											<?php if (!empty( $member_tw )) {?>
												<a class="pe-twitter" href="<?php echo $member_tw ?>"><span class="fa fa-twitter"></span><span class="sr-only"><?php _e('Twitter', 'pe-services'); ?></span></a>
											<?php } ?>
											<?php if (!empty( $member_li )) {?>
												<a class="pe-linkedin" href="<?php echo $member_li ?>"><span class="fa fa-linkedin"></span><span class="sr-only"><?php _e('Linkedin', 'pe-services'); ?></span></a>
											<?php } ?>
											</span>
									<?php } ?>
									</span>
								<?php } ?>
								<?php if( $linked_name ) { ?>
									<a class="member-link" href="<?php the_permalink(); ?>">
								<?php } ?>
									<span class="description">
									<?php if ( $member_name ) : ?>
										<span class="title"><?php the_title(); ?></span>
									<?php endif; ?>
									<?php
									//get professions
									$member_professions = get_post_meta(get_the_ID(), 'member_profession', true);
									$member_custom_profession = get_post_meta(get_the_ID(), 'member_custom_profession', true);

									$member_professions_check = (is_array($member_professions)) ? true : false;
									$member_custom_profession_check = (!empty($member_custom_profession)) ? true : false;

									if ( $member_profession && ($member_professions_check || $member_custom_profession_check) ) : ?>
										<span class="subtitle">
										<?php
										//display
										if($member_professions_check) {
											$profession_array = array();
											foreach($member_professions as $value) {
												$proffesion_title = get_the_title( $value );
												if( !empty($proffesion_title) ) {
													$profession_array[] = $proffesion_title;
												}
											}
											$profession_output = implode (', ', $profession_array);
											echo $profession_output;
										}
										if($member_custom_profession_check) {
											if( $member_professions_check ) {
												echo ', ';
											}
											echo $member_custom_profession;
										}
										?>
										</span>
									<?php endif; ?>
									<?php if ( $member_desc ) : ?>
										<span class="text"><?php pe_excerpt($desc_limit); ?></span>
									<?php endif ?>
									</span>
								<?php if( $linked_name ) { ?>
									</a>
								<?php } ?>
							</div>
						</div>

					<?php if ( $counter % $members_per_row == 0 ) { ?>
						</div>
					<?php } ?>

					<?php
						//animation delay
						if(!empty($animation_type) && $counter > 0) {
							$animation_delay = ($animation_delay + $animation_interval);
						}
					?>

					<?php endwhile; ?>

					<?php if ((($counter % $members_per_row) != 0) && ($counter >= $members_per_row)) { ?>
						</div>
					<?php } ?>
						</div>

					<?php endif; ?>

					<?php wp_reset_query(); else: ?>
					<ul class="members-not-found">
					<?php
						echo '<li>';
							_e('No Members Found!', 'pe-services');
						echo '</li>';
					?>
					</ul>
			<?php endif;


			echo $after_widget;
		}

		function form($instance) {

			$instance = wp_parse_args( (array) $instance, array(
				'title'               => '',
				'select_view'         => 1,
				'service_ids'         => 0,
				'avatar_size'         => 'thumbnail',
				'total_to_show'       => 8,
				'members_per_row'     => 2,
				'desc_limit'          => 10,
				'member_name'         => 1,
				'linked_name'         => 1,
				'member_profession'   => 1,
				'member_avatar'       => 1,
				'member_desc'         => 1,
				'social_icon'         => 1,
				'order'               => 'desc',
				'animation'           => 'none',
				'animation_delay'     => '100',
				'animation_interval'  => '50',
				)
			);

			$title= esc_attr($instance['title']);
			$select_view = esc_attr($instance['select_view']);
			$avatar_size = esc_attr($instance['avatar_size']);
			$total_to_show = esc_attr($instance['total_to_show']);
			$members_per_row =  esc_attr($instance['members_per_row']);
			$desc_limit =  esc_attr($instance['desc_limit']);
			$member_name = ( $instance['member_name'] === 1 ) ? true : false;
			$linked_name = ( $instance['linked_name'] === 1 ) ? true : false;
			$member_profession = ( $instance['member_profession'] === 1 ) ? true : false;
			$member_avatar = ( $instance['member_avatar'] === 1 ) ? true : false;
			$member_desc = ( $instance['member_desc'] === 1 ) ? true : false;
			$social_icon = ( $instance['social_icon'] === 1 ) ? true : false;
			$order =  esc_attr($instance['order']);
			$animation =  esc_attr($instance['animation']);
			$animation_delay =  esc_attr($instance['animation_delay']);
			$animation_interval =  esc_attr($instance['animation_interval']);
		?>

			<p>
				<label for="<?php echo $this -> get_field_id('title'); ?>"><?php _e('Widget Title', 'pe-services'); ?></label>
				<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
			</p>
			<p>
				<label for="<?php echo $this -> get_field_id('select_view'); ?>"><?php _e('Select View', 'pe-services'); ?></label>
				<select class="widefat" id="<?php echo $this -> get_field_id('select_view'); ?>" name="<?php echo $this -> get_field_name('select_view'); ?>" style="width:100%;">
					<option value='1'<?php echo($select_view == '1') ? 'selected' : ''; ?>><?php _e('Carousel View', 'pe-services'); ?></option>
					<option value='2'<?php echo($select_view == '2') ? 'selected' : ''; ?>><?php _e('Grid View', 'pe-services'); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo $this -> get_field_id('order'); ?>"><?php _e('Order', 'pe-services'); ?></label>
				<select class="widefat" id="<?php echo $this -> get_field_id('order'); ?>" name="<?php echo $this -> get_field_name('order'); ?>" style="width:100%;">
					<option value='desc'<?php echo($order == 'desc') ? 'selected' : ''; ?>><?php _e('Latest first', 'pe-services'); ?></option>
					<option value='asc'<?php echo($order == 'asc') ? 'selected' : ''; ?>><?php _e('Oldest first', 'pe-services'); ?></option>
					<option value='alpha'<?php echo($order == 'alpha') ? 'selected' : ''; ?>><?php _e('Alphabetical', 'pe-services'); ?></option>
				</select>
			</p>
<?php
					$services_args = array(
									'posts_per_page' => -1,
									'orderby' => 'date',
									'post_type' => 'service',
									'post_status' => 'publish',
								);

					$all_services = get_posts($services_args);

					if( !empty($all_services) ) :
				?>
				<p class="services">
					<label for="<?php echo $this->get_field_id('service_ids'); ?>[]"><?php _e('Services', 'pe-services'); ?> <small><?php _e('(leave empty for all)', 'pe-services'); ?></small></label>
					<?php

						echo '<div style="max-height:150px; overflow:auto; border:1px solid #dfdfdf; padding:5px; margin-bottom:5px;">';
						echo '<ul class="ids">';
						foreach ( $all_services as $post ) {
							if( !empty($instance['service_ids']) ) {
								$checked = in_array($post->ID, $instance['service_ids']) ? ' checked="checked"' : '';
							} else {
								$checked = '';
							}
							$option = '<li><input type="checkbox" name="' . $this->get_field_name('service_ids') . '[]" id="post-' . $post->ID . '" value="' . $post->ID . '" ' . $checked . '>';
							$option .= '<span>' . $post->post_title . '</span></li>';
							echo $option;
						}
						echo '</ul>';
						echo '</div>';

					?>
				</p>
				<?php
					endif;
				?>
			<p>
				<label for="<?php echo $this -> get_field_id('avatar_size'); ?>"><?php _e('Select image size', 'pe-services'); ?></label>
				<select class="widefat" id="<?php echo $this -> get_field_id('avatar_size'); ?>" name="<?php echo $this -> get_field_name('avatar_size'); ?>" style="width:100%;">
					<option value='thumbnail'<?php echo($avatar_size == 'thumbnail') ? 'selected' : ''; ?>><?php _e('Thumbnail', 'pe-services'); ?></option>
					<option value='medium'<?php echo($avatar_size == 'medium') ? 'selected' : ''; ?>><?php _e('Medium', 'pe-services'); ?></option>
					<option value='large'<?php echo($avatar_size == 'large') ? 'selected' : ''; ?>><?php _e('Large', 'pe-services'); ?></option>
				</select>
			</p>
			<p>
				<label for="<?php echo $this -> get_field_id('total_to_show'); ?>"><?php _e('Number of Members to show', 'pe-services'); ?></label>
				<input id="<?php echo $this -> get_field_id('total_to_show'); ?>" name="<?php echo $this -> get_field_name('total_to_show'); ?>" type="text" value="<?php echo $total_to_show; ?>" size="3" />
			</p>
			<p>
				<label for="<?php echo $this -> get_field_id('members_per_row'); ?>"><?php _e('Number of Members in row', 'pe-services'); ?></label>
				<select class="widefat" name="<?php echo $this -> get_field_name('members_per_row'); ?>" id="<?php echo $this -> get_field_id('members_per_row'); ?>" style="width:100%;">
					<option value="1"<?php echo($members_per_row == '1') ? 'selected' : ''; ?>>1</option>
					<option value="2"<?php echo($members_per_row == '2') ? 'selected' : ''; ?>>2</option>
					<option value="3"<?php echo($members_per_row == '3') ? 'selected' : ''; ?>>3</option>
					<option value="4"<?php echo($members_per_row == '4') ? 'selected' : ''; ?>>4</option>
					<option value="5"<?php echo($members_per_row == '5') ? 'selected' : ''; ?>>5</option>
					<option value="6"<?php echo($members_per_row == '6') ? 'selected' : ''; ?>>6</option>
					<option value="7"<?php echo($members_per_row == '7') ? 'selected' : ''; ?>>7</option>
					<option value="8"<?php echo($members_per_row == '8') ? 'selected' : ''; ?>>8</option>
					<option value="9"<?php echo($members_per_row == '9') ? 'selected' : ''; ?>>9</option>
					<option value="10"<?php echo($members_per_row == '10') ? 'selected' : ''; ?>>10</option>
					<option value="11"<?php echo($members_per_row == '11') ? 'selected' : ''; ?>>11</option>
					<option value="12"<?php echo($members_per_row == '12') ? 'selected' : ''; ?>>12</option>
				</select>
			</p>

			<p>
				<label for="<?php echo $this -> get_field_id('desc_limit'); ?>"><?php _e('Member description limit', 'pe-services'); ?></label>
				<input id="<?php echo $this -> get_field_id('desc_limit'); ?>" name="<?php echo $this -> get_field_name('desc_limit'); ?>" type="text" value="<?php echo $desc_limit; ?>" size="3" />
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('social_icon'); ?>" name="<?php echo $this -> get_field_name('social_icon'); ?>" type="checkbox" <?php checked($social_icon, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('social_icon'); ?>"><?php _e('Show Social Icons.', 'pe-services'); ?></label>
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('member_name'); ?>" name="<?php echo $this -> get_field_name('member_name'); ?>" type="checkbox" <?php checked($member_name, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('member_name'); ?>"><?php _e('Show Member Name.', 'pe-services'); ?></label>
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('linked_name'); ?>" name="<?php echo $this -> get_field_name('linked_name'); ?>" type="checkbox" <?php checked($linked_name, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('linked_name'); ?>"><?php _e('Linked to member page.', 'pe-services'); ?></label>
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('member_profession'); ?>" name="<?php echo $this -> get_field_name('member_profession'); ?>" type="checkbox" <?php checked($member_profession, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('member_profession'); ?>"><?php _e('Show Member Profession.', 'pe-services'); ?></label>
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('member_avatar'); ?>" name="<?php echo $this -> get_field_name('member_avatar'); ?>" type="checkbox" <?php checked($member_avatar, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('member_avatar'); ?>"><?php _e('Show Member Avatar.', 'pe-services'); ?></label>
			</p>
			<p>
				<input class="checkbox" id="<?php echo $this -> get_field_id('member_desc'); ?>" name="<?php echo $this -> get_field_name('member_desc'); ?>" type="checkbox" <?php checked($member_desc, 1); ?>/>
				<label for="<?php echo $this -> get_field_id('member_desc'); ?>"><?php _e('Show Member Description.', 'pe-services'); ?></label>
			</p>

			<p>
				<label for="<?php echo $this -> get_field_id('animation'); ?>"><?php _e('Animation type', 'pe-services'); ?></label>
				<select class="widefat" id="<?php echo $this -> get_field_id('animation'); ?>" name="<?php echo $this -> get_field_name('animation'); ?>" style="width:100%;">
					<option value='none' <?php echo($animation == 'none') ? 'selected' : ''; ?>><?php _e('None', 'pe-services'); ?></option>

					<optgroup label="<?php _e('Attention Seekers', 'pe-services'); ?>">
						<option value="bounce" <?php echo($animation == 'bounce') ? 'selected' : ''; ?>>bounce</option>
						<option value="flash" <?php echo($animation == 'flash') ? 'selected' : ''; ?>>flash</option>
						<option value="pulse" <?php echo($animation == 'pulse') ? 'selected' : ''; ?>>pulse</option>
						<option value="rubberBand" <?php echo($animation == 'rubberBand') ? 'selected' : ''; ?>>rubberBand</option>
						<option value="shake" <?php echo($animation == 'shake') ? 'selected' : ''; ?>>shake</option>
						<option value="swing" <?php echo($animation == 'swing') ? 'selected' : ''; ?>>swing</option>
						<option value="tada" <?php echo($animation == 'tada') ? 'selected' : ''; ?>>tada</option>
						<option value="wobble" <?php echo($animation == 'wobble') ? 'selected' : ''; ?>>wobble</option>
						<option value="jello" <?php echo($animation == 'jello') ? 'selected' : ''; ?>>jello</option>
					</optgroup>

					<optgroup label="<?php _e('Bouncing Entrances', 'pe-services'); ?>">
						<option value="bounceIn" <?php echo($animation == 'bounceIn') ? 'selected' : ''; ?>>bounceIn</option>
						<option value="bounceInDown" <?php echo($animation == 'bounceInDown') ? 'selected' : ''; ?>>bounceInDown</option>
						<option value="bounceInLeft" <?php echo($animation == 'bounceInLeft') ? 'selected' : ''; ?>>bounceInLeft</option>
						<option value="bounceInRight" <?php echo($animation == 'bounceInRight') ? 'selected' : ''; ?>>bounceInRight</option>
						<option value="bounceInUp" <?php echo($animation == 'bounceInUp') ? 'selected' : ''; ?>>bounceInUp</option>
					</optgroup>

					<optgroup label="<?php _e('Bouncing Exits', 'pe-services'); ?>">
						<option value="bounceOut" <?php echo($animation == 'bounceOut') ? 'selected' : ''; ?>>bounceOut</option>
						<option value="bounceOutDown" <?php echo($animation == 'bounceOutDown') ? 'selected' : ''; ?>>bounceOutDown</option>
						<option value="bounceOutLeft" <?php echo($animation == 'bounceOutLeft') ? 'selected' : ''; ?>>bounceOutLeft</option>
						<option value="bounceOutRight" <?php echo($animation == 'bounceOutRight') ? 'selected' : ''; ?>>bounceOutRight</option>
						<option value="bounceOutUp" <?php echo($animation == 'bounceOutUp') ? 'selected' : ''; ?>>bounceOutUp</option>
					</optgroup>

					<optgroup label="<?php _e('Fading Entrances', 'pe-services'); ?>">
						<option value="fadeIn" <?php echo($animation == 'fadeIn') ? 'selected' : ''; ?>>fadeIn</option>
						<option value="fadeInDown" <?php echo($animation == 'fadeInDown') ? 'selected' : ''; ?>>fadeInDown</option>
						<option value="fadeInDownBig" <?php echo($animation == 'fadeInDownBig') ? 'selected' : ''; ?>>fadeInDownBig</option>
						<option value="fadeInLeft" <?php echo($animation == 'fadeInLeft') ? 'selected' : ''; ?>>fadeInLeft</option>
						<option value="fadeInLeftBig" <?php echo($animation == 'fadeInLeftBig') ? 'selected' : ''; ?>>fadeInLeftBig</option>
						<option value="fadeInRight" <?php echo($animation == 'fadeInRight') ? 'selected' : ''; ?>>fadeInRight</option>
						<option value="fadeInRightBig" <?php echo($animation == 'fadeInRightBig') ? 'selected' : ''; ?>>fadeInRightBig</option>
						<option value="fadeInUp" <?php echo($animation == 'fadeInUp') ? 'selected' : ''; ?>>fadeInUp</option>
						<option value="fadeInUpBig" <?php echo($animation == 'fadeInUpBig') ? 'selected' : ''; ?>>fadeInUpBig</option>
					</optgroup>

					<optgroup label="<?php _e('Fading Exits', 'pe-services'); ?>">
						<option value="fadeOut" <?php echo($animation == 'fadeOut') ? 'selected' : ''; ?>>fadeOut</option>
						<option value="fadeOutDown" <?php echo($animation == 'fadeOutDown') ? 'selected' : ''; ?>>fadeOutDown</option>
						<option value="fadeOutDownBig" <?php echo($animation == 'fadeOutDownBig') ? 'selected' : ''; ?>>fadeOutDownBig</option>
						<option value="fadeOutLeft" <?php echo($animation == 'fadeOutLeft') ? 'selected' : ''; ?>>fadeOutLeft</option>
						<option value="fadeOutLeftBig" <?php echo($animation == 'fadeOutLeftBig') ? 'selected' : ''; ?>>fadeOutLeftBig</option>
						<option value="fadeOutRight" <?php echo($animation == 'fadeOutRight') ? 'selected' : ''; ?>>fadeOutRight</option>
						<option value="fadeOutRightBig" <?php echo($animation == 'fadeOutRightBig') ? 'selected' : ''; ?>>fadeOutRightBig</option>
						<option value="fadeOutUp" <?php echo($animation == 'fadeOutUp') ? 'selected' : ''; ?>>fadeOutUp</option>
						<option value="fadeOutUpBig" <?php echo($animation == 'fadeOutUpBig') ? 'selected' : ''; ?>>fadeOutUpBig</option>
					</optgroup>

					<optgroup label="<?php _e('Flippers', 'pe-services'); ?>">
						<option value="flip" <?php echo($animation == 'flip') ? 'selected' : ''; ?>>flip</option>
						<option value="flipInX" <?php echo($animation == 'flipInX') ? 'selected' : ''; ?>>flipInX</option>
						<option value="flipInY" <?php echo($animation == 'flipInY') ? 'selected' : ''; ?>>flipInY</option>
						<option value="flipOutX" <?php echo($animation == 'flipOutX') ? 'selected' : ''; ?>>flipOutX</option>
						<option value="flipOutY" <?php echo($animation == 'flipOutY') ? 'selected' : ''; ?>>flipOutY</option>
					</optgroup>

					<optgroup label="<?php _e('Lightspeed', 'pe-services'); ?>">
						<option value="lightSpeedIn" <?php echo($animation == 'lightSpeedIn') ? 'selected' : ''; ?>>lightSpeedIn</option>
						<option value="lightSpeedOut" <?php echo($animation == 'lightSpeedOut') ? 'selected' : ''; ?>>lightSpeedOut</option>
					</optgroup>

					<optgroup label="<?php _e('Rotating Entrances', 'pe-services'); ?>">
						<option value="rotateIn" <?php echo($animation == 'rotateIn') ? 'selected' : ''; ?>>rotateIn</option>
						<option value="rotateInDownLeft" <?php echo($animation == 'rotateInDownLeft') ? 'selected' : ''; ?>>rotateInDownLeft</option>
						<option value="rotateInDownRight" <?php echo($animation == 'rotateInDownRight') ? 'selected' : ''; ?>>rotateInDownRight</option>
						<option value="rotateInUpLeft" <?php echo($animation == 'rotateInUpLeft') ? 'selected' : ''; ?>>rotateInUpLeft</option>
						<option value="rotateInUpRight" <?php echo($animation == 'rotateInUpRight') ? 'selected' : ''; ?>>rotateInUpRight</option>
					</optgroup>

					<optgroup label="<?php _e('Rotating Exits', 'pe-services'); ?>">
						<option value="rotateOut" <?php echo($animation == 'rotateOut') ? 'selected' : ''; ?>>rotateOut</option>
						<option value="rotateOutDownLeft" <?php echo($animation == 'rotateOutDownLeft') ? 'selected' : ''; ?>>rotateOutDownLeft</option>
						<option value="rotateOutDownRight" <?php echo($animation == 'rotateOutDownRight') ? 'selected' : ''; ?>>rotateOutDownRight</option>
						<option value="rotateOutUpLeft" <?php echo($animation == 'rotateOutUpLeft') ? 'selected' : ''; ?>>rotateOutUpLeft</option>
						<option value="rotateOutUpRight" <?php echo($animation == 'rotateOutUpRight') ? 'selected' : ''; ?>>rotateOutUpRight</option>
					</optgroup>

					<optgroup label="<?php _e('Sliding Entrances', 'pe-services'); ?>">
						<option value="slideInUp" <?php echo($animation == 'slideInUp') ? 'selected' : ''; ?>>slideInUp</option>
						<option value="slideInDown" <?php echo($animation == 'slideInDown') ? 'selected' : ''; ?>>slideInDown</option>
						<option value="slideInLeft" <?php echo($animation == 'slideInLeft') ? 'selected' : ''; ?>>slideInLeft</option>
						<option value="slideInRight" <?php echo($animation == 'slideInRight') ? 'selected' : ''; ?>>slideInRight</option>

					</optgroup>
					<optgroup label="<?php _e('Sliding Exits', 'pe-services'); ?>">
						<option value="slideOutUp" <?php echo($animation == 'slideOutUp') ? 'selected' : ''; ?>>slideOutUp</option>
						<option value="slideOutDown" <?php echo($animation == 'slideOutDown') ? 'selected' : ''; ?>>slideOutDown</option>
						<option value="slideOutLeft" <?php echo($animation == 'slideOutLeft') ? 'selected' : ''; ?>>slideOutLeft</option>
						<option value="slideOutRight" <?php echo($animation == 'slideOutRight') ? 'selected' : ''; ?>>slideOutRight</option>

					</optgroup>

					<optgroup label="<?php _e('Zoom Entrances', 'pe-services'); ?>">
						<option value="zoomIn" <?php echo($animation == 'zoomIn') ? 'selected' : ''; ?>>zoomIn</option>
						<option value="zoomInDown" <?php echo($animation == 'zoomInDown') ? 'selected' : ''; ?>>zoomInDown</option>
						<option value="zoomInLeft" <?php echo($animation == 'zoomInLeft') ? 'selected' : ''; ?>>zoomInLeft</option>
						<option value="zoomInRight" <?php echo($animation == 'zoomInRight') ? 'selected' : ''; ?>>zoomInRight</option>
						<option value="zoomInUp" <?php echo($animation == 'zoomInUp') ? 'selected' : ''; ?>>zoomInUp</option>
					</optgroup>

					<optgroup label="<?php _e('Zoom Exits', 'pe-services'); ?>">
						<option value="zoomOut" <?php echo($animation == 'zoomOut') ? 'selected' : ''; ?>>zoomOut</option>
						<option value="zoomOutDown" <?php echo($animation == 'zoomOutDown') ? 'selected' : ''; ?>>zoomOutDown</option>
						<option value="zoomOutLeft" <?php echo($animation == 'zoomOutLeft') ? 'selected' : ''; ?>>zoomOutLeft</option>
						<option value="zoomOutRight" <?php echo($animation == 'zoomOutRight') ? 'selected' : ''; ?>>zoomOutRight</option>
						<option value="zoomOutUp" <?php echo($animation == 'zoomOutUp') ? 'selected' : ''; ?>>zoomOutUp</option>
					</optgroup>

					<optgroup label="<?php _e('Specials', 'pe-services'); ?>">
						<option value="hinge" <?php echo($animation == 'hinge') ? 'selected' : ''; ?>>hinge</option>
						<option value="rollIn" <?php echo($animation == 'rollIn') ? 'selected' : ''; ?>>rollIn</option>
						<option value="rollOut" <?php echo($animation == 'rollOut') ? 'selected' : ''; ?>>rollOut</option>
					</optgroup>

				</select>
			</p>

			<p>
				<label for="<?php echo $this -> get_field_id('animation_delay'); ?>"><?php _e('Animation Delay', 'pe-services'); ?> <small><?php _e('(miliseconds)', 'pe-services'); ?></small></label>
				<input id="<?php echo $this -> get_field_id('animation_delay'); ?>" name="<?php echo $this -> get_field_name('animation_delay'); ?>" type="text" value="<?php echo $animation_delay; ?>" size="3" />
			</p>

			<p>
				<label for="<?php echo $this -> get_field_id('animation_interval'); ?>"><?php _e('Animation Interval', 'pe-services'); ?> <small><?php _e('(miliseconds)', 'pe-services'); ?></small></label>
				<input id="<?php echo $this -> get_field_id('animation_interval'); ?>" name="<?php echo $this -> get_field_name('animation_interval'); ?>" type="text" value="<?php echo $animation_interval; ?>" size="3" />
			</p>

	<?php }

		function update($new_instance, $old_instance) {
			$instance = $old_instance;

			$instance['title'] = strip_tags($new_instance['title']);
			$instance['select_view'] = esc_attr($new_instance['select_view']);

			$service_array = array_map('intval', $new_instance['service_ids']);
			$instance['service_ids'] = (array)$service_array;

			$instance['avatar_size'] = esc_attr($new_instance['avatar_size']);
			$instance['total_to_show'] = esc_attr($new_instance['total_to_show']);
			$instance['members_per_row'] = esc_attr($new_instance['members_per_row']);
			$instance['desc_limit'] = esc_attr($new_instance['desc_limit']);
			$instance['member_name'] = isset( $new_instance['member_name'] ) ? 1 : 0;
			$instance['linked_name'] = isset( $new_instance['linked_name'] ) ? 1 : 0;
			$instance['member_profession'] = isset( $new_instance['member_profession'] ) ? 1 : 0;
			$instance['member_avatar'] = isset( $new_instance['member_avatar'] ) ? 1 : 0;
			$instance['member_desc'] = isset( $new_instance['member_desc'] ) ? 1 : 0;
			$instance['social_icon'] = isset( $new_instance['social_icon'] ) ? 1 : 0;
			$instance['order'] = esc_attr($new_instance['order']);
			$instance['animation'] = esc_attr($new_instance['animation']);
			$instance['animation_delay'] = esc_attr($new_instance['animation_delay']);
			$instance['animation_interval'] = esc_attr($new_instance['animation_interval']);

			return $instance;
		}

	}
}
?>
