/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

(function($) {

	"use strict";

	/* ---------------------------- */
	/* READY state                  */
	/* ---------------------------- */

	$(document).ready(function() {

		// PE Section space
		//-------------------------------------------------------

		jQuery('.pe-section-space').closest('.container-fluid').parent().addClass('nospace');
		jQuery('.pe-section-space-top').closest('.container-fluid').parent().addClass('nospace-top');
		jQuery('.pe-section-space-bottom').closest('.container-fluid').parent().addClass('nospace-bottom');

		// PE Box
		//-------------------------------------------------------

		var PEboWidget = jQuery('.row .pe-widget.pe_box_widget');
		PEboWidget.first().addClass('first');
		PEboWidget.last().addClass('last');

		// Animated Headlines
		//-------------------------------------------------------

		//set animation timing
		var animationDelay = 2500,
			//loading bar effect
			barAnimationDelay = 3800,
			barWaiting = barAnimationDelay - 3000, //3000 is the duration of the transition on the loading bar - set in the scss/css file
			//letters effect
			lettersDelay = 50,
			//type effect
			typeLettersDelay = 150,
			selectionDuration = 500,
			typeAnimationDelay = selectionDuration + 800,
			//clip effect
			revealDuration = 600,
			revealAnimationDelay = 1500;

		initHeadline();


		function initHeadline() {
			//insert <i> element for each letter of a changing word
			singleLetters($('.cd-headline.letters').find('b'));
			//initialise headline animation
			animateHeadline($('.cd-headline'));
		}

		function singleLetters($words) {
			$words.each(function(){
				var word = $(this),
					letters = word.text().split(''),
					selected = word.hasClass('is-visible');
				for (i in letters) {
					if(word.parents('.rotate-2').length > 0) letters[i] = '<em>' + letters[i] + '</em>';
					letters[i] = (selected) ? '<i class="in">' + letters[i] + '</i>': '<i>' + letters[i] + '</i>';
				}
					var newLetters = letters.join('');
					word.html(newLetters).css('opacity', 1);
			});
		}

		function animateHeadline($headlines) {
			var duration = animationDelay;
			$headlines.each(function(){
				var headline = $(this);

				if(headline.hasClass('loading-bar')) {
					duration = barAnimationDelay;
					setTimeout(function(){ headline.find('.cd-words-wrapper').addClass('is-loading') }, barWaiting);
				} else if (headline.hasClass('clip')){
					var spanWrapper = headline.find('.cd-words-wrapper'),
						newWidth = spanWrapper.width() + 10
					spanWrapper.css('width', newWidth);
				} else if (!headline.hasClass('type') ) {
					//assign to .cd-words-wrapper the width of its longest word
					var words = headline.find('.cd-words-wrapper b'),
						width = 0;
					words.each(function(){
						var wordWidth = $(this).width();
							if (wordWidth > width) width = wordWidth;
					});
					headline.find('.cd-words-wrapper').css('width', width);
				};

				//trigger animation
				setTimeout(function(){ hideWord( headline.find('.is-visible').eq(0) ) }, duration);
			});
		}

		function hideWord($word) {
			var nextWord = takeNext($word);

			if($word.parents('.cd-headline').hasClass('type')) {
				var parentSpan = $word.parent('.cd-words-wrapper');
				parentSpan.addClass('selected').removeClass('waiting');
				setTimeout(function(){
					parentSpan.removeClass('selected');
					$word.removeClass('is-visible').addClass('is-hidden').children('i').removeClass('in').addClass('out');
				}, selectionDuration);
				setTimeout(function(){ showWord(nextWord, typeLettersDelay) }, typeAnimationDelay);

			} else if($word.parents('.cd-headline').hasClass('letters')) {
				var bool = ($word.children('i').length >= nextWord.children('i').length) ? true : false;
				hideLetter($word.find('i').eq(0), $word, bool, lettersDelay);
				showLetter(nextWord.find('i').eq(0), nextWord, bool, lettersDelay);

			}  else if($word.parents('.cd-headline').hasClass('clip')) {
				$word.parents('.cd-words-wrapper').animate({ width : '2px' }, revealDuration, function(){
					switchWord($word, nextWord);
					showWord(nextWord);
				});

			} else if ($word.parents('.cd-headline').hasClass('loading-bar')){
				$word.parents('.cd-words-wrapper').removeClass('is-loading');
				switchWord($word, nextWord);
				setTimeout(function(){ hideWord(nextWord) }, barAnimationDelay);
				setTimeout(function(){ $word.parents('.cd-words-wrapper').addClass('is-loading') }, barWaiting);

			} else {
				switchWord($word, nextWord);
				setTimeout(function(){ hideWord(nextWord) }, animationDelay);
			}
		}

		function showWord($word, $duration) {
			if($word.parents('.cd-headline').hasClass('type')) {
				showLetter($word.find('i').eq(0), $word, false, $duration);
				$word.addClass('is-visible').removeClass('is-hidden');

			}  else if($word.parents('.cd-headline').hasClass('clip')) {
				$word.parents('.cd-words-wrapper').animate({ 'width' : $word.width() + 10 }, revealDuration, function(){
					setTimeout(function(){ hideWord($word) }, revealAnimationDelay);
				});
			}
		}

		function hideLetter($letter, $word, $bool, $duration) {
			$letter.removeClass('in').addClass('out');

			if(!$letter.is(':last-child')) {
				setTimeout(function(){ hideLetter($letter.next(), $word, $bool, $duration); }, $duration);
			} else if($bool) {
				setTimeout(function(){ hideWord(takeNext($word)) }, animationDelay);
			}

			if($letter.is(':last-child') && $('html').hasClass('no-csstransitions')) {
				var nextWord = takeNext($word);
				switchWord($word, nextWord);
			}
		}

		function showLetter($letter, $word, $bool, $duration) {
			$letter.addClass('in').removeClass('out');

			if(!$letter.is(':last-child')) {
				setTimeout(function(){ showLetter($letter.next(), $word, $bool, $duration); }, $duration);
			} else {
				if($word.parents('.cd-headline').hasClass('type')) { setTimeout(function(){ $word.parents('.cd-words-wrapper').addClass('waiting'); }, 200);}
				if(!$bool) { setTimeout(function(){ hideWord($word) }, animationDelay) }
			}
		}

		function takeNext($word) {
			return (!$word.is(':last-child')) ? $word.next() : $word.parent().children().eq(0);
		}

		function takePrev($word) {
			return (!$word.is(':first-child')) ? $word.prev() : $word.parent().children().last();
		}

		function switchWord($oldWord, $newWord) {
			$oldWord.removeClass('is-visible').addClass('is-hidden');
			$newWord.removeClass('is-hidden').addClass('is-visible');
		}

		// isMobile
		//-------------------------------------------------------

		function isMobile() {
			if(navigator.userAgent.indexOf("Mobile") > 0){
				return true;
			} else {
				return false;
			}
		}

		// Contact Form Handling - send-email.php
		//-------------------------------------------------------

		if(jQuery().validate && jQuery().ajaxSubmit) {

			var submitButton = $( '#submit-button'),
					messageContainer = $( '.pe-success'),
					errorContainer = $( '.pe-alert' );

			var formOptions = {
				beforeSubmit: function() {
					submitButton.attr('disabled','disabled');
					messageContainer.fadeOut('fast');
					errorContainer.fadeOut('fast');
				},
				success: function( ajax_response, statusText, xhr, $form) {
					var response = $.parseJSON ( ajax_response );
					submitButton.removeAttr('disabled');
					if( response.success ) {
						$form.resetForm();
						messageContainer.html( response.message ).fadeIn('fast');
					} else {
						errorContainer.html( response.message ).fadeIn('fast');
					}
				}
			};

			// Contact page form
			//-------------------------------------------------------

			$('#pe-contact-form').validate( {
				errorLabelContainer: errorContainer,
				submitHandler: function(form) {
					$(form).ajaxSubmit( formOptions );
				}
			});
		}

		//jQuery 'Back to Top' script
		//-------------------------------------------------------

		// hide #pe-back-top first
		jQuery("#pe-back-top").hide();
		// fade in #pe-back-top
		jQuery(function () {
			jQuery(window).scroll(function () {
				if (jQuery(this).scrollTop() > 100) {
					jQuery('#pe-back-top').fadeIn();
				} else {
					jQuery('#pe-back-top').fadeOut();
				}
			});
			// scroll body to 0px on click
			jQuery('#pe-back-top a').click(function () {
				jQuery('body,html').animate({
					scrollTop: 0
				}, 800);
				return false;
			});
		});

		//jQuery Off-Canvas
		//-------------------------------------------------------

		var scrollsize;

		$('#pe-offcanvas').find('a').attr('tabindex', -1);

		$(function() {
			// Toggle Nav on Click
			$('.toggle-nav').click(function(e) {
				e.preventDefault();
				$('.toggle-nav').toggleClass('active');
				// Get scroll size on offcanvas open
				if(!$('body').hasClass('off-canvas')) {
					scrollsize = $(window).scrollTop();
				}
				// Calling a function
				toggleNav();
			});
		});

		function toggleNav() {
			var y = $(window).scrollTop();
			if ($('body').hasClass('off-canvas')) {
				// Do things on Nav Close
				$('body').removeClass('off-canvas');
				setTimeout(function() {
					$('.sticky-bar #pe-bar').removeAttr('style');
					$('html').removeClass('no-scroll').removeAttr('style');
					$(window).scrollTop(scrollsize);
				}, 300);
			} else {
			// Do things on Nav Open
			$('body').addClass('off-canvas');
			$('.sticky-bar #pe-bar').css({'position':'absolute','top':y});
				setTimeout(function() {
					$('html').addClass('no-scroll').css('top',-y);
				}, 300);
			}
		}

		// Modal
		//-------------------------------------------------------

		if (!!$.prototype.magnificPopup) {
			$('.pe-gallery').each(function() {
				$(this).find('.pe-gallery-modal').magnificPopup({
					type:'inline',
					midClick: true, // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
					gallery: {
						enabled: true
					}
				});
			});

			$('.pe-modal').magnificPopup({
				type:'inline',
				midClick: true, // allow opening popup on middle mouse click. Always set it to true if you don't provide alternative source.
			});

			$('.pe-modal, .pe-gallery-modal').keypress(function (e) {
				if (e.which == 13) {
					$(this).trigger('click');
				}
			});
		}

		// Refresh map
		//-------------------------------------------------------

		function refreshGoogleMap( element ) {
			var map = $(element).find('.pe_map_canvas');
			if( map.length ) {
				var maps = window.pemaps;
				map.each(function() {
					var self = maps[ $(this).attr('id') ];
					if( typeof self != 'undefined' ) {
						google.maps.event.trigger( self.map,'resize' );
						self.map.setCenter( self.marker.getPosition() );
						if( typeof self.infoWindow != 'undefined' ) {
							self.infoWindow.setContent( self.tooltip );
						}
					}
				});
			}
		}

		// Tabs
		//-------------------------------------------------------

		jQuery('.pe-tabs .pe-tab-links a').on('click', function(e)  {
			e.preventDefault();
			var currentAttrValue = jQuery(this).attr('href'),
				tabContent = jQuery('.pe-tabs ' + currentAttrValue);
			// Show/Hide Tabs
			tabContent.slideDown(400).siblings().slideUp(400);
			// Change/remove current tab to active
			jQuery(this).parent('li').addClass('active').siblings().removeClass('active');
			//refreshGoogleMap( tabContent );
		});

		// Panels
		//-------------------------------------------------------

		jQuery('.pe-panels').each(function (){
			//check multiselect
			if(jQuery(this).attr('aria-multiselectable')) {
				var multiSelect = true;
			} else {
				var multiSelect = false;
			}

			var allTitles = jQuery(this).find('.pe-panel-heading');
			var allContents = jQuery(this).find('.pe-panel-content');

			//hide content
			allContents.each(function() {
				if(!jQuery(this).hasClass('active')) {
					jQuery(this).hide();
				}
			});

			//on click
			allTitles.find('a').click(function(e) {
				e.preventDefault();
				SlickUpdateHeight(this);

				var thisTitle = jQuery(this).parent();
				var thisContent = jQuery(this).parent().next();

				if(!thisContent.hasClass('active')) {
					//if item NOT active
					if(!multiSelect) {
						allContents.slideUp(400).removeClass('active');
						allContents.attr('aria-expanded', 'false');
						allTitles.removeClass('active');
					}
					thisContent.slideDown(400).addClass('active');
					thisContent.attr('aria-expanded', 'true');
					thisTitle.addClass('active');

				} else {
					//if item ACTIVE
					if(!multiSelect) {
						allContents.slideUp(400).removeClass('active');
						allContents.attr('aria-expanded', 'false');
						allTitles.removeClass('active');
					} else {
						thisContent.slideUp(400).removeClass('active');
						thisContent.attr('aria-expanded', 'false');
						thisTitle.removeClass('active');
					}
				}
				//refreshGoogleMap( thisContent );

			});
		});

		// Carousel
		//-------------------------------------------------------

		function SlickUpdateHeight(e) {
			var slider = $(e).closest('.slick-slider');
			if( slider.length ) {
				slider.find('.slick-list').css('height','auto'); //temporary
				setTimeout(function(){
					slider.slick('setPosition');
				}, 400);
			}
		}

		function unFocusable(e) {
			jQuery(e).find('.slick-slide a').attr('tabindex', '-1');
			jQuery(e).find('.slick-slide.slick-active a').attr('tabindex', '0');
		}

		jQuery('.pe-carousel').each(function (){
			var slider = jQuery(this).find('.pe-content');
			var indicator = jQuery(this).find('.pe-indicator');
			var anchor = slider.find('a');

			slider.slick({
				arrows: false,
				adaptiveHeight: true,
				pauseOnHover: true,
				accessibility: false
			});

			indicator.each(function (){
				jQuery(this).on('keyup', function(event){
					if(event.which == 13) { // enter key
						jQuery(this).click();
					}
				});
			});

			indicator.click(function(e){
				e.preventDefault();
				var itemId = $(this).attr('href');
				var slideIndex = $(this).attr('data-slick-goto');
				slider.slick('slickGoTo', slideIndex);
				if( itemId != undefined ) {
					history.replaceState(null,null,itemId);
					if( isMobile() ) {
						var offset = $(itemId).offset().top,
							stickyHeight = ( $('.sticky-bar #pe-main').length ) ? parseInt($('.sticky-bar #pe-main').css('padding-top')) : 0;
						$('html, body').animate({
							scrollTop: offset - stickyHeight
						}, 600);
					}
				}
			});

			unFocusable(this);

			slider.on('afterChange', function(slick, currentSlide){
				unFocusable(this);
				indicator.each(function(){
					var $this = jQuery(this);
					if ($this.attr('data-slick-goto') == currentSlide.currentSlide) {
						$this.addClass('active');
					} else {
						$this.removeClass('active');
					}
				});
			});
		});

		// Hash
		//-------------------------------------------------------

		function hashTab() {
			if( window.location.hash ) {
				var hash = window.location.hash;
				var link = $('a[href="' + hash + '"]');
				link.each(function(){
					$(this).trigger( 'click' );
				});
			}
		}
		hashTab();

		// Search Form
		//-------------------------------------------------------

		function searchForm() {
			var searchModule = $('#pe-bar #pe-search');

			var searchModuleInput = searchModule.find('.pe-search-input');
			var searchModuleInputField = searchModuleInput.find('.s');
			var searchModuleButton = searchModule.find('.button');

			var firstClick = true;

			function openSearch() {
				searchModuleInput.addClass('open');
				searchModuleInput.animate({width:'toggle'},400);
				searchModuleInputField.focus();
				firstClick = false;
			}

			function closeSearch() {
				searchModuleInput.removeClass('open');
				searchModuleInput.animate({width:'toggle'},400);
				firstClick = true;
			}

			if( searchModule.length ) {

				searchModuleInput.hide();

				searchModuleButton.click(function (e) {

					if( firstClick ) {
						openSearch();
						return false;
					} else {
						if( searchModuleInputField.val() ) {
							return;
						} else {
							closeSearch();
							return false;
						}
					}

				});

			}
		}
		searchForm();

		// Max Megamenu helper class

		function PEmegamenuHelper() {
			var PEmegamenuBreakPoint = $('#mega-menu-main-menu').attr('data-breakpoint');
			if( PEmegamenuBreakPoint ) {
				var swidth = (window.innerWidth-$(window).width());
				var PEscreenWidth = $('body').innerWidth() + swidth;
				if( PEscreenWidth <= PEmegamenuBreakPoint ) {
					$('body').addClass('menu-responsive');
				} else {
					$('body').removeClass('menu-responsive');
				}
			}


		}
		PEmegamenuHelper();

		$('#mega-menu-wrap-main-menu .mega-menu-toggle').on('click', function() {
			if( $('body').hasClass('menu-mobile-opened') ) {
				$('body').removeClass('menu-mobile-opened');
			} else {
				$('body').addClass('menu-mobile-opened');
			}
		});


		function PEmegamenuHelperLine() {
			//span to a
			var mainLink = jQuery('#mega-menu-main-menu > li > a');
			mainLink.each(function(){
				$(this).wrapInner('<span class="pe-line"></span>');
			});
		}
		PEmegamenuHelperLine();

		// RESIZE STATE
		jQuery(window).resize(function() {
			PEmegamenuHelper();
		});

		/* ---------------------------- */
		/* end READY state              */
		/* ---------------------------- */

	});

	/* ---------------------------- */
	/* LOAD state                   */
	/* ---------------------------- */

	$(window).load(function() {

		// Sticky Bar
		//-------------------------------------------------------

		var resizeTimer;

		function resizeFunction() {
			var body = $('body');
			var allpage = $('#pe-main');

			if(body.hasClass('sticky-bar')) {
			var bar = allpage.find('#pe-bar-in');
				if (bar.length) {
					var offset = bar.outerHeight();
					allpage.css('padding-top', (offset) + 'px');
				}
			}
		};
		resizeFunction();

		jQuery('.pe-normal').click(function(event) {
			resizeFunction();
		});

		$(window).resize(function() {
			clearTimeout(resizeTimer);
			resizeTimer = setTimeout(resizeFunction, 30);
		});

		$(window).scroll(function() {
			var topbar = $('#pe-bar');
			if (topbar.length) {
				var scroll = $(window).scrollTop();
				if (scroll >= 20) {
					topbar.addClass("scrolled");
				} else {
					topbar.removeClass("scrolled");
				}
			}
		});

		// on scroll animation
		//-------------------------------------------------------

		function onScrollInit( items, trigger ) {
			items.each( function() {
				var osElement = $(this),
						osAnimationClass = osElement.attr('data-animation'),
						osAnimationDelay = osElement.attr('data-animation-delay');

						osElement.css({
							'-webkit-animation-delay':  osAnimationDelay,
							'animation-delay':          osAnimationDelay
						});

						var osTrigger = ( trigger ) ? trigger : osElement;

						osTrigger.waypoint(function() {
							osElement.addClass('animated').addClass(osAnimationClass);
							},{
									triggerOnce: true,
									offset: 'bottom-in-view'
						});
			});
		}
		onScrollInit( $('.pe-animation') );

		// PE Main Menu
		//-------------------------------------------------------

		function is_touch_device() {
			return 'ontouchstart' in window        // works on most browsers
					|| navigator.maxTouchPoints;       // works on IE10/11 and Surface
		};

		function PEtopMenu() {
			var html = $('html, body');
			var navContainer = $('.pe-nav-container');
			var navToggle = $('.nav-toggle');
			var navDropdownToggle = $('.menu-item-has-children');

			var clicked = false;

			//position
			function setPositions() {
				//position
				var navTogglePosition = $('#pe-bar-in').outerHeight();
				if( navTogglePosition > 0 ) {
					navContainer.css({'top':navTogglePosition + 'px'});
				}
				//height
				var peScreenHeight = $(window).height();
				if( peScreenHeight > 0 && navTogglePosition > 0 ) {
					navContainer.css({'max-height': (peScreenHeight - navTogglePosition) + 'px'});
				}
				clicked = true;
			}

			function removePositions() {
				navContainer.css({'top': '', 'max-height': ''});
			}

			// Nav toggle
			navToggle.on('click', function(e) {
				e.preventDefault();

				if( clicked == false ) {
					setPositions();
				} else {
					removePositions();
					clicked = false;
				}

				$(this).toggleClass('is-active');

				navContainer.toggleClass('is-visible responsive');

				html.toggleClass('nav-open no-scroll');

			});

			// Nav dropdown toggle
		navDropdownToggle.on('click', function(e) {

			var $this = $(this);
			var link = $this.find('> a');
			var links = $this.siblings().find('> a');
			var hash = link.is('a[href^="#"]');
			var responsive = $this.closest('.pe-nav-container').hasClass('responsive');

			if( ! link.hasClass('clicked') ) {
				if( ! responsive ) {
					links.removeClass('clicked');
				}

				link.toggleClass('clicked');
				$this.toggleClass('is-active').children('.nav-dropdown').toggleClass('is-visible');

				if( hash || is_touch_device() || responsive ) {
					return false;
				}
			} else {
				link.toggleClass('clicked');
				$this.toggleClass('is-active').children('.nav-dropdown').toggleClass('is-visible');

				if ( hash ) {
					return false;
				}
				//go to url here
			}

		});

		// Prevent click events from firing on children of navDropdownToggle
		navDropdownToggle.find('.nav-dropdown a').click(function(e) {
			e.stopPropagation();
		});

		}
		PEtopMenu();

		// Change submenu position if it doesn't fit the screen (desktop view)
		function PEtopMenuDropdownDirection() {
			var navContainer = $('.pe-nav-container');
			var navDropdownToggle = $('.menu-item-has-children');
			//mouse over (parent)
				navDropdownToggle.mouseenter(function() {

					if ( navContainer.hasClass('responsive') ) {
						return;
					}

					var screenWidth = $(window).width();
					var dropDown = $(this).find('.nav-dropdown');
					dropDown.each( function(e) {
						var dropDownPosition = $(this).offset();
						var dropDownWidth = $(this).width();

						if((dropDownPosition.left + dropDownWidth) > screenWidth) {
							$(this).toggleClass('change-direction');
						}

					});
				});

			//remove class when mouse out of menu
			navContainer.mouseleave(function(){
				$(this).find('.nav-dropdown').removeClass('change-direction');
			});

		}
		PEtopMenuDropdownDirection();


		// WCAG MENU
		//-------------------------------------------------------

		function wcagSimpleMenu() {

			var menuContainer = jQuery('.pe-nav-container');
			var menuLi = menuContainer.find('.menu-item');
			var totalElements = menuLi.length;

			menuLi.each(function(index){

				var li = $(this);
				var anchor = li.find('> a');

				anchor.on('focus',function(){
					setTimeout(function(){
						li.trigger('mouseenter');
					}, 50);
				});

				anchor.on('focusout',function(){
					if(index === totalElements - 1) {
						setTimeout(function(){
							li.trigger('mouseleave');
						}, 50);
					}
				});

				li.on('mouseenter', function() {
					li.siblings().removeClass('hover');
					li.addClass('hover');
				});

				li.on('mouseleave', function() {
					li.removeClass('hover');
				});

			});

		}
		wcagSimpleMenu();

		// function wcagMaxMegaMenu() {

		// 	$('.mega-menu-toggle').on('mousedown', function() {
		// 		$(this).toggleClass('clicked');
		// 	});

		// 	$('.mega-menu-toggle').on('focus', function() {
		// 		if( ! $(this).hasClass('clicked') ) {
		// 			$(this).trigger('click');
		// 		}
		// 	});

		// 	$('#mega-menu-main-menu .mega-menu-link').last().on('focusout', function(e) {
		// 		if( !$(e.relatedTarget).hasClass('mega-menu-link') ) {
		// 			$('.mega-menu-toggle').removeClass('mega-menu-open clicked');
		// 		}
		// 	});

		// }
		// wcagMaxMegaMenu();

		// WCAG Rev Slider
		//-------------------------------------------------------

		function wcagRevSlider() {

			var navi = $('.rev_slider_wrapper .tp-bullets .tp-bullet, .rev_slider_wrapper .tp-leftarrow, .rev_slider_wrapper .tp-rightarrow');

			if( navi.length ) {
				navi.prop('tabindex', '0');
				navi.keypress(function( event ) {
					if ( event.which == 13 ) {
						$(this).trigger('click');
					}
				});
			}
		}

		setTimeout(function() {
			wcagRevSlider();
		}, 500);

	/* ---------------------------- */
	/* end LOAD state               */
	/* ---------------------------- */

	});

})(jQuery);
