<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: https://www.pixelemu.com/company/license PixelEmu Proprietary Use License
 Website: https://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

class PElayout {

	public static $page_layout;

	public static function setLayout( $index ) {
		if(is_int($index) && $index > 0 && $index < 7) {
			self::$page_layout = $index;
		} else {
			self::$page_layout = false;
		}
	}

	public static function getLayout( $index ) {

		if( !empty(self::$page_layout) ) {
			$options_layout = self::$page_layout;
		} else {
			$options_layout = ( is_front_page() ) ? peGetOptions('frontpage-layout') : peGetOptions('subpage-layout');
		}

		$layout['current-layout'] = $options_layout;

		switch ($options_layout) {
			case 1: // Left + Content
				$layout['span-left'] = (is_active_sidebar( 'left-column' )) ? peGetOptions('left-column-width') : 0;
				$layout['span-right'] = 0;
				$layout['span-content'] = 12 - $layout['span-left'] - $layout['span-right'];
				$layout['content-class'] = 'col-md-' . $layout['span-content'] . ' col-md-push-' . $layout['span-left'];
				$layout['left-class'] = 'col-md-' . $layout['span-left'] . ' col-md-pull-' . $layout['span-content'];
				break;
			case 2: // Content + Right
				$layout['span-left'] = 0;
				$layout['span-right'] = (is_active_sidebar( 'right-column' )) ? peGetOptions('right-column-width') : 0;
				$layout['span-content'] = 12 - $layout['span-left'] - $layout['span-right'];
				$layout['content-class'] = 'col-md-' . $layout['span-content'];
				$layout['right-class'] = 'col-md-' . $layout['span-right'];
				break;
			case 3: // Content
				$layout['span-content'] = 12;
				$layout['content-class'] = 'col-md-' . $layout['span-content'];
				break;
			case 4: // Left + Content + Right
				$layout['span-left'] = (is_active_sidebar( 'left-column' )) ? peGetOptions('left-column-width') : 0;
				$layout['span-right'] = (is_active_sidebar( 'right-column' )) ? peGetOptions('right-column-width') : 0;
				$layout['span-content'] = 12 - $layout['span-left'] - $layout['span-right'];
				$layout['content-class'] = 'col-md-' . $layout['span-content'] . ' col-md-push-' . $layout['span-left'];
				$layout['left-class'] = 'col-md-' . $layout['span-left'] . ' col-sm-6 col-md-pull-' . $layout['span-content'];
				$layout['right-class'] = 'col-md-' . $layout['span-right'] . ' col-sm-6';
				break;
			case 5: // Left + Right + Content
				$layout['span-left'] = (is_active_sidebar( 'left-column' )) ? peGetOptions('left-column-width') : 0;
				$layout['span-right'] = (is_active_sidebar( 'right-column' )) ? peGetOptions('right-column-width') : 0;
				$layout['span-content'] = 12 - $layout['span-left'] - $layout['span-right'];
				$layout['content-class'] = 'col-md-' . $layout['span-content'].' col-md-push-' . ($layout['span-left'] + $layout['span-right']);
				$layout['left-class'] = 'col-md-' . $layout['span-left'].' col-sm-6 col-md-pull-' . $layout['span-content'];
				$layout['right-class'] = 'col-md-' . $layout['span-right'].' col-sm-6 col-md-pull-' . $layout['span-content'];
				break;
			case 6: // Content + Left + Right
				$layout['span-left'] = (is_active_sidebar( 'left-column' )) ? peGetOptions('left-column-width') : 0;
				$layout['span-right'] = (is_active_sidebar( 'right-column' )) ? peGetOptions('right-column-width') : 0;
				$layout['span-content'] = 12 - $layout['span-left'] - $layout['span-right'];
				$layout['content-class'] = 'col-md-' . $layout['span-content'];
				$layout['left-class'] = 'col-md-' . $layout['span-left'].' col-sm-6';
				$layout['right-class'] = 'col-md-' . $layout['span-right'].' col-sm-6';
				break;
		}

		if( !empty($layout[$index]) ) {
			return $layout[$index];
		} else {
			return false;
		}

	}

}

?>