<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: https://www.pixelemu.com/company/license PixelEmu Proprietary Use License
 Website: https://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$blog_layout = peGetOptions('default-blog-layout'); //front
$archive_layout = peGetOptions('subpage-blog-layout'); //subpage

// get individual category layout
if (is_category()) {
	$category = get_category($cat); //current category
	//post terms
	$terms = wp_get_post_terms($post->ID, 'category', array('term_taxonomy_id' => $category->term_id));
	foreach ($terms as $term) {
		if($term->term_id == $category->term_id) {
			$blog_layout_individual = get_tax_meta($term->term_id, 'select_field_id');
		}
	}
}

//set blog layout
if(!empty($blog_layout_individual)) {
	$category_layout = $blog_layout_individual;
} else {
	$category_layout = '';
}

if ( have_posts() ) :

// Get appropriate template part for front page
if ( (is_home() && $blog_layout == 2) || ((!is_home() && $archive_layout == 2) || $category_layout == 2) ) {

	get_template_part( 'tpl/blog2' );

} else {

	get_template_part( 'tpl/blog' );

}

else : ?>

<p class="nothing-found"><?php _e('No Posts Found!', 'pe-services'); ?></p>

<?php endif; ?>