<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/*
* Template Name: Contact Page
*/

get_header();

//set layout
PElayout::setLayout(6);

$contact_email = peGetOptions('contact-email-recipients');
$contact_form = peGetOptions('contact-form');
$contact_details = peGetOptions('contact-details');
$contact_map = peGetOptions('contact-map');

$page_class = 'col-md-5';

if (!$contact_form || !$contact_details && !$contact_map) {
	$page_class = 'col-md-12';
}

$map_lati = peGetOptions('contact-map-latitiude');
$map_longi = peGetOptions('contact-map-longitude');
$map_zoom = peGetOptions('contact-map-zoom');

$contact_address = stripslashes(peGetOptions('contact-address') );

$email_address = sanitize_email( peGetOptions('email-address') );
$email_address = is_email($email_address);

if ($contact_form) {
	$right_class = 'col-md-7';
} else {
	$right_class = 'col-md-12';
}

$highContrast = peGetOptions('highContrast');

$reCaptcha = ( peGetOptions('google-captcha') && peGetOptions('google-captcha-api') && peGetOptions('google-captcha-sitekey') && peGetOptions('google-captcha-secretkey') ) ? true : false;

?>

<div id="pe-content" class="pe-page-contact">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo $page_class ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<div <?php post_class(array('pe-contact','clearfix')); ?> itemscope="" itemtype="http://schema.org/Person">

						<div class="page-header">
							<h1 itemprop="name"><?php the_title(); ?></h1>
						</div>

						<!-- Begin of contact form -->

						<?php if(!empty($contact_email) && ($contact_form)) : ?>

						<div role="status" class="pe-alert"></div>
						<div role="status" class="pe-success"></div>

						<form id="pe-contact-form" class="pe-contact-form" method="post" action="<?php echo admin_url('admin-ajax.php'); ?>">
							<div class="pe-form-group">
								<label for="contactName" title="<?php _e('Your name', 'pe-services'); ?>"><?php _e('Name', 'pe-services'); ?><span class="star">&nbsp;*</span></label>
								<input type="text" name="contactName" id="contactName" autocomplete="name" title="<?php _e( '* Please provide your name', 'pe-services'); ?>" required>
							</div>

							<div class="pe-form-group">
								<label for="contactEmail" title="<?php _e('Email address for contact', 'pe-services'); ?>"><?php _e('Email', 'pe-services'); ?><span class="star">&nbsp;*</span></label>
								<input type="text" name="contactEmail" id="contactEmail" autocomplete="email" title="<?php _e( '* Please provide a valid email address', 'pe-services'); ?>" required>
							</div>

							<div class="pe-form-group">
								<label for="contactSubject" title="<?php _e('Enter the subject of your message here.', 'pe-services'); ?>"><?php _e('Subject', 'pe-services'); ?><span class="star">&nbsp;*</span></label>
								<input type="text" name="contactSubject" id="contactSubject">
							</div>

							<div class="pe-form-group">
								<label for="contactMessage" title="<?php _e('Enter your message here.', 'pe-services'); ?>"><?php _e('Message', 'pe-services'); ?><span class="star">&nbsp;*</span></label>
								<textarea  name="contactMessage" id="contactMessage" cols="50" rows="10" title="<?php _e( '* Please provide your message', 'pe-services'); ?>" required></textarea>
							</div>

							<?php
								if( $reCaptcha ) {
									echo '<div class="pe-form-group"><label for="g-recaptcha-response" class="sr-only">' . __('Google reCaptcha', 'pe-services') . '</label>';
									echo '<div class="g-recaptcha" data-sitekey="' . peGetOptions('google-captcha-sitekey') . '"></div>';
									echo '<script type="text/javascript" src="https://www.google.com/recaptcha/api.js" async defer></script></div>';
								}
							?>

							<div class="pe-form-group">
								<input type="submit" id="submit-button" value="<?php _e('Send Email', 'pe-services'); ?>" class="btn" name="submit">
								<input type="hidden" name="action" value="send_email" />
								<input type="hidden" name="nonce" value="<?php echo wp_create_nonce('send_email_nonce'); ?>"/>
							</div>
						</form>

						<?php endif; ?>
						<!-- End of contact form -->

						<div class="pe-article-content" itemprop="articleBody">

							<?php the_content(); ?>

						</div>

					</div>

					<?php
					endwhile;
					endif;
					?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<!-- Right sidebar -->
			<aside id="pe-right" class="<?php echo $right_class; ?>">
				<div class="row">
				<?php if($contact_details) : ?>

				<div class="pe-widget clearfix">
					<?php if (!empty($contact_address)) {
						echo apply_filters('the_content', $contact_address);
					} ?>
					<?php if (!empty($email_address)) { ?>
					<?php _e('e-mail', 'pe-services'); ?>: <a href="mailto:<?php echo antispambot( $email_address ); ?>" ><?php echo antispambot( $email_address ); ?></a>
					<?php } ?>

				</div>
				<?php endif; ?>

				<?php if($contact_map) : ?>
				<div class="pe-widget clearfix">
					<div id="map_canvas" class="embed-responsive embed-responsive-4by3"></div>
					<script type="text/javascript">
						// Google Map
						function initializeContactMap() {
							var officeLocation = new google.maps.LatLng(<?php echo $map_lati; ?>, <?php echo $map_longi; ?>);
							var contactMapOptions = {
								center: officeLocation,
								zoom: <?php echo $map_zoom; ?>,
								mapTypeId: google.maps.MapTypeId.ROADMAP,
								scrollwheel: false
							};
							var contactMap = new google.maps.Map(document.getElementById("map_canvas"), contactMapOptions);
							var contactMarker = new google.maps.Marker({
								position: officeLocation,
								map: contactMap
							});
						}
						google.maps.event.addDomListener(window, "load", initializeContactMap);
					</script>
				</div>
				<?php endif; ?>
				</div>
			</aside>

		</div>

	</div>

</div>

<?php get_footer(); ?>
