<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/*
* Template Name: Services Page
*/

get_header();

// get services layout
$services_layout = get_post_meta(get_the_ID(), 'thumbnails_position',true);

//check front content
$front_page_content = peGetOptions('front-page-content');
$front_page_check = (!$front_page_content && is_front_page()) ? false : true;

?>

<?php if( $front_page_check ) : ?>

<div id="pe-content" class="pe-page-services">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent">

					<div <?php post_class(array('pe-article','clearfix')); ?> itemscope="" itemtype="http://schema.org/Article">

						<div class="page-header">

							<h1 id="pe-services-title" class="pe-services-title" itemprop="name"><?php the_title(); ?></h1>

						</div>

						<?php 
						if ($services_layout == '1') {
							get_template_part("tpl/services-top");
						} elseif ($services_layout == '2') {
							get_template_part("tpl/services-bottom");
						} elseif ($services_layout == '3') {
							get_template_part("tpl/services-right");
						} elseif ($services_layout == '4') {
							get_template_part("tpl/services-left");
						}
						?>

					</div>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php endif; ?>

<?php get_footer(); ?>