<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$font_sizer_page = peGetOptions('font-sizer-page');
$font_sizer_front = peGetOptions('font-sizer-front');
$front_page_title = peGetOptions('front-page-title');
$comments_page = peGetOptions('comments-page');

//check front content
$front_page_content = peGetOptions('front-page-content');
$front_page_check = (!$front_page_content && is_front_page()) ? false : true;

$highContrast = peGetOptions('highContrast');

?>

<?php if( $front_page_check ) : ?>

<div id="pe-content" class="pe-page">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<?php if( $post->post_content=='' ) : ?>

				<!-- Leave blank to skip empty posts) -->

				<?php else : ?>
				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<div <?php post_class(array('pe-article','clearfix')); ?>>

						<?php if ((is_front_page() && $front_page_title) || !is_front_page() ) { ?>
						<div class="page-header">
							<h1><?php the_title(); ?></h1>
						</div>
						<?php } ?>

						<?php
							if( has_post_thumbnail() ) {
								the_post_thumbnail('large');
							}
						?>

						<div class="pe-article-content">
							<?php the_content(); ?>
						</div>

						<?php
						if ( $comments_page ) {
							comments_template('',true);
						}
						?>

					</div>

					<?php
					endwhile;
					endif;
					?>

				</main>
				<!-- End of main content area -->
				<?php endif; ?>

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php endif; ?>

<?php get_footer(); ?>
