<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$highContrast = peGetOptions('highContrast');

?>

<!-- Begin of main content section/content top/content bottom/left column/right column -->
<div id="pe-content" class="pe-search">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<div id="pe-search-form">
						<?php get_search_form(); ?>
					</div>

					<?php if ( have_posts() ) : ?>


					<h1>
						<span class="subheading-category"><?php _e('Search Results For:', 'pe-services'); ?>
							<strong><?php the_search_query();?></strong><?php echo ' (' . $wp_query->found_posts . ')'; ?></span>
					</h1>

					<div itemscope="" itemtype="http://schema.org/Blog">

						<?php while ( have_posts() ) : the_post(); ?>

						<div class="pe-blog-row">
							<div class="row clearfix">
								<div class="blog-col col-md-12">

									<div class="page-header">
										<h2 itemprop="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										<div class="post-meta standard-meta thumb-<?php echo has_post_thumbnail() ? 'exist' : 'not-exist'; ?>">
											<span><?php _e('Posted on', 'pe-services'); ?> <span class="date"> <?php the_time('F d, Y'); ?></span></span>
											<span><?php _e('by', 'pe-services'); ?>
												<span class="author-link">
													<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author" title="<?php printf( __( 'View all posts by %s', 'pe-services' ), get_the_author_meta('display_name') ); ?>" >
														<?php echo get_the_author_meta('display_name'); ?>
													</a>
												</span>
												<?php _e('in', 'pe-services'); ?> <?php the_category(', '); ?>
												<?php edit_post_link(__("Edit", 'pe-services'), '<span> / </span>', ''); ?>
											</span>
										</div>
									</div>

									<div class="pe-article-content" itemprop="articleBody">
										<?php
										if( strpos( $post->post_content, '<!--more-->' ) ) {
											the_content();
										} else {
											pe_blog_excerpt(55);
										}
										?>
									</div>
								</div>
							</div>
						</div>

						<?php endwhile;

						pe_pagination( $wp_query->max_num_pages );

						?>

					</div>

					<?php else : ?>
					<p class="nothing-found"><?php _e('No Results Found!', 'pe-services'); ?></p>
					<?php endif; ?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>
<!-- End of main content section/content top/content bottom/left column/right column -->

<?php get_footer(); ?>
