<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$show_member_hours = peGetOptions('opening-hours-member');

//get professions
$member_professions = get_post_meta($post->ID, 'member_profession',true);
$member_custom_profession = get_post_meta($post->ID, 'member_custom_profession',true);

$member_professions_check = (is_array($member_professions)) ? true : false;
$member_custom_profession_check = (!empty($member_custom_profession)) ? true : false;

//opening
$member_opening_hours = get_post_meta($post->ID, 'opening_hours',true);

$member_phone = get_post_meta($post->ID, 'member_phone',true);
$member_email = get_post_meta($post->ID, 'member_email',true);

$image_size = peGetOptions('image-size-member');

$member_fb = get_post_meta($post->ID, 'member_fb',true);
$member_tw = get_post_meta($post->ID, 'member_tw',true);
$member_li = get_post_meta($post->ID, 'member_li',true);

$social_icon = peGetOptions('social-links-member');

$contact_info = peGetOptions('contact-info-member');

$highContrast = peGetOptions('highContrast');

?>

<div id="pe-content" class="pe-single-member">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<div <?php post_class(array('pe-article','clearfix')); ?> itemscope="" itemtype="http://schema.org/Article">

						<div class="page-header">

							<h1 itemprop="name"><?php the_title(); ?></h1>

							<div class="post-meta standard-meta thumb-<?php echo has_post_thumbnail()?'exist':'not-exist'; ?>">

								<?php if($member_professions_check || $member_custom_profession_check) { ?>
								<span>
								<?php
								//display
								if($member_professions_check) {
									$profession_array = array();
									foreach($member_professions as $value) {
										$proffesion_title = get_the_title( $value );
										if( !empty($proffesion_title) ) {
											$profession_array[] = $proffesion_title;
										}
									}
									$profession_output = implode (', ', $profession_array);
									echo $profession_output;
								}
								if($member_custom_profession_check) {
									if( $member_professions_check ) {
										echo ', ';
									}
									echo $member_custom_profession;
								}
								?>
								</span>
								<?php } ?>
							</div>

						</div>

						<?php
						if ( has_post_thumbnail() ){
							$image_id = get_post_thumbnail_id();
							$image_url = wp_get_attachment_url( $image_id );
						?>

						<figure>

							<div class="pull-left pe-item-image">

								<?php if ( $image_size ) {
							the_post_thumbnail( $image_size );
						} else {
							the_post_thumbnail();
						}
								?>

							</div>

						</figure>

						<?php } ?>

						<div class="pe-article-content" itemprop="articleBody">

							<?php the_content(); ?>

							<?php

							if( $show_member_hours ) {
								$opening_data = false;
								foreach($member_opening_hours as $value) {
									if (!empty($value)) {
										$opening_data = true;
										break;
									}
								}
							} else {
								$opening_data = false;
							}

							if((($opening_data) && is_array($member_opening_hours)) ||
								 ($contact_info && !empty($member_phone) || !empty($member_email)) ||
								 ( $social_icon && (!empty($member_fb) || ($member_tw) || ($member_li) ) )) {
								echo '<div class="pe-row single-member">';
							}

							//opening hours
							if (($opening_data) && is_array($member_opening_hours)) {
								echo '<div class="pe-opening-hours col-md-4">';
								echo '<h3 class="pe-title">' . __( 'Opening Hours', 'pe-services' ) . '</h3>';
								echo '<ul class="pe-hours">';

								//monday
								if(!empty($member_opening_hours['monday-from'] || $member_opening_hours['monday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Monday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['monday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['monday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['monday-from']) && !empty($member_opening_hours['monday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['monday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['monday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//tuesday
								if(!empty($member_opening_hours['tuesday-from'] || $member_opening_hours['tuesday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Tuesday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['tuesday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['tuesday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['tuesday-from']) && !empty($member_opening_hours['tuesday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['tuesday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['tuesday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//wednesday
								if(!empty($member_opening_hours['wednesday-from'] || $member_opening_hours['wednesday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Wednesday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['wednesday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['wednesday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['wednesday-from']) && !empty($member_opening_hours['wednesday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['wednesday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['wednesday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//thursday
								if(!empty($member_opening_hours['thursday-from'] || $member_opening_hours['thursday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Thursday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['thursday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['thursday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['thursday-from']) && !empty($member_opening_hours['thursday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['thursday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['thursday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//friday
								if(!empty($member_opening_hours['friday-from'] || $member_opening_hours['friday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Friday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['friday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['friday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['friday-from']) && !empty($member_opening_hours['friday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['friday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['friday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//saturday
								if(!empty($member_opening_hours['saturday-from'] || $member_opening_hours['saturday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Saturday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['saturday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['saturday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['saturday-from']) && !empty($member_opening_hours['saturday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['saturday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['saturday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								//sunday
								if(!empty($member_opening_hours['sunday-from'] || $member_opening_hours['sunday-to'])) {
									echo '<li><div class="pe-oh-day">' . __('Sunday', 'pe-services') . '</div>';
									echo '<div class="pe-oh-hours">';
									//from
									if (!empty($member_opening_hours['sunday-from'])) {
										echo '<span class="pe-oh-from">'. $member_opening_hours['sunday-from'] .'</span>';
									}
									//separator
									if (!empty($member_opening_hours['sunday-from']) && !empty($member_opening_hours['sunday-to'])) {
										echo '<span class="pe-separator"></span>';
									}
									//to
									if (!empty($member_opening_hours['sunday-to'])) {
										echo '<span class="pe-oh-to">'. $member_opening_hours['sunday-to'] .'</span>';
									}
									echo '</div></li>';
								}

								echo '</ul>';
								echo '</div>';
							}
							?>

							<?php if ( $contact_info && (!empty($member_phone) || !empty($member_email)) ) { ?>
							<div class="pe-member-contact col-md-4">
								<h3 class="pe-title"><?php _e( 'Contact Details', 'pe-services' ) ?></h3>
								<?php if ( !empty($member_phone) ) { ?>
								<p class="phone"><?php _e('Phone','pe-services'); ?>: <?php echo $member_phone; ?></p>
								<?php } ?>
								<?php if (!empty($member_email) ) { ?>
								<p class="email"><?php _e('E-mail', 'pe-services'); ?>: <a href="mailto:<?php echo antispambot( $member_email ); ?>" ><?php echo antispambot( $member_email ); ?></a></p>
								<?php } ?>
							</div>
							<?php } ?>

							<?php if ( $social_icon && (!empty($member_fb) || !empty($member_tw) || !empty($member_li)) ) { ?>
							<div class="pe-socials col-md-4">
								<h3 class="pe-title"><?php _e( 'Social Media', 'pe-services' ) ?></h3>
								<div class="pe-social-icons">
									<?php if (!empty( $member_fb )) { ?>
									<a class="pe-facebook" href="<?php echo $member_fb ?>"><span class="fa fa-facebook"></span><span class="sr-only"><?php _e('Facebook', 'pe-services'); ?></span></a>
									<?php } ?>
									<?php if (!empty( $member_tw )) { ?>
									<a class="pe-twitter" href="<?php echo $member_tw ?>"><span class="fa fa-twitter"></span><span class="sr-only"><?php _e('Twitter', 'pe-services'); ?></span></a>
									<?php } ?>
									<?php if (!empty( $member_li )) { ?>
									<a class="pe-linkedin" href="<?php echo $member_li ?>"><span class="fa fa-linkedin"></span><span class="sr-only"><?php _e('Linkedin', 'pe-services'); ?></span></a>
									<?php } ?>
								</div>
							</div>
							<?php }

							if((($opening_data) && is_array($member_opening_hours)) ||
								 ($contact_info && !empty($member_phone) || !empty($member_email)) ||
								 ( $social_icon && (!empty($member_fb) || ($member_tw) || ($member_li) ) )) {
								echo '</div>';
							}
							?>
						</div>

					</div>

					<?php
					endwhile;
					endif;
					?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php get_footer(); ?>
