<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$highContrast = peGetOptions('highContrast');

$members_label = __( 'Available specialists', 'pe-services' );

?>

<div id="pe-content-part">

	<div id="pe-content-part-in" class="pe-container">
		<div class="pe-row">

			<div id="pe-content" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<article <?php post_class(); ?>>
		
							<header class="page-header">
								<h1><?php the_title(); ?></h1>
							</header>

							<div class="pe-article-content">
							<h2 class="subtitle">
								<?php
									$service_categories = get_the_terms( $post->ID, 'service-category' );
									if( $service_categories && ! is_wp_error($service_categories) ){
										$service_categories_group = '';
										foreach( $service_categories as $service_category ) {
											$service_categories_group .= $service_category->name . ', ';
										}
										echo substr($service_categories_group, 0, -2);
									}
								?></h2>


							<?php the_content(); ?>
							
							</div>

							<?php
							//members with selected service item (profession)
							$member_args = array(
									'post_type'       => 'member',
									'posts_per_page'  => -1,
									'meta_query' => array(
										array(
											'key' => 'member_profession',
											'value' => serialize($post->ID),
											'compare' => 'LIKE'
										)
									)
							);

							$member_carousel_query = new WP_Query( $member_args );

							if($member_carousel_query->have_posts()): ?>

							<div id="pe-services-carousel">
								<div class="pe-services-members">
									<h3 class="pe-title"><?php echo sanitize_text_field( $members_label ); ?></h3>
									<ul>
									<?php while ($member_carousel_query->have_posts()): $member_carousel_query->the_post(); ?>
										<li><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></li>
									<?php
									endwhile;
									wp_reset_query();
									?>
									</ul>
								</div>
							</div>

							<?php endif; ?>

					</article>

					<?php
					endwhile;
					endif;
					?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<!-- Sidebars -->
			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php

get_footer();

?>
