<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header(); 

$testimonial_occupation = get_post_meta($post->ID, 'testimonial_occupation',true);

$highContrast = peGetOptions('highContrast');

?>

<div id="pe-content" class="pe-single-testimonial">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent" <?php if($highContrast) echo 'tabindex="-1"'; ?>>

					<?php get_template_part( 'tpl/fontswitcher' ); ?>

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<div <?php post_class(array('pe-article','clearfix')); ?> itemscope="" itemtype="http://schema.org/Article">

						<div class="page-header">

							<h1 itemprop="name"><?php the_title(); ?></h1>

							<div class="post-meta standard-meta thumb-<?php echo has_post_thumbnail()?'exist':'not-exist'; ?>">

								<span><?php echo $testimonial_occupation; ?></span>

							</div>

						</div>

						<?php
						if ( has_post_thumbnail() ){
							$image_id = get_post_thumbnail_id();
							$image_url = wp_get_attachment_url($image_id);
						?>

						<figure>

							<div class="pull-left pe-item-image">

								<?php 
							the_post_thumbnail('medium');
								?>

							</div>

						</figure>

						<?php } ?>

						<div class="pe-article-content" itemprop="articleBody">

							<?php the_content(); ?>

						</div>

					</div>

					<?php 
					endwhile; 
					endif; 
					?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php get_footer(); ?>