<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

get_header();

$comments_single = peGetOptions('comments-post');
$post_tags_single = peGetOptions('post-tags-post');
$post_info_single = peGetOptions('post-info-post');
$author_info_single = peGetOptions('author-info-post');

$single_post_thumb = get_post_meta($post->ID, 'feature_img_archive',true);

$highContrast = peGetOptions('highContrast');

?>

<div id="pe-content" class="pe-single">

	<div id="pe-content-in" class="container-fluid">

		<div class="row">

			<div id="pe-content-wrapp" class="<?php echo PElayout::getLayout('content-class'); ?>">

				<?php get_template_part( 'tpl/content-top' ); ?>

				<!-- Begin of main content area -->
				<main id="pe-maincontent">

					<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

					<div <?php post_class(array('pe-article','clearfix')); ?>>

						<div class="page-header">

							<h1 class="entry-title"><?php the_title(); ?></h1>
							<?php if ( $post_info_single ) : ?>
							<div class="post-meta standard-meta thumb-<?php echo has_post_thumbnail()?'exist':'not-exist'; ?>">

								<span><?php _e('Posted on', 'pe-services'); ?> <span class="date updated"> <?php the_time('F d, Y'); ?></span></span>

								<span><?php _e('by', 'pe-services'); ?>
									<span class="vcard author-link author">
										<span class="fn"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author" title="<?php printf( __( 'View all posts by %s', 'pe-services' ), get_the_author_meta('display_name') ); ?>" >
											<?php echo get_the_author_meta('display_name'); ?>
										</a></span>
									</span>
									<?php _e('in', 'pe-services'); ?> <?php the_category(', '); ?>
									<?php edit_post_link(__("Edit Post", 'pe-services'), '<span> / </span>', ''); ?>
								</span>

							</div>
							<?php endif; ?>

						</div>
						<?php if (!empty( $single_post_thumb )) {?>
						<figure>
							<div class="pe-item-image">
								<img src="<?php echo esc_url( $single_post_thumb ); ?>" alt="<?php the_title(); ?>">
							</div>
						</figure>
						<?php } ?>
						<div class="pe-article-content">

							<?php the_content(); ?>

						</div>

						<?php
						wp_link_pages( array(
							'before'      => '<div class="pe-page-links clearfix">',
							'after'       => '</div>',
							'link_before' => '<span>',
							'link_after'  => '</span>',
						) );
						?>

						<?php the_posts_pagination( array(
							'mid_size' => 2,
							'prev_text' => __( 'Back', 'pe-services' ),
							'next_text' => __( 'Next', 'pe-services' ),
						) ); ?>

						<!-- Go to www.addthis.com/dashboard to customize your tools -->
						<div class="addthis_sharing_toolbox"></div>

						<?php //TAGS
						if ( has_tag() && $post_tags_single ) { ?>
						<div class='pe-post-tags'>
							<span class='title'><?php _e('Tags:', 'pe-services'); ?></span>

							<?php
																									 $tags = get_the_tags();
																									 $html = '<ul class="pe-tags">';
																									 foreach ( $tags as $tag ){
																										 $html .= '<li itemprop="keywords"><a href="' . get_tag_link( $tag->term_id ) . '" title="' . $tag->name . ' Tag" class="pe-tag ' . $tag->slug . '" rel="tag">' . $tag->name . '</a></li>';
																									 }
																									 $html .= '</ul>';
																									 echo $html;
							?>
						</div>
						<?php } ?>

						<?php if ( $author_info_single ) { ?>
						<div class="pe-author-info clearfix">
							<h3 class="pe-title"><?php _e('About Author', 'pe-services'); ?></h3>
							<div class="pe-author-in">
								<div class="pe-author-avatar"><?php echo get_avatar( get_the_author_meta( 'ID' ), 92 ); ?></div>
								<div class="pe-author-details">
									<div class="pe-author-name">
										<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author" title="<?php printf( __( 'View all posts by %s', 'pe-services' ), get_the_author_meta('display_name') ); ?>" >
											<span class="name"><?php echo get_the_author_meta('display_name'); ?></span>
										</a>
										<a href="<?php echo get_the_author_meta('user_url'); ?>" rel="external nofollow" class="url" target="_blank"><?php echo get_the_author_meta('user_url'); ?></a>
									</div>
									<div class="pe-author-desc"><?php echo get_the_author_meta('description'); ?></div>
								</div>
							</div>
						</div>
						<?php } ?>

						<?php
						if ( $comments_single ) {
							comments_template('',true);
						}
						?>
					</div>

					<?php
					endwhile;
					endif;
					?>

				</main>
				<!-- End of main content area -->

				<?php get_template_part( 'tpl/content-bottom' ); ?>

			</div>

			<?php get_sidebar(); ?>

		</div>

	</div>

</div>

<?php get_footer(); ?>
