<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$logo = peGetOptions('logo','url');

$offcanvas_sidebar = peGetOptions('off-canavs-sidebar');
$search_bar = peGetOptions('search-bar');

$retina_display = peGetOptions('retina-display-support');
$retina_logo = peGetOptions('retina-logo','url');
$retina_attr = ( $retina_display && $retina_logo ) ? ' data-at2x="' . $retina_logo . '"' : '';

//wcag
$nightVersion = peGetOptions('nightVersion');
$highContrast = peGetOptions('highContrast');
$wideSite = peGetOptions('wideSite');
$fontSizeSwitcher = peGetOptions('fontSizeSwitcher');

?>

<nav id="pe-skip-menu" <?php if(peGetOptions('skip-menu-label')) : ?>aria-label="<?php echo peGetOptions('skip-menu-label'); ?>"<?php endif; ?>>
	<?php if ( has_nav_menu('skip-menu') ) {
	wp_nav_menu(array(
		'theme_location' => 'skip-menu',
		'container_class' => 'pe-skip-menu',
	));
} ?>
</nav>

<header>

	<div id="pe-main-header">
	<?php if( is_home() || (is_front_page() && (!peGetOptions('front-page-content') || !peGetOptions('front-page-title'))) ) { ?>
	<h1 id="header-label" class="sr-only"><?php esc_attr( bloginfo('name') ); ?></h1>
	<?php } else { ?>
	<p id="header-label" class="sr-only"><?php esc_attr( bloginfo('name') ); ?></p>
	<?php } ?>
	<p id="header-description" class="sr-only"><?php esc_attr( bloginfo('description') ); ?></p>
	</div>

	<?php
	if (has_nav_menu( 'main-menu' ) or is_active_sidebar( 'top-bar-menu' ) or $logo or $nightVersion or $highContrast or $wideSite or $fontSizeSwitcher ) : ?>
	<div id="pe-bar">
		<div id="pe-bar-in">
			<?php if( is_active_sidebar('top-bar-menu') or $nightVersion or $highContrast or $wideSite or $fontSizeSwitcher) : ?>
			<div id="pe-top-bar">
				<div id="pe-top-bar-in" class="container-fluid">
					<?php dynamic_sidebar( 'top-bar-menu' ); ?>
					<?php get_template_part( 'tpl/wcag' ); ?>
				</div>
			</div>
			<?php endif; ?>

			<?php if ( has_nav_menu( 'main-menu' ) or $logo ) : ?>
			<div id="pe-logo-nav">
				<div id="pe-logo-nav-in" class="container-fluid">

					<?php if ( $logo ) : ?>
						<div id="pe-bar-left" class="pull-left clearfix">
							<div id="pe-logo">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="pe-logo" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>" <?php echo $retina_attr; ?>></a>
							</div>
						</div>
					<?php endif; ?>

					<?php if(( $offcanvas_sidebar ) or has_nav_menu( 'main-menu' )) : ?>
					<div id="pe-bar-right" class="pull-right text">

						<?php if ( has_nav_menu( 'main-menu' ) ) { ?>
						<nav id="pe-main-menu" class="pull-left pe-main-menu" <?php if($highContrast) echo 'tabindex="-1"'; ?> <?php if(peGetOptions('menu-label')) : ?>aria-label="<?php echo peGetOptions('menu-label'); ?>"<?php endif; ?>>
								<?php
								if ( function_exists( 'max_mega_menu_is_enabled' ) ) {
									wp_nav_menu( array( 'theme_location' => 'main-menu' ) );
								} else { ?>

										<div class="nav-toggle"><button aria-label="<?php _e('Mobile Menu', 'pe-services'); ?>">
											<span class="icon-menu">
												<span class="line line-1"></span>
												<span class="line line-2"></span>
												<span class="line line-3"></span>
											</span>
										</button></div>

										<?php wp_nav_menu(array(
											'theme_location' => 'main-menu',
											'container_class' => 'pe-nav-container',
											'menu_class' => 'nav-menu',
											'walker' => new PE_Main_Menu()
										)); ?>


								<?php } ?>
							</nav>
						<?php } ?>

						<?php if( $search_bar ) : ?>
						<div id="pe-search" class="pull-left visible-lg text-right">
							<?php get_search_form(); ?>
						</div>
						<?php endif; ?>

						<?php if( $offcanvas_sidebar ) : ?>
							<?php if(is_active_sidebar( 'off-canvas-sidebar' )) : ?>
							<div id="pe-offcanvas-button" class="pull-left visible-lg">
								<a href="#" class="toggle-nav open" tabindex="-1"><span class="fa fa-navicon" aria-hidden="true"></span><span class="sr-only"><?php _e('Offcanvas Sidebar', 'pe-services'); ?></span></a>
							</div>
							<?php endif; ?>
						<?php endif; ?>

					</div>
					<?php endif; ?>

				</div>

			</div>
			<?php endif; ?>
		</div>
	</div>
	<?php endif; ?>
</header>
