<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$image_effect_blog = peGetOptions('intro-effect-blog');
$image_effect_archive = peGetOptions('intro-effect-archive');

if ((is_home() && !empty($image_effect_blog)) || (is_archive() && !empty($image_effect_archive))) {
	$effect_class = 'effect';
} else {
	$effect_class = '';
}

if( is_search() ){
	$key = 's';
	$current = $s;
} elseif( is_category() ) {
	$key = 'cat';
	$current = get_query_var('cat');
} elseif( is_tag() ) {
	$key = 'tag';
	$current = get_query_var('tag');
} else {
	$key = 'cat';
	$current = '';
}

//normal posts
$per_page = get_option('posts_per_page');

$args = array(
		$key => $current,
		'posts_per_page' => $per_page,
		'paged' => $paged,
);

$wp_query = new WP_Query( $args );

$counter = 0;

$postcount = $wp_query->found_posts;
$col_class = ( $postcount == 1 ) ? 'col-sm-12' : 'col-sm-6';

while ( $wp_query->have_posts() ) : $wp_query->the_post();

	$counter++;

	if($counter % 2 == 1) { // Row Start on Even Article Numbers

		echo '<div class="pe-blog-row columns-2 ' . $effect_class . '"><div class="row clearfix">';

	}

	// Col Start
	echo '<div class="blog-col ' . $col_class . '">';

		get_template_part( 'tpl/posts-for-listing' );

	echo '</div>';
	// Col End

	// Row End on Odd Article Numbers or End of Articles
	if($counter % 2 == 0 || $counter == $wp_query->post_count && $wp_query->post_count % 2 ) {

		echo '</div></div>';

	}

endwhile;

pe_pagination( $wp_query->max_num_pages );

?>
