<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$highContrast = peGetOptions('highContrast');

if ( 
		 ( is_front_page() && peGetOptions('breadcrumb-front') ) //front-page
	|| ( !is_front_page() && !is_page_template('page-templates/page-services.php') && is_page() && peGetOptions('breadcrumb-page') ) //page
	|| ( is_archive() && peGetOptions('breadcrumb-archive') ) //archive
	|| ( !is_front_page() && is_home() && peGetOptions('breadcrumb-blog') ) //blog
	|| ( is_page_template('page-templates/page-services.php') && peGetOptions('breadcrumb-service') ) //services
	|| ( is_singular('post') && peGetOptions('breadcrumb-post') ) //single
	|| ( is_singular('member') && peGetOptions('breadcrumb-member') ) //single-member
	|| ( is_singular('testimonial') && peGetOptions('breadcrumb-testimonial') ) //single-testimonial
	
	) {
?>
<div id="pe-breadcrumbs" <?php if($highContrast) echo 'role="navigation" aria-label="breadcrumb"'; ?>>
	<div id="pe-breadcrumbs-in" class="container-fluid">
		<div id="pe-breadcrumbs-border">
			<ul class="pe-breadcrumb clearfix">
				<?php 
					$home_title = get_the_title( get_option('page_on_front') );
				?>
				<li>
					<span class="fa fa-home" aria-hidden="true"></span> <a href="<?php echo home_url(); ?>"><?php esc_html_e($home_title) ?></a>
				</li>
				<?php if (is_single() && has_category()) { ?>
					<?php 
						$category = get_the_category();
						$catlink = get_category_link( $category[0]->cat_ID );
							echo ('<li><a href="'.esc_url($catlink).'">'.esc_html($category[0]->cat_name).'</a></li><li class="active"><span>'.get_the_title().'<span class="sr-only">(current)</span></span></li>'); 
					?>
				<?php } elseif (is_single() && ! has_category()) { ?>
					<?php echo '<li class="active"><span>'; wp_title(''); echo '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } elseif (is_page()) { 
					$parent = get_post_ancestors($post->ID);
					if( !empty($parent) ) {
						echo '<li><a href="' . get_permalink($parent[0]) . '"><span>' . get_the_title( $parent[0] ) . '</span></a></li>';
					}
				?>
					<?php echo '<li class="active"><span>'; wp_title(''); echo '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } else if (is_category()) { ?>
					<?php echo '<li class="active"><span>'; single_cat_title(); echo '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } else if (is_author()) { $curauth = $wp_query->get_queried_object(); ?>
					<?php echo '<li class="active"><span>'; echo $curauth->display_name; '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } else if (is_tag()) { ?>
					<?php echo '<li class="active"><span>'; echo single_tag_title('',false); '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } else if (is_month()) { ?>
					<?php echo '<li class="active"><span>'; echo get_the_date('F Y'); '<span class="sr-only">(current)</span></span></li>'; ?>
				<?php } ?>
			</ul>
		</div>
	</div>
</div>
<?php
}
?>