<?php
/*--------------------------------------------------------------
Copyright (C) pixelemu.com
License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
Website: http://www.pixelemu.com
Support: info@pixelemu.com
---------------------------------------------------------------*/

//grid
get_template_part( 'layout-options' );

$logo = peGetOptions('logo','url');
$favicon = peGetOptions('favicon','url');

$comingsoondateFormat = date('j F Y', strtotime(peGetOptions('coming-soon-until-date')));

?>
<!DOCTYPE html>

<html <?php language_attributes(); // language attributes ?>>
	
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); // address pingback ?>">
		<!--[if lt IE 9]>
		<script src="<?php echo get_template_directory_uri(); ?>/js/html5shiv.js"></script>
		<![endif]-->
		<?php

		if( $favicon ) { ?>
			<link rel="icon" href="<?php echo esc_url( $favicon ); ?>" type="image/x-icon" />
			<link rel="shortcut icon" href="<?php echo esc_url( $favicon ); ?>" type="image/x-icon" />
		<?php } ?>

		<?php get_template_part( 'tpl/head-custom-code' ); ?>
		
		<?php wp_head(); ?>
	</head>

		<body <?php body_class( 'coming-soon' ); ?>>
			<!-- Begin of main page -->
			<div id="pe-main">
				<div id="pe-coming-soon">
					<div class="container-fluid">
						<div id="pe-logo">
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo ); ?>" alt="<?php bloginfo( 'name' ); ?>"></a>
						</div>

							<?php if(is_active_sidebar('coming-soon-sidebar')) : ?>
							<div id="pe-widget">
									<?php dynamic_sidebar( 'coming-soon-sidebar' ); ?>
							</div>
							<?php endif; ?>

							<!-- Begin of Count Down -->
							<div id="countdown">
									<p class="d">
											<span class="days">00</span>
											<span class="timeRefDays"><?php _e('days', 'pe-services'); ?></span>
									</p>

									<p>
											<span class="hours">00</span>
											<span class="timeRefHours"><?php _e('hours', 'pe-services'); ?></span>
									</p>

									<p>
											<span class="minutes">00</span>
											<span class="timeRefMinutes"><?php _e('minutes', 'pe-services'); ?></span>
									</p>

									<p>
											<span class="seconds">00</span>
											<span class="timeRefSeconds"><?php _e('seconds', 'pe-services'); ?></span>
									</p>
							</div>
							<!-- End of Count Down -->

					</div>
				</div>
			</div>

				<!-- Count Down Script -->
				<script type="text/javascript">
						/*
						* Basic Count Down to Date and Time
						* Author: @mrwigster / trulycode.com
						*/
						(function (e) {
								e.fn.countdown = function (t, n) {
								function i() {
										eventDate = Date.parse(r.date) / 1e3;
										currentDate = Math.floor(e.now() / 1e3);
										if (eventDate <= currentDate) {
												n.call(this);
												clearInterval(interval)
										}
										seconds = eventDate - currentDate;
										days = Math.floor(seconds / 86400);
										seconds -= days * 60 * 60 * 24;
										hours = Math.floor(seconds / 3600);
										seconds -= hours * 60 * 60;
										minutes = Math.floor(seconds / 60);
										seconds -= minutes * 60;
										days == 1 ? thisEl.find(".timeRefDays").text("<?php _e('day', 'pe-services'); ?>") : thisEl.find(".timeRefDays").text("<?php _e('days', 'pe-services'); ?>");
										hours == 1 ? thisEl.find(".timeRefHours").text("<?php _e('hour', 'pe-services'); ?>") : thisEl.find(".timeRefHours").text("<?php _e('hours', 'pe-services'); ?>");
										minutes == 1 ? thisEl.find(".timeRefMinutes").text("<?php _e('minute', 'pe-services'); ?>") : thisEl.find(".timeRefMinutes").text("<?php _e('minutes', 'pe-services'); ?>");
										seconds == 1 ? thisEl.find(".timeRefSeconds").text("<?php _e('second', 'pe-services'); ?>") : thisEl.find(".timeRefSeconds").text("<?php _e('seconds', 'pe-services'); ?>");
										if (r["format"] == "on") {
												days = String(days).length >= 2 ? days : "0" + days;
												hours = String(hours).length >= 2 ? hours : "0" + hours;
												minutes = String(minutes).length >= 2 ? minutes : "0" + minutes;
												seconds = String(seconds).length >= 2 ? seconds : "0" + seconds
										}
										if (!isNaN(eventDate)) {
												thisEl.find(".days").text(days);
												thisEl.find(".hours").text(hours);
												thisEl.find(".minutes").text(minutes);
												thisEl.find(".seconds").text(seconds)
										} else {
												alert("Invalid date. Example: 30 Tuesday 2013 15:50:00");
												clearInterval(interval)
										}
								}
								var thisEl = e(this);
								var r = {
										date: null,
										format: null
								};
								t && e.extend(r, t);
								i();
								interval = setInterval(i, 1e3)
								}
								})(jQuery);
								jQuery(document).ready(function () {
								function e() {
										var e = new Date;
										e.setDate(e.getDate() + 60);
										dd = e.getDate();
										mm = e.getMonth() + 1;
										y = e.getFullYear();
										futureFormattedDate = mm + "/" + dd + "/" + y;
										return futureFormattedDate
								}
								jQuery("#countdown").countdown({
										date: "<?php echo $comingsoondateFormat; ?>",
										format: "on"
								});
						});
				</script>

		<?php wp_footer(); ?>

		</body>

</html>