<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$post_info_blog = peGetOptions('post-info-blog');
$post_info_archive = peGetOptions('post-info-archive');

$thumbnail_blog = peGetOptions('post-thumbnail-blog');
$thumbnail_archive = peGetOptions('post-thumbnail-archive');

$readmore_blog = peGetOptions('readmore-blog');
$readmore_archive = peGetOptions('readmore-archive');

$image_effect_blog = peGetOptions('intro-effect-blog');
$image_effect_archive = peGetOptions('intro-effect-archive');

?>
<div <?php post_class(array('pe-article','clearfix')); ?>>

	<div class="page-header">
		<h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<?php if ( is_home() && $post_info_blog || is_archive() && $post_info_archive ) { ?>
		<div class="post-meta standard-meta thumb-<?php echo has_post_thumbnail() ? 'exist' : 'not-exist'; ?>">
			<span><?php _e('Posted on', 'pe-services'); ?> <span class="date updated"> <?php the_time('F d, Y'); ?></span></span>
			<span><?php _e('by', 'pe-services'); ?>
				<span class="vcard author author-link">
					<span class="fn"><a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author" title="<?php printf( __( 'View all posts by %s', 'pe-services' ), get_the_author_meta('display_name') ); ?>" >
						<?php echo get_the_author_meta('display_name'); ?>
					</a></span>
				</span>
				<?php if( has_category() ) : ?>
					<?php _e('in', 'pe-services'); ?> <?php the_category(', '); ?>
				<?php endif; ?>
				<?php edit_post_link(__("Edit", 'pe-services'), '<span> / </span>', ''); ?>
			</span>
		</div>
		<?php } ?>
	</div>

	<?php if ( (is_home() && $thumbnail_blog) || (is_archive() && $thumbnail_archive) ) { ?>

		<?php if ( has_post_thumbnail() ) { ?>

				<?php
				//display post with effect
				if((is_home() && !empty($image_effect_blog)) || (is_archive() && !empty($image_effect_archive)) ) { ?>

					<figure class="pe-item-image effect">
						<a href="<?php the_permalink(); ?>">
							<?php the_post_thumbnail('large'); ?>
						</a>
						<figcaption>
							<div class="intro">
							<?php if ( (is_home() && $readmore_blog) || (is_archive() && $readmore_archive) ) {
								if( strpos( $post->post_content, '<!--more-->' ) ) {
									the_content();
								} else {
									pe_blog_excerpt(55);
								}
							} else {
								the_content('',FALSE,'');
							} ?>
							</div>
						</figcaption>
					</figure>
				<?php } else {
				//display post without effect
				?>
					<figure>
							<div class="pull-left pe-item-image">
									<a href="<?php the_permalink(); ?>" class="" title="<?php the_title(); ?>">
											<?php the_post_thumbnail('large'); ?>
									</a>
							</div>
					</figure>

					<div class="pe-article-content">
						<?php if( (is_home() && $readmore_blog) || (is_archive() && $readmore_archive) ) {
							if( strpos( $post->post_content, '<!--more-->' ) ) {
								the_content();
							} else {
								pe_blog_excerpt(55);
							}
						} else {
							the_content('',FALSE,'');
						} ?>
					</div>

				<?php } ?>

		<?php } else { ?>
			<div class="pe-article-content">
				<?php if( (is_home() && $readmore_blog) || (is_archive() && $readmore_archive) ) {
					if( strpos( $post->post_content, '<!--more-->' ) ) {
						the_content();
					} else {
						pe_blog_excerpt(55);
					}
				} else {
					the_content('',FALSE,'');
				} ?>
			</div>
		<?php } ?>

	<?php } ?>

</div>
