<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$per_row = intval(get_post_meta(get_the_ID(), 'services_per_row', true));
$per_page = intval(get_post_meta(get_the_ID(), 'services_total', true));
$col_number = floor(12 / $per_row);

$categories = get_post_meta(get_the_ID(), 'service_categories', true);
$image_size = get_post_meta(get_the_ID(), 'thumbnails_size', true);
$item_height = get_post_meta(get_the_ID(), 'item_height', true);

$animation_type = get_post_meta(get_the_ID(), 'animation_type', true);
$animation_delay = get_post_meta(get_the_ID(), 'animation_delay', true);
$animation_interval = get_post_meta(get_the_ID(), 'animation_interval', true);

$highContrast = peGetOptions('highContrast');

if($animation_type=='none') {
	$animation_class = '';
} else {
	$animation_class = 'pe-animation';
}

$services_args = array(
		'post_type'       => 'service',
		'posts_per_page'  => $per_page,
		'paged'           => $paged,
		'tax_query'       => array(
		array(
				'taxonomy'  => 'service-category',
				'field'     => 'term_id',
				'terms'     => $categories
				)
		)
);

$services_carousel_query = new WP_Query( $services_args );

if($services_carousel_query->have_posts()): ?>

	<!-- Services carousel -->
	<div id="pe-services-carousel" class="pe-carousel schema-top">

		<!-- services indicators -->
		<div class="pe-indicators" <?php if($highContrast) echo 'role="complementary"'; ?>>
			<?php
			$i = 0;
			?>

				<!-- row   -->
				<div class="row">

				<?php while ($services_carousel_query->have_posts()): $services_carousel_query->the_post();
					$active_indicator = ($i === 0) ? 'active' : '';
					$service_id = '#pe-service-item-' . $i;
				 ?>

				 <?php
				 //animation delay
					if(!empty($animation_class) && $i > 0) {
						$animation_delay = ($animation_delay + $animation_interval);
					}
				 ?>

					<?php if($i !=0 && $i % ($per_row) == 0) { ?>
					</div>
					<!-- end row -->
					<!-- row   -->
					<div class="row">
					<?php } ?>

						<div class="indicator-<?php echo $i; ?> col-md-<?php echo $col_number; ?> <?php echo $animation_class; ?>" <?php if(!empty($animation_class)) { echo 'data-animation="' . $animation_type . '" data-animation-delay="' . $animation_delay . 'ms"'; } ?>>
							<a href="#<?php echo get_post_field( 'post_name'); ?>" class="pe-indicator <?php echo $active_indicator; ?>" data-slick-goto="<?php echo $i; ?>" onclick="jQuery('<?php echo $service_id; ?>').focus();" <?php if (!empty( $item_height )) { echo 'style="min-height:' . $item_height . '"'; } ?>>
								<?php if(has_post_thumbnail() && $image_size!='hide') { ?>
								<div class="pe-indicator-img">
									<?php the_post_thumbnail($image_size); ?>
								</div>
								<?php } ?>
								<div class="pe-indicator-description">
									<div class="pe-indicator-name"><?php the_title(); ?></div>
									<?php
									$service_subtitle = get_post_meta(get_the_ID(), 'service_subtitle',true);
									if( !empty($service_subtitle) ) { ?>
										<div class="pe-indicator-details"><?php echo get_post_meta(get_the_ID(), 'service_subtitle',true); ?></div>
									<?php } ?>
								</div>
							</a>
						</div>

					<?php
						$i++;
					?>

				<?php endwhile; ?>

				</div>
				<!-- end row -->

			<?php pe_pagination( $services_carousel_query->max_num_pages ); ?>

		</div>

		<!-- services content -->
		<?php
		$count = 0;
		?>

		<div class="pe-services-content pe-content" data-slick='{"fade": true, "swipe": false, "touchMove": false}'>
			<?php while ($services_carousel_query->have_posts()): $services_carousel_query->the_post();
				$active_content  = ($count === 0) ? 'active' : '';
			?>
			<article id="<?php echo get_post_field( 'post_name'); ?>" class="item-<?php echo $count; ?> pe-item <?php echo $active_content; ?>" aria-labelledby="<?php echo 'label-' . get_post_field( 'post_name'); ?>">
				<div class="pe-services">
						<h2 id="<?php echo 'label-' . get_post_field( 'post_name'); ?>" class="pe-services-title">
							<span class="service">
							<?php
							$service_categories = get_the_terms( $post->ID, 'service-category' );
							if($service_categories && ! is_wp_error( $service_categories )){
								foreach($service_categories as $service_category){
									echo $service_category->name . ' ';
								}
							}
							?>
							</span>
							<span class="title"><?php the_title(); ?></span>
						</h2>
					<div id="<?php echo 'slick-slide' . sprintf("%02d", $count); ?>" class="pe-services-item-desc"><?php the_content(); ?></div>

					<?php
					//members with selected service item (profession)
					$member_args = array(
							'post_type'       => 'member',
							'posts_per_page'  => -1,
							'meta_query' => array(
								array(
									'key' => 'member_profession',
									'value' => serialize($post->ID),
									'compare' => 'LIKE'
								)
							)
					);

					$member_carousel_query = new WP_Query( $member_args );

					if($member_carousel_query->have_posts()): ?>

					<div class="pe-services-members">
						<h3 class="pe-title"><?php _e('Available specialists', 'pe-services'); ?></h3>
						<ul>
						<?php while ($member_carousel_query->have_posts()): $member_carousel_query->the_post(); ?>
							<li><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title(); ?></a></li>
						<?php
						endwhile;
						?>
						</ul>
					</div>

					<?php endif; ?>

				</div>
			</article>

			<?php
				$count++;
			?>

			<?php endwhile; ?>
		</div>
	</div>

<?php wp_reset_query(); else: ?>
<div class="pe-article-content" itemprop="articleBody">
	<?php _e('No Services Found!', 'pe-services'); ?>
</div>
<?php endif; ?>
