<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

$nightVersion = peGetOptions('nightVersion');
$highContrast = peGetOptions('highContrast');
$wideSite = peGetOptions('wideSite');
$fontSizeSwitcher = peGetOptions('fontSizeSwitcher');

if($nightVersion or $highContrast or $wideSite or $fontSizeSwitcher) : ?>
<div id="pe-wcag" class="pe-widget-raw">
	<ul class="pe-wcag-settings clearfix">
		<?php if($nightVersion or $highContrast) : ?>
		<li class="contrast">
			<ul>
				<li class="separator contrast-label"><?php _e('Contrast', 'pe-services'); ?></li>
				<li><button class="pe-normal" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?contrast=normal', 'pe-services' ) ); ?>"><span class="fa fa-sun-o" aria-hidden="true"></span><span class="sr-only"><?php _e('Default contrast', 'pe-services'); ?></span></button></li>
				<?php if($nightVersion) : ?>
				<li><button data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?contrast=night', 'pe-services' ) ); ?>" class="pe-night"><span class="fa fa-moon-o" aria-hidden="true"></span><span class="sr-only"><?php _e('Night contrast', 'pe-services'); ?></span></button></li>
				<?php endif; ?>
				<?php if($highContrast) : ?>
				<li><button class="pe-highcontrast" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?contrast=highcontrast', 'pe-services' ) ); ?>"><span class="fa fa-eye" aria-hidden="true"></span><span class="sr-only"><?php _e('Black and White contrast', 'pe-services'); ?></span></button></li>
				<li><button class="pe-highcontrast2" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?contrast=highcontrast2', 'pe-services' ) ); ?>"><span class="fa fa-eye" aria-hidden="true"></span><span class="sr-only"><?php _e('Black and Yellow contrast', 'pe-services'); ?></span></button></li>
				<li><button class="pe-highcontrast3" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?contrast=highcontrast3', 'pe-services' ) ); ?>"><span class="fa fa-eye" aria-hidden="true"></span><span class="sr-only"><?php _e('Yellow and Black contrast', 'pe-services'); ?></span></button></li>
				<?php endif; ?>
			</ul>
		</li>
		<?php endif; ?>
		<?php if($wideSite) : ?>
		<li class="page-width">
			<ul>
				<li class="separator page-width-label"><?php _e('Layout', 'pe-services'); ?></li>
				<li><button class="pe-fixed" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?width=fixed', 'pe-services' ) ); ?>"><span class="fa fa-compress" aria-hidden="true"></span><span class="sr-only"><?php _e('Fixed layout', 'pe-services'); ?></span></button></li>
				<li><button class="pe-wide" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?width=wide', 'pe-services' ) ); ?>"><span class="fa fa-expand" aria-hidden="true"></span><span class="sr-only"><?php _e('Wide layout', 'pe-services'); ?></span></button></li>
			</ul>
		</li>
		<?php endif; ?>
		<?php if($fontSizeSwitcher) : ?>
		<li class="resizer">
			<ul>
				<li class="separator resizer-label"><?php _e('Font', 'pe-services'); ?></li>
				<li><button class="pe-font-smaller" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?fontsize=70', 'pe-services' ) ); ?>"><span class="fa fa-minus-circle" aria-hidden="true"></span><span class="sr-only"><?php _e('Smaller Font', 'pe-services'); ?></span></button></li>
				<li><button class="pe-font-larger" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?fontsize=130', 'pe-services' ) ); ?>"><span class="fa fa-plus-circle" aria-hidden="true"></span><span class="sr-only"><?php _e('Larger Font', 'pe-services'); ?></span></button></li>
				<li><button class="pe-font-readable"><span class="fa fa-text-width" aria-hidden="true"></span><span class="sr-only"><?php _e('Readable Font', 'pe-services'); ?></span></button></li>
				<li><button class="pe-font-normal" data-href="<?php echo esc_url( home_url( '/' ) . __( 'index.php?fontsize=100', 'pe-services' ) ); ?>"><span class="fa fa-undo" aria-hidden="true"></span><span class="sr-only"><?php _e('Default Font', 'pe-services'); ?></span></button></li>
			</ul>
		</li>
		<?php endif; ?>
	</ul>
</div>
<?php endif; ?>
