<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/* Services post type */
if( !function_exists( 'pe_create_service_post_type' ) ) {
	function pe_create_service_post_type() {
		$labels = array(
			'name' 								=> __('Services', 'pe-services-plugin'),
			'singular_name' 			=> __('Service', 'pe-services-plugin'),
			'add_new' 						=> __('Add New', 'pe-services-plugin'),
			'add_new_item' 				=> __('Add New Service', 'pe-services-plugin'),
			'edit_item' 					=> __('Edit Service', 'pe-services-plugin'),
			'new_item' 						=> __('New Service', 'pe-services-plugin'), 
			'view_item' 					=> __('View Service', 'pe-services-plugin'),
			'search_items' 				=> __('Search Service', 'pe-services-plugin'),
			'not_found' 					=> __('No Service found', 'pe-services-plugin'),
			'not_found_in_trash' 	=> __('No Service found in Trash', 'pe-services-plugin'),
			'parent_item_colon' 	=> ''
		);

		$args = array(
			'labels' 							=> $labels,
			'public' 							=> true,
			'exclude_from_search' => true,
			'publicly_queryable' 	=> true, 
			'show_ui' 						=> true,
			'query_var' 					=> true,
			'capability_type' 		=> 'post',
			'hierarchical' 				=> false,
			'menu_position' 			=> 5,
			'menu_icon' 					=> get_template_directory_uri() . '/images/admin/services.png',
			'show_in_nav_menus'		=> false,
			'supports' 						=> array('title', 'editor', 'thumbnail', 'revisions'),
			'rewrite' 						=> array('slug' => __('service', 'pe-services-plugin') )
		);

		register_post_type('service', $args);
	}

}
add_action('init', 'pe_create_service_post_type');

/* Create Services Taxonomies */
if (!function_exists('pe_taxonomies')) {
	function pe_taxonomies() {

		$services_category = array(
			'name' 											 => __('Service Categories', 'pe-services-plugin'),
			'singular_name' 						 => __('Service Category', 'pe-services-plugin'),
			'search_items' 							 => __('Search Service Categories', 'pe-services-plugin'),
			'popular_items' 						 => __('Popular Service Categories', 'pe-services-plugin'),
			'all_items' 								 => __('All Service Categories', 'pe-services-plugin'),
			'parent_item' 							 => __('Parent Service Category', 'pe-services-plugin'),
			'parent_item_colon' 				 => __('Parent Service Category:', 'pe-services-plugin'),
			'edit_item' 								 => __('Edit Service Category', 'pe-services-plugin'),
			'update_item' 							 => __('Update Service Category', 'pe-services-plugin'),
			'add_new_item' 							 => __('Add New Service Category', 'pe-services-plugin'),
			'new_item_name' 						 => __('New Service Category Name', 'pe-services-plugin'),
			'separate_items_with_commas' => __('Separate Service Categories with commas', 'pe-services-plugin'),
			'add_or_remove_items' 			 => __('Add or remove Service Categories', 'pe-services-plugin'),
			'choose_from_most_used' 		 => __('Choose from the most used Service Categories', 'pe-services-plugin'),
			'menu_name' 								 => __('Service Categories', 'pe-services-plugin')
		);

		register_taxonomy(
			'service-category', array('service'), 
			array(
				'hierarchical' 	=> true,
				'labels' 						=> $services_category,
				'show_ui' 					=> true,
				'show_in_nav_menus' => false,
				'query_var' 				=> true,
				'rewrite' 					=> array('slug' => __('service-category', 'pe-services-plugin'))
			)
		);
	}

}
add_action('init', 'pe_taxonomies', 0);

/* Edit Default Columns */
if (!function_exists('pe_service_edit_columns')) {
	function pe_service_edit_columns($columns) {

		$columns = array(
										'cb' => '<input type="checkbox" />',
										'title' => __('Service', 'pe-services-plugin'),
										'category' => __('Service Category', 'pe-services-plugin'),
										'date' => __('Date', 'pe-services-plugin')
										);

		return $columns;
	}

}
add_filter('manage_edit-service_columns', 'pe_service_edit_columns');

/* Add Custom Column */
if (!function_exists('pe_service_custom_columns')) {
	function pe_service_custom_columns($column) {
		global $post;
		switch ($column) {
			case 'category' :
				echo get_the_term_list($post -> ID, 'service-category', '', ', ', '');
				break;
		}
	}

}
add_action('manage_service_posts_custom_column', 'pe_service_custom_columns');

/* image box */
if (!function_exists('pe_service_image_box')) {
	function pe_service_image_box() {
		remove_meta_box( 'postimagediv', 'service', 'side' );
		add_meta_box('postimagediv', __('Service image', 'pe-services-plugin'), 'post_thumbnail_meta_box', 'service', 'side', 'low');
	}
}
add_filter('do_meta_boxes', 'pe_service_image_box');

/* title text */
if (!function_exists('pe_service_enter_title')) {
	function pe_service_enter_title( $input ) {
		global $post_type;

		if ( is_admin() && 'service' == $post_type )
				return __( 'Enter Service Name here', 'pe-services-plugin' );
		return $input;
	}
}
add_filter( 'enter_title_here', 'pe_service_enter_title' );

?>