<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );
/**
 * Plugin Name: PE Services Plugin
 * Plugin URI: http://pixelemu.com
 * Description: Taxonomies and shortcodes for PE Services Theme
 * Version: 1.01
 * Author: pixelemu.com
 * Author URI: http://www.pixelemu.com
 * Text Domain: PixelEmu
 * License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 */

/*-----------------------------------------------------------------------------------*/
/*	Languages
/*-----------------------------------------------------------------------------------*/
 
add_action('plugins_loaded', 'pe_services_load_textdomain');
function pe_services_load_textdomain() {
	load_plugin_textdomain( 'pe-services-plugin', false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
}
 
/*-----------------------------------------------------------------------------------*/
/*	Shortcode Clean Function
/*-----------------------------------------------------------------------------------*/
 
add_filter('the_content', 'pe_clean_shortcodes');
if (!function_exists('pe_clean_shortcodes')) {
	function pe_clean_shortcodes( $content ){   
		// array of custom shortcodes requiring the fix (no affect to 3rd party shortcodes)
		$block = join('|',array('accordion','row','col', 'headline', 'pricing_table', 'tabs', 'tab', 'testimonial' ));
		// opening tag
		$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
			
		// closing tag
		$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
		return $rep;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Include Custom Post Types
/*-----------------------------------------------------------------------------------*/

include("custom-posts/member-post-type.php");
include("custom-posts/faq-post-type.php");
include("custom-posts/service-post-type.php");
include("custom-posts/testimonial-post-type.php");

/*-----------------------------------------------------------------------------------*/
/*	Include Shortcodes
/*-----------------------------------------------------------------------------------*/

include 'shortcodes/animation.php';
include 'shortcodes/pricing-table.php';
include 'shortcodes/accordion.php';
include 'shortcodes/tabs.php';
include 'shortcodes/columns.php';
include 'shortcodes/testimonials.php';
include 'shortcodes/video-gallery.php';
include 'shortcodes/image-gallery.php';
include 'shortcodes/pe_map.php';
include 'shortcodes/pe_headline.php';

?>