<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
 ---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	PE Headline
/*-----------------------------------------------------------------------------------*/

		function comma_separated_to_array($string, $separator = ',') {
			//Explode on comma
			$vals = explode($separator, $string);
		 
			//Trim whitespace
			foreach($vals as $key => $val) {
				$vals[$key] = trim($val);
			}
			return array_diff($vals, array(""));
		}

		add_shortcode('headline', 'pe_headline');
		
		if (!function_exists('pe_headline')) {
			function pe_headline($atts, $content = null) {

			$a = shortcode_atts(
				array(
					'subtitle'    => '',
					'class'    => '',
				), $atts);
			
				$headline_class = (!empty($a['class'])) ? $a['class'] : '';
			
				$output = '<div class="cd-intro ' . sanitize_html_class($headline_class) . '"><h1 class="cd-headline loading-bar">';
				
				if(!empty($content)) {
					$output .= '<span class="cd-desc">';
						$output .= do_shortcode( $content );
					$output .= '</span>';
				}

				if(!empty($a['subtitle'])) {
					$count = 0;
					$subttile_array = comma_separated_to_array($a['subtitle']);
					$output .= '<span class="cd-words-wrapper">';
					foreach($subttile_array as $value) {
						if($count == 0) {
							$output .= '<b class="is-visible">' . esc_attr($value) . '</b>';
						} else {
							$output .= '<b>' . esc_attr($value) . '</b>';
						}
						$count ++;
					}
					$output .= '</span>';
				}
				
				$output .= '</h1></div>';

				return $output;
			}
		} 
?>