<?php
/*--------------------------------------------------------------
 Copyright (C) pixelemu.com
 License: http://www.pixelemu.com/license.html PixelEmu Proprietary Use License
 Website: http://www.pixelemu.com
 Support: info@pixelemu.com
---------------------------------------------------------------*/

/*-----------------------------------------------------------------------------------*/
/*	Google Map
/*-----------------------------------------------------------------------------------*/

add_shortcode( 'pe_map', 'pe_map_shortcode' );

if (!function_exists('pe_map_shortcode')) {
	function pe_map_shortcode( $atts ) {

		$atts = shortcode_atts(
			array(
				'address'           => false,
				'latitude'          => false,
				'longitude'         => false,
				'width'             => '100%',
				'height'            => '400px',
				'enablescrollwheel' => 'false',
				'disablecontrols'   => 'false',
				'zoom'              => 16,
			),
			$atts
		);

		$address = esc_attr($atts['address']);

		if( $address || ($atts['latitude'] && $atts['longitude']) ) :

			if($atts['latitude'] && $atts['longitude']) {
				$coordinates['lat'] = $atts['latitude'];
				$coordinates['lng'] = $atts['longitude'];
			} else {
				function pe_map_get_coordinates( $address, $force_refresh = false ) {

					$address_hash = md5( $address );

					$coordinates = get_transient( $address_hash );

					if ($force_refresh || $coordinates === false) {

						$args = array( 'address' => urlencode( $address ), 'sensor' => 'false' );
						$url = add_query_arg( $args, 'http://maps.googleapis.com/maps/api/geocode/json' );
						$response = wp_remote_get( $url );

						if( is_wp_error( $response ) )
							return;

						$data = wp_remote_retrieve_body( $response );

						if( is_wp_error( $data ) )
							return;

					if ( $response['response']['code'] == 200 ) {

						$data = json_decode( $data );

						if ( $data->status === 'OK' ) {

								$coordinates = $data->results[0]->geometry->location;

								$cache_value['lat'] 	= $coordinates->lat;
								$cache_value['lng'] 	= $coordinates->lng;
								$cache_value['address'] = (string) $data->results[0]->formatted_address;

								// cache coordinates
								set_transient($address_hash, $cache_value, 3600*24*30*1);
								$data = $cache_value;

						} elseif ( $data->status === 'ZERO_RESULTS' ) {
								return __( 'Invalid address.', 'pe-services-plugin' );
						} elseif( $data->status === 'INVALID_REQUEST' ) {
								return __( 'Invalid request.', 'pe-services-plugin' );
						} else {
							return __( 'Please ensure you have entered the short code correctly.', 'pe-services-plugin' );
						}

					} else {
						return __( 'Unable to connect with Google API service.', 'pe-services-plugin' );
					}

					} else {
						$data = $coordinates;
					}
					return $data;
				}
				
				$coordinates = pe_map_get_coordinates( $address );
			}
			
			if( !is_array( $coordinates ) )
				return;

			$map_id = uniqid( 'pe_map_' ); // generate a unique ID for this map
			ob_start();
			?>
			
			<div class="pe_map_canvas" id="<?php echo esc_attr( $map_id ); ?>" style="height: <?php echo esc_attr( $atts['height'] ); ?>; width: <?php echo esc_attr( $atts['width'] ); ?>"></div>
			<script type="text/javascript">
				var map_<?php echo $map_id; ?>;
				function pe_map_<?php echo $map_id ; ?>() {
					var location = new google.maps.LatLng("<?php echo $coordinates['lat']; ?>", "<?php echo esc_attr($coordinates['lng']); ?>");
					var map_options = {
						zoom: <?php echo esc_attr($atts['zoom']); ?>,
						center: location,
						scrollwheel: <?php echo 'true' === strtolower( $atts['enablescrollwheel'] ) ? '1' : '0'; ?>,
						disableDefaultUI: <?php echo 'true' === strtolower( $atts['disablecontrols'] ) ? '1' : '0'; ?>,
						mapTypeId: google.maps.MapTypeId.ROADMAP
					}
					map_<?php echo $map_id ; ?> = new google.maps.Map(document.getElementById("<?php echo $map_id ; ?>"), map_options);
					var marker = new google.maps.Marker({
					position: location,
					map: map_<?php echo $map_id ; ?>
					});
				}
				pe_map_<?php echo $map_id ; ?>();
			</script>
			<?php
			return ob_get_clean();
		else :
			return __( 'Google Maps API not loaded', 'pe-services-plugin' );
		endif;
	}
}

function pe_map_css() {
	echo '<style type="text/css">.pe_map_canvas img { max-width: none; } </style>';
}
add_action( 'wp_head', 'pe_map_css' );

?>